/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.mailUtils;

import com.cognos.jsmcommon.mailUtils.MailAction;
import com.cognos.jsmcommon.mailUtils.NCActionableMail;
import com.cognos.jsmcommon.mailUtils.NCPop3Session;
import com.cognos.jsmcommon.mailUtils.Pop3Action;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;

public final class NCPop3Service
extends NCActionableMail
implements Runnable {
    private long DEFAULT_UP_DELAY = 5L;
    private long DEFAULT_DOWN_DELAY = 3600L;
    private static final String FOLDER_NAME = "Inbox";
    private static NCPop3Service m_instance;
    boolean m_shouldContinue = false;
    private Thread m_mailServiceThread;
    private NCPop3Session m_mail_session;
    private Properties m_properties;

    public static synchronized NCPop3Service testInstance(Properties props) {
        m_instance = new NCPop3Service(props);
        return m_instance;
    }

    public static synchronized NCPop3Service instance() {
        if (m_instance == null) {
            m_instance = new NCPop3Service(null);
        }
        return m_instance;
    }

    public static boolean isStarted() throws MessagingException {
        return m_instance != null && NCPop3Service.m_instance.m_shouldContinue;
    }

    public boolean isConnected() throws MessagingException {
        return this.getMailSession().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Folder folder = null;
        while (this.m_shouldContinue) {
            try {
                Object actions = new MailAction[]{};
                NCPop3Service nCPop3Service = this;
                synchronized (nCPop3Service) {
                    while (((MailAction[])(actions = this.getActions())).length == 0) {
                        this.wait();
                    }
                }
                folder = this.getMailSession().getMailFolder(FOLDER_NAME);
                if (folder == null) continue;
                folder.open(2);
                if (folder.getMessageCount() > 0) {
                    Message[] messages = this.getMessages(folder, true);
                    for (int messageIndex = 0; messageIndex < messages.length; ++messageIndex) {
                        boolean messageMatch = false;
                        boolean deleteMessage = false;
                        for (int actionIndex = 0; actionIndex < ((MailAction[])actions).length; ++actionIndex) {
                            if (actions[actionIndex] == null) continue;
                            deleteMessage = deleteMessage || (messageMatch |= actions[actionIndex].invoke(messages[messageIndex])) && ((Pop3Action)actions[actionIndex]).deleteMailOnMatch();
                        }
                        if (!messageMatch) continue;
                        if (deleteMessage) {
                            messages[messageIndex].setFlag(Flags.Flag.DELETED, true);
                            continue;
                        }
                        messages[messageIndex].setFlag(Flags.Flag.SEEN, true);
                    }
                }
                folder.close(true);
                for (int actionIndex = 0; actionIndex < ((MailAction[])actions).length; ++actionIndex) {
                    if (actions[actionIndex] == null || !actions[actionIndex].isFinished()) continue;
                    this.removeAction(actions[actionIndex]);
                }
            }
            catch (FolderClosedException messaging_exception) {
                try {
                    folder.close(true);
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                messaging_exception.printStackTrace();
                this.m_shouldContinue = false;
            }
            catch (Exception messaging_exception) {
                if (messaging_exception instanceof InterruptedException) continue;
                messaging_exception.printStackTrace();
                this.m_shouldContinue = false;
            }
            finally {
                if (folder == null || !folder.isOpen()) continue;
                try {
                    folder.close(true);
                    NCPop3Service messaging_exception = this;
                    synchronized (messaging_exception) {
                        this.wait(this.getSleepInterval(this.getMailSession().isConnected()));
                    }
                }
                catch (Exception messaging_exception) {}
            }
        }
    }

    @Override
    public void stop() {
        this.m_shouldContinue = false;
        try {
            if (this.m_mailServiceThread != null) {
                this.m_mailServiceThread.interrupt();
                this.m_mailServiceThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_mailServiceThread = null;
    }

    @Override
    public void start() {
        if (this.m_shouldContinue) {
            return;
        }
        this.m_shouldContinue = true;
        this.m_mailServiceThread = new Thread((Runnable)this, "MailServiceThread");
        this.m_mailServiceThread.setDaemon(true);
        this.m_mailServiceThread.start();
    }

    private Message[] getMessages(Folder folder, boolean onlyUnread) throws MessagingException {
        Message[] messages = new Message[]{};
        if (onlyUnread) {
            FlagTerm searchTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            messages = folder.search((SearchTerm)searchTerm);
        } else {
            messages = folder.getMessages();
        }
        return messages;
    }

    private NCPop3Session getMailSession() {
        if (this.m_mail_session == null) {
            this.m_mail_session = new NCPop3Session(this.m_properties);
        }
        return this.m_mail_session;
    }

    private long getSleepInterval(boolean serverUp) {
        long delay = this.DEFAULT_DOWN_DELAY;
        try {
            if (serverUp && this.getActions().length > 0) {
                delay = this.DEFAULT_UP_DELAY;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delay * 1000L;
    }

    private NCPop3Service(Properties props) {
        this.m_properties = props;
    }
}

