/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.mailUtils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;

final class NCPop3Session {
    private static final transient String m_PROTOCOL = "pop3";
    private Properties m_properties = null;
    private Store m_store;
    private HashMap m_folders = new HashMap();
    public static final String POP3_HOST = "mail.pop3.host";
    public static final String POP3_PASSWORD = "mail.pop3.password";
    public static final String POP3_USER = "mail.pop3.user";
    public static final String POP3_PORT = "mail.pop3.port";

    NCPop3Session() {
    }

    NCPop3Session(Properties props) {
        this.m_properties = props;
    }

    boolean isConnected() throws MessagingException {
        return this.getMailSession() != null;
    }

    Folder getMailFolder(String folderName) throws MessagingException {
        Folder folder = (Folder)this.m_folders.get(folderName);
        if (folder == null) {
            this.getMailSession();
            if (this.isConnected()) {
                folder = this.getMailSession().getFolder(folderName);
                this.m_folders.put(folderName, folder);
            }
        } else if (!this.isConnected()) {
            folder = null;
            this.m_folders.remove(folderName);
        }
        return folder;
    }

    Store getMailSession() throws MessagingException {
        if (this.m_store != null && this.m_store.isConnected()) {
            return this.m_store;
        }
        try {
            this.m_store = this.getNewSession().getStore(m_PROTOCOL);
            this.m_store.connect();
        }
        catch (MessagingException messaging_exception) {
            if (this.m_store != null) {
                Store tmpStore = this.m_store;
                this.m_store = null;
                tmpStore.close();
            }
            throw messaging_exception;
        }
        return this.m_store;
    }

    private Session getNewSession() {
        if (this.m_properties == null) {
            try {
                Class<?> propsfactory = Class.forName("com.cognos.dls.smtp.SMTPPropertiesFactory");
                Method m = propsfactory.getMethod("getProperties", new Class[0]);
                Object o = m.invoke(null, new Object[0]);
                this.m_properties = (Properties)o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Session.getDefaultInstance((Properties)this.m_properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(NCPop3Session.this.m_properties.getProperty(NCPop3Session.POP3_USER), NCPop3Session.this.m_properties.getProperty(NCPop3Session.POP3_PASSWORD));
            }
        });
    }
}

