/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.mailUtils;

import com.cognos.jsmcommon.mailUtils.MailAction;
import com.cognos.jsmcommon.mailUtils.NCActionableMail;
import com.cognos.jsmcommon.mailUtils.SmtpAction;
import com.sun.mail.smtp.SMTPMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import javax.mail.Message;
import org.apache.commons.io.IOUtils;

public class NCSmtpService
extends NCActionableMail
implements Runnable {
    public static final String SMTP_PORT_KEY = "mail.smtp.port";
    private static final String DEFAULT_SMTP_PORT = "25";
    private static final String SMTP_LOG_FILE = "test.smtp.logFile";
    private static final String DEFAULT_SMTP_LOG_FILE = "./smtpLog.log";
    private static final String QUIT = "QUIT";
    private static final String NOOP = "NOOP";
    private static final String BYE = "221 Bye";
    private static Properties DEFAULT_PROPS = new Properties();
    private static NCSmtpService m_instance;
    private boolean m_server_running = false;
    private boolean m_bound = false;
    private int m_port;
    private ServerSocket m_server_socket = null;
    private Thread m_mailServiceThread;
    private boolean m_doAuthFail = false;
    private Throwable m_error;
    private Properties m_properties;
    private boolean verbose = false;

    public static synchronized NCSmtpService testInstance(Properties props) {
        if (m_instance != null) {
            try {
                m_instance.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        m_instance = new NCSmtpService(props);
        return m_instance;
    }

    public static synchronized NCSmtpService instance() {
        if (m_instance == null) {
            m_instance = new NCSmtpService(DEFAULT_PROPS);
        }
        return m_instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.m_server_socket = new ServerSocket(this.m_port);
        }
        catch (IOException e) {
            this.m_error = e;
            this.m_server_running = false;
        }
        this.m_bound = true;
        Socket connection_socket = null;
        while (true) {
            block13: {
                if (!this.m_server_running) {
                    return;
                }
                try {
                    this.m_server_socket.setSoTimeout(100000);
                    connection_socket = this.m_server_socket.accept();
                    connection_socket.setSoTimeout(100000);
                    if (!this.m_server_running) {
                    }
                    break block13;
                }
                catch (IOException io_exception) {
                    this.closeConnections(connection_socket);
                }
                continue;
            }
            try {
                this.doMailHandshake(connection_socket);
                this.processAction(connection_socket);
                continue;
            }
            catch (SMTPConversationFinishedException io_exception) {
                continue;
            }
            catch (Throwable t) {
                this.m_error = t;
                continue;
            }
            finally {
                this.closeConnections(connection_socket);
                continue;
            }
            break;
        }
    }

    private void doMailHandshake(Socket connection_socket) throws Exception {
        String response = null;
        String helo = "220 TEST.SMTP Simple Mail Transfer Service Ready\n";
        response = this.respondAndRead(connection_socket, helo, true);
        String auth = "250-Welcome [127.0.0.1], pleased to meet you\n250-AUTH=LOGIN\n250-SIZE 5242880\n250 HELP\n";
        response = this.respondAndRead(connection_socket, auth, true);
        if (this.m_doAuthFail || response != null && response.indexOf("MAIL FROM") == -1) {
            if (this.m_doAuthFail) {
                String success = "535 Authentication failed\n";
                response = this.respondAndRead(connection_socket, success, true);
                throw new SMTPConversationFinishedException(success);
            }
            String success = "235 Authentication successful\n";
            this.respondAndRead(connection_socket, success, true);
        }
        String ok = "250 Sender \"noticecast@cognos.com\" OK...\n";
        response = this.respondAndRead(connection_socket, ok, true);
        String rcpt2 = "250 Recipient \"nc_user2@cognos.com\" OK...\n";
        response = this.respondAndRead(connection_socket, rcpt2, true);
        String enter = "354 Enter mail, end with \".\" on a line by itself\n";
        this.respondAndRead(connection_socket, enter, false);
    }

    private String respondAndRead(Socket connection_socket, String handShakeString, boolean readResponse) throws Exception {
        String response = null;
        if (this.verbose) {
            System.out.println("Sending: " + handShakeString);
        }
        connection_socket.getOutputStream().write(handShakeString.getBytes());
        if (readResponse) {
            InputStreamReader isr = new InputStreamReader(connection_socket.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            try {
                response = br.readLine();
            }
            catch (IOException e) {
                if (this.verbose) {
                    System.out.println("RECEIVED connection error. No response from server.");
                }
                throw e;
            }
            if (this.verbose) {
                System.out.println("Received: " + response);
            }
            if (QUIT.equalsIgnoreCase(response)) {
                connection_socket.getOutputStream().write(BYE.getBytes());
                throw new SMTPConversationFinishedException(response);
            }
            if (NOOP.equalsIgnoreCase(response)) {
                connection_socket.getOutputStream().write("250 OK".getBytes());
                throw new SMTPConversationFinishedException(response);
            }
        }
        return response;
    }

    private synchronized void processAction(Socket s) throws Exception {
        MailAction[] actions = this.getActions();
        if (actions.length == 0) {
            this.respondAndRead(s, "451 Requested action aborted: error in processing", false);
            return;
        }
        String messageString = this.readMessage(s.getInputStream());
        SMTPMessage message = new SMTPMessage(null, IOUtils.toInputStream((String)messageString, (String)"UTF-8"));
        boolean matched = false;
        for (int i = 0; i < actions.length; ++i) {
            matched = actions[i].invoke((Message)message);
            if (!matched) continue;
            ((SmtpAction)actions[i]).respond(s);
            if (!actions[i].isFinished()) break;
            this.removeAction(actions[i]);
            break;
        }
        if (!matched) {
            this.respondAndRead(s, "250 OK", false);
        }
    }

    private String readMessage(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer("");
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        do {
            if ((line = br.readLine()) == null) continue;
            if (line.startsWith(".") && line.length() == 1) break;
            sb.append(line);
            sb.append("\n");
        } while (line != null && line != "");
        return sb.toString();
    }

    private void closeConnections(Socket connection_socket) {
        try {
            if (connection_socket == null) {
                return;
            }
            if (connection_socket.getOutputStream() != null) {
                connection_socket.getOutputStream().close();
            }
            if (connection_socket.getInputStream() != null) {
                connection_socket.getInputStream().close();
            }
            connection_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.m_server_running = false;
        try {
            if (this.m_mailServiceThread != null) {
                this.m_mailServiceThread.interrupt();
                this.m_mailServiceThread.join();
                this.m_server_socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() throws Exception {
        if (this.m_server_running) {
            return;
        }
        this.m_server_running = true;
        try {
            this.m_port = Integer.valueOf(this.m_properties.getProperty(SMTP_PORT_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_mailServiceThread = new Thread((Runnable)this, "SmtpMailServiceThread");
        this.m_mailServiceThread.setDaemon(true);
        this.m_mailServiceThread.start();
        while (!this.m_bound && this.m_server_running) {
            Thread.sleep(50L);
        }
        if (this.m_error != null) {
            throw new Exception(this.m_error);
        }
    }

    public static boolean isServerRunning() {
        return m_instance != null && NCSmtpService.m_instance.m_server_running;
    }

    public Throwable getError() {
        return this.m_error;
    }

    public void doAuthenticationFail(boolean fail) {
        this.m_doAuthFail = fail;
    }

    private NCSmtpService(Properties props) {
        this.m_properties = props;
    }

    static {
        DEFAULT_PROPS.put(SMTP_PORT_KEY, DEFAULT_SMTP_PORT);
        DEFAULT_PROPS.put(SMTP_LOG_FILE, DEFAULT_SMTP_LOG_FILE);
    }

    private class SMTPConversationFinishedException
    extends Exception {
        public SMTPConversationFinishedException(String message) {
            super(message);
        }
    }
}

