/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.metrics;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.metrics.GlobalQueueMetricsMBean;
import com.cognos.jsmcommon.metrics.IPersistedQueueMetrics;
import com.cognos.jsmcommon.metrics.Metric;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Date;

public abstract class GlobalQueueMetrics
implements GlobalQueueMetricsMBean {
    public static final String LAST_RESET_TIME = "lastResetTime";
    public static final String QUEUE_LENGTH_HIGH_WATER_MARK = "queueLengthHighWaterMark";
    public static final String QUEUE_LENGTH_LOW_WATER_MARK = "queueLengthLowWaterMark";
    public static final String TIME_IN_QUEUE_HIGH_WATER_MARK = "timeInQueueHighWaterMark";
    public static final String TIME_IN_QUEUE_LOW_WATER_MARK = "timeInQueueLowWaterMark";
    public static final String TIME_IN_QUEUE = "timeInQueue";
    public static final String NUMBER_OF_REQUESTS = "numberOfRequests";
    public static final String ENABLE_TIDE_METRICS_PREFIX = "enable.tide.metrics.";
    private String m_lastResetTime;
    private String m_queueLengthHighWaterMark;
    private String m_queueLengthLowWaterMark;
    private String m_timeInQueueHighWaterMark;
    private String m_timeInQueueLowWaterMark;
    private String m_timeInQueue;
    private String m_numberOfRequests;
    private boolean m_tideMetricsActive = false;
    private boolean m_tideMetricsActiveConfigOverride = false;
    private IPersistedQueueMetrics m_pqm;
    private String m_queueName;

    public GlobalQueueMetrics(String queueName, IPersistedQueueMetrics pqm) {
        this.m_queueName = queueName;
        this.m_pqm = pqm;
    }

    public void initPersistedMetrics() {
        this.m_lastResetTime = this.m_queueName + "." + LAST_RESET_TIME;
        this.m_queueLengthHighWaterMark = this.m_queueName + "." + QUEUE_LENGTH_HIGH_WATER_MARK;
        this.m_queueLengthLowWaterMark = this.m_queueName + "." + QUEUE_LENGTH_LOW_WATER_MARK;
        this.m_timeInQueueHighWaterMark = this.m_queueName + "." + TIME_IN_QUEUE_HIGH_WATER_MARK;
        this.m_timeInQueueLowWaterMark = this.m_queueName + "." + TIME_IN_QUEUE_LOW_WATER_MARK;
        this.m_timeInQueue = this.m_queueName + "." + TIME_IN_QUEUE;
        this.m_numberOfRequests = this.m_queueName + "." + NUMBER_OF_REQUESTS;
        Metric metric = this.m_pqm.registerMetric(this.m_queueLengthHighWaterMark, 0L);
        if (metric != null) {
            this.m_tideMetricsActive = metric.isActive();
        } else {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Unable to register tide metrics");
        }
        this.m_pqm.registerMetric(this.m_queueLengthLowWaterMark, Long.MAX_VALUE);
        this.m_pqm.registerMetric(this.m_timeInQueueHighWaterMark, 0L);
        this.m_pqm.registerMetric(this.m_timeInQueueLowWaterMark, Long.MAX_VALUE);
        this.m_pqm.registerMetric(this.m_timeInQueue, 0L);
        this.m_pqm.registerMetric(this.m_numberOfRequests, 0L);
        this.m_pqm.registerMetric(this.m_lastResetTime, new Date().getTime());
        this.reset();
    }

    @Override
    public Date getGlobalLastResetTime() {
        long timeLong = this.m_pqm.getMetricValue(this.m_lastResetTime);
        return new Date(timeLong);
    }

    @Override
    public long getGlobalQueueLengthHighWaterMark() {
        return this.m_pqm.getMetricValue(this.m_queueLengthHighWaterMark);
    }

    @Override
    public Date getGlobalQueueLengthHighWaterMarkLastUpdateTime() {
        return this.m_pqm.getMetricLastModTime(this.m_queueLengthHighWaterMark);
    }

    @Override
    public long getGlobalQueueLengthLowWaterMark() {
        long time = this.m_pqm.getMetricValue(this.m_queueLengthLowWaterMark);
        if (time == Long.MAX_VALUE) {
            return 0L;
        }
        return time;
    }

    @Override
    public Date getGlobalQueueLengthLowWaterMarkLastUpdateTime() {
        return this.m_pqm.getMetricLastModTime(this.m_queueLengthLowWaterMark);
    }

    @Override
    public long getTimeInGlobalQueueHighWaterMark() {
        return this.m_pqm.getMetricValue(this.m_timeInQueueHighWaterMark);
    }

    @Override
    public Date getTimeInGlobalQueueHighWaterMarkLastUpdateTime() {
        return this.m_pqm.getMetricLastModTime(this.m_timeInQueueHighWaterMark);
    }

    @Override
    public long getTimeInGlobalQueueLowWaterMark() {
        long time = this.m_pqm.getMetricValue(this.m_timeInQueueLowWaterMark);
        if (time == Long.MAX_VALUE) {
            return 0L;
        }
        return time;
    }

    @Override
    public Date getTimeInGlobalQueueLowWaterMarkLastUpdateTime() {
        return this.m_pqm.getMetricLastModTime(this.m_timeInQueueLowWaterMark);
    }

    @Override
    public synchronized void enableGlobalTideMetrics(boolean enable) {
        if (!this.m_tideMetricsActiveConfigOverride) {
            this.enableGlobalTideMetricsImpl(enable);
        }
    }

    @Override
    public long getTimeInGlobalQueue() {
        return this.m_pqm.getMetricValue(this.m_timeInQueue);
    }

    @Override
    public Date getTimeInGlobalQueueLastUpdateTime() {
        return this.m_pqm.getMetricLastModTime(this.m_timeInQueue);
    }

    @Override
    public long getNumberOfGlobalRequests() {
        return this.m_pqm.getMetricValue(this.m_numberOfRequests);
    }

    @Override
    public Date getNumberOfGlobalRequestsLastUpdateTime() {
        return this.m_pqm.getMetricLastModTime(this.m_numberOfRequests);
    }

    @Override
    public void reset() {
        long currentQueueLength = this.getGlobalQueueLength();
        this.m_pqm.resetMetricValue(this.m_lastResetTime, new Date().getTime());
        this.m_pqm.resetMetricValue(this.m_queueLengthHighWaterMark, currentQueueLength);
        this.m_pqm.resetMetricValue(this.m_queueLengthLowWaterMark, Long.MAX_VALUE);
        this.m_pqm.resetMetricValue(this.m_timeInQueueHighWaterMark, 0L);
        this.m_pqm.resetMetricValue(this.m_timeInQueueLowWaterMark, Long.MAX_VALUE);
        this.m_pqm.resetMetricValue(this.m_timeInQueue, 0L);
        this.m_pqm.resetMetricValue(this.m_numberOfRequests, 0L);
    }

    public void updateQueueLengthHighWaterMark(long metricValue) {
        if (this.m_tideMetricsActive) {
            this.m_pqm.updateMetricHighWaterMark(this.m_queueLengthHighWaterMark, metricValue);
        }
    }

    public void updateQueueLengthLowWaterMark(long metricValue) {
        if (this.m_tideMetricsActive) {
            this.m_pqm.updateMetricLowWaterMark(this.m_queueLengthLowWaterMark, metricValue);
        }
    }

    public void updateTimeInQueueHighWaterMark(long metricValue) {
        if (this.m_tideMetricsActive) {
            this.m_pqm.updateMetricHighWaterMark(this.m_timeInQueueHighWaterMark, metricValue);
        }
    }

    public void updateTimeInQueueLowWaterMark(long metricValue) {
        if (this.m_tideMetricsActive) {
            this.m_pqm.updateMetricLowWaterMark(this.m_timeInQueueLowWaterMark, metricValue);
        }
    }

    public void incrementTimeInQueue(long metricValue) {
        if (this.m_tideMetricsActive) {
            this.m_pqm.incrementMetricValue(this.m_timeInQueue, metricValue);
        }
    }

    public void incrementNumberOfRequests(long metricValue) {
        if (this.m_tideMetricsActive) {
            this.m_pqm.incrementMetricValue(this.m_numberOfRequests, metricValue);
        }
    }

    public boolean tideMetricsActive() {
        return this.m_tideMetricsActive;
    }

    public synchronized void configure(CRNProperties properties) {
        try {
            String enableTideMetricsString = properties.getProperty(ENABLE_TIDE_METRICS_PREFIX + this.m_queueName.toLowerCase());
            if (enableTideMetricsString != null) {
                boolean tideMetricsActive = Boolean.valueOf(enableTideMetricsString);
                this.m_tideMetricsActiveConfigOverride = true;
                this.enableGlobalTideMetricsImpl(tideMetricsActive);
            } else if (this.m_tideMetricsActiveConfigOverride) {
                this.m_tideMetricsActiveConfigOverride = false;
                this.enableGlobalTideMetricsImpl(false);
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error configuring metrics: " + e);
        }
    }

    private void enableGlobalTideMetricsImpl(boolean enable) {
        if (enable != this.m_tideMetricsActive) {
            this.m_pqm.enableMetric(this.m_queueLengthHighWaterMark, enable);
            this.m_pqm.enableMetric(this.m_queueLengthLowWaterMark, enable);
            this.m_pqm.enableMetric(this.m_timeInQueueHighWaterMark, enable);
            this.m_pqm.enableMetric(this.m_timeInQueueLowWaterMark, enable);
            this.m_pqm.enableMetric(this.m_timeInQueue, enable);
            this.m_pqm.enableMetric(this.m_numberOfRequests, enable);
        }
        this.m_tideMetricsActive = enable;
    }
}

