/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.metrics;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MetricsManager {
    private static MetricsManager m_instance = new MetricsManager();
    private boolean m_canRegisterMBeans = true;

    private MetricsManager() {
    }

    public static MetricsManager getInstance() {
        return m_instance;
    }

    public void enableRegistration(boolean enable) {
        this.m_canRegisterMBeans = enable;
    }

    public void registerMBean(Object mBean, String serviceName, String metricName) {
        if (!this.m_canRegisterMBeans) {
            return;
        }
        try {
            ObjectName objName = PogoMBeanServer.getObjectName((String)serviceName, (String)metricName);
            PogoMBeanServer.getInstance().getServer().registerMBean(mBean, objName);
        }
        catch (MalformedObjectNameException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (InstanceAlreadyExistsException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (MBeanRegistrationException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (NotCompliantMBeanException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
    }

    public void unregisterMBean(String serviceName, String metricName) {
        try {
            ObjectName objName = PogoMBeanServer.getObjectName((String)serviceName, (String)metricName);
            PogoMBeanServer.getInstance().getServer().unregisterMBean(objName);
        }
        catch (MalformedObjectNameException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (InstanceNotFoundException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (MBeanRegistrationException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
    }
}

