/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.metrics;

import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.metrics.IPersistedQueueMetrics;
import com.cognos.jsmcommon.metrics.Metric;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class PersistedQueueMetrics
implements IPersistedQueueMetrics {
    private static String NAME = "NAME";
    private static String VALUE = "VALUE";
    private static String ACTIVE = "ACTIVE";
    private static String LASTMOD_TIME = "LASTMOD_TIME";
    private static String SQL_GET_METRIC_VALUE = "SELECT VALUE FROM NC_METRICS WHERE NAME = ?";
    private static String SQL_GET_METRIC_LASTMOD_TIME = "SELECT LASTMOD_TIME FROM NC_METRICS WHERE NAME = ?";
    private static String SQL_GET_METRIC = "SELECT * FROM NC_METRICS WHERE NAME = ?";
    private static final String SQL_INSERT_METRIC = "INSERT INTO NC_METRICS (NAME,LASTMOD_TIME,VALUE) VALUES (?,?,?)";
    private static final String SQL_INCREMENT_TIDE_METRIC = "UPDATE NC_METRICS SET LASTMOD_TIME = ?, VALUE = ? WHERE NAME = ? AND VALUE < ?";
    private static final String SQL_DECREMENT_TIDE_METRIC = "UPDATE NC_METRICS SET LASTMOD_TIME = ?, VALUE = ? WHERE NAME = ? AND VALUE > ?";
    private static final String SQL_UPDATE_METRIC_VALUE = "UPDATE NC_METRICS SET LASTMOD_TIME = ?, VALUE = ? WHERE NAME = ?";
    private static final String SQL_INCREMENT_METRIC_VALUE = "UPDATE NC_METRICS SET LASTMOD_TIME = ?, VALUE = VALUE + ? WHERE NAME = ?";
    private static final String SQL_ENABLE_QUEUE_METRIC = "UPDATE NC_METRICS SET ACTIVE = ? WHERE NAME = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMetricValue(String metricName) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long metricValue = 0L;
        try {
            conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            ps = conn.prepareStatement(SQL_GET_METRIC_VALUE);
            ps.setString(1, metricName);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                metricValue = rs.getLong(VALUE);
            }
            this.closeResources(conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, rs);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, rs);
                throw throwable;
            }
        }
        return metricValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getMetricLastModTime(String metricName) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Date metricValue = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            ps = conn.prepareStatement(SQL_GET_METRIC_LASTMOD_TIME);
            ps.setString(1, metricName);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                metricValue = new Date(rs.getLong(LASTMOD_TIME));
            }
            this.closeResources(conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, rs);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, rs);
                throw throwable;
            }
        }
        return metricValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metric getMetric(String metricName) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Metric metric = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            ps = conn.prepareStatement(SQL_GET_METRIC);
            ps.setString(1, metricName);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                String name = rs.getString(NAME);
                long lastModTime = rs.getLong(LASTMOD_TIME);
                long value = rs.getLong(VALUE);
                boolean isActive = rs.getInt(ACTIVE) == 1;
                metric = new Metric(name, new Date(lastModTime), value, isActive);
            }
            this.closeResources(conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, rs);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, rs);
                throw throwable;
            }
        }
        return metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementMetricValue(String metricName, long metricValue) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(SQL_INCREMENT_METRIC_VALUE);
            ps.setLong(1, new Date().getTime());
            ps.setLong(2, metricValue);
            ps.setString(3, metricName);
            ps.executeUpdate();
            this.closeResources(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetMetricValue(String metricName, long metricValue) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("PersistedQueueMetrics.resetMetricValue");
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(SQL_UPDATE_METRIC_VALUE);
            ps.setLong(1, new Date().getTime());
            ps.setLong(2, metricValue);
            ps.setString(3, metricName);
            ps.executeUpdate();
            this.closeResources(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, null);
                zipiTimer.stop();
                throw throwable;
            }
            zipiTimer.stop();
        }
        zipiTimer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableMetric(String metricName, boolean enable) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        int activeInt = enable ? 1 : 0;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(SQL_ENABLE_QUEUE_METRIC);
            ps.setInt(1, activeInt);
            ps.setString(2, metricName);
            ps.executeUpdate();
            this.closeResources(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMetricHighWaterMark(String metricName, long metricValue) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(SQL_INCREMENT_TIDE_METRIC);
            ps.setLong(1, new Date().getTime());
            ps.setLong(2, metricValue);
            ps.setString(3, metricName);
            ps.setLong(4, metricValue);
            ps.executeUpdate();
            this.closeResources(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMetricLowWaterMark(String metricName, long metricValue) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = NCConnection.instance().getConnectionFactory().createConnection();
            ps = conn.prepareStatement(SQL_DECREMENT_TIDE_METRIC);
            ps.setLong(1, new Date().getTime());
            ps.setLong(2, metricValue);
            ps.setString(3, metricName);
            ps.setLong(4, metricValue);
            ps.executeUpdate();
            this.closeResources(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                this.closeResources(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.closeResources(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metric registerMetric(String metricName, long initialValue) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("PersistedQueueMetrics.registerMetric");
        try {
            Metric metric = this.getMetric(metricName);
            if (metric == null) {
                JDBCConnection conn = null;
                PreparedStatement ps = null;
                try {
                    conn = NCConnection.instance().getConnectionFactory().createConnection();
                    ps = conn.prepareStatement(SQL_INSERT_METRIC);
                    ps.setString(1, metricName);
                    ps.setLong(2, new Date().getTime());
                    ps.setLong(3, initialValue);
                    ps.executeUpdate();
                    metric = new Metric(metricName, new Date(), initialValue, false);
                    this.closeResources(conn, ps, null);
                }
                catch (SQLException e) {
                    try {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                        this.closeResources(conn, ps, null);
                    }
                    catch (Throwable throwable) {
                        this.closeResources(conn, ps, null);
                        throw throwable;
                    }
                }
            }
            Metric metric2 = metric;
            return metric2;
        }
        finally {
            zipiTimer.stop();
        }
    }

    private void closeResources(JDBCConnection conn, PreparedStatement ps, ResultSet rs) {
        SqlResourceCloser.closeResources(rs, ps);
        SqlResourceCloser.releaseConnection(conn);
    }
}

