/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.nminusone;

import com.cognos.jsmcommon.nminusone.TargetServiceInfo;
import java.util.ArrayList;

public class TargetServiceInfoFactory {
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVER_GROUP = "serverGroup";
    public static final String NUM_THREADS = "numThreads";
    public static final int DEFAULT_NUM_THREADS = 2;

    public static TargetServiceInfo[] getTargetServiceInfo(String infoString) {
        ArrayList<TargetServiceInfo> infosList = new ArrayList<TargetServiceInfo>();
        String[] infos = infoString.split(";");
        for (int i = 0; i < infos.length; ++i) {
            TargetServiceInfo tsi = TargetServiceInfoFactory.getOneTargetServiveInfo(infos[i]);
            if (tsi == null) continue;
            infosList.add(tsi);
        }
        return infosList.toArray(new TargetServiceInfo[infosList.size()]);
    }

    private static TargetServiceInfo getOneTargetServiveInfo(String oneInfoString) {
        String serviceName = null;
        String serverGroup = "";
        int numThreads = 2;
        String[] params = oneInfoString.split(",");
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("=");
            if (param.length != 2) continue;
            param[0] = param[0].trim();
            param[1] = param[1].trim();
            if (param[0].equalsIgnoreCase(SERVICE_NAME)) {
                serviceName = param[1];
                continue;
            }
            if (param[0].equalsIgnoreCase(SERVER_GROUP)) {
                serverGroup = param[1];
                continue;
            }
            if (!param[0].equalsIgnoreCase(NUM_THREADS) || param[1] == null) continue;
            try {
                numThreads = Integer.valueOf(param[1]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TargetServiceInfo tsi = null;
        if (serviceName != null) {
            tsi = new TargetServiceInfo(serviceName, serverGroup, numThreads);
        }
        return tsi;
    }
}

