/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.objectid;

import com.cognos.jsmcommon.objectid.GuidNCIdImpl;
import com.cognos.jsmcommon.objectid.INCId;
import com.cognos.jsmcommon.objectid.IdGenerator;
import com.cognos.jsmcommon.util.HexFormatter;
import java.net.InetAddress;
import java.security.MessageDigest;

public final class GuidIdGenerator
extends IdGenerator {
    private static int m_hostUnique = GuidIdGenerator.getHostUniqueNum();
    private static String m_host_ip = GuidIdGenerator.getHostAddress();
    private static long m_lastTime = System.currentTimeMillis();
    private static short m_lastCount = Short.MIN_VALUE;
    private static Object m_mutex = new Object();
    private static final long m_ONE_SECOND = 1000L;
    private static final int m_OID_LENGTH = 32;
    private static final String m_OID_CHARS = "0123456789abcdefABCDEF";

    @Override
    public INCId getNewId() {
        return GuidIdGenerator.createNew();
    }

    public static GuidNCIdImpl createNew() {
        String id = m_host_ip + GuidIdGenerator.getRmiServerUID();
        id = id.toUpperCase();
        return new GuidNCIdImpl(id);
    }

    public static GuidNCIdImpl createNew(GuidNCIdImpl rhs) {
        return new GuidNCIdImpl(rhs.getId());
    }

    public static GuidNCIdImpl createNew(String id) {
        GuidNCIdImpl ret_value = null;
        if (GuidIdGenerator.validOidString(id)) {
            ret_value = new GuidNCIdImpl(id);
        }
        return ret_value;
    }

    public static GuidNCIdImpl createNew(int i1, int i2, int i3, int i4) {
        String id = new String(HexFormatter.toHex(i1, 2) + HexFormatter.toHex(i2, 2) + HexFormatter.toHex(i3, 2) + HexFormatter.toHex(i4, 2)).toUpperCase();
        return new GuidNCIdImpl(id);
    }

    public static boolean validOidString(String oid_string) {
        boolean ret_value = true;
        if (oid_string.length() != 32) {
            ret_value = false;
        }
        for (int i = 0; i < 32 && ret_value; ++i) {
            ret_value = m_OID_CHARS.indexOf(oid_string.charAt(i)) > -1;
        }
        return ret_value;
    }

    static String getHostAddress() {
        return GuidIdGenerator.getHostAddress(null);
    }

    static String getHostAddress(InetAddress myAdr) {
        String addressCode = null;
        try {
            if (myAdr == null) {
                myAdr = InetAddress.getLocalHost();
            }
            byte[] addressBytes = myAdr.getAddress();
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] md2Bytes = digest.digest(addressBytes);
            byte[] uniform = new byte[]{(byte)(md2Bytes[0] + md2Bytes[1] + md2Bytes[2] + md2Bytes[3] + md2Bytes[4]), (byte)(md2Bytes[5] + md2Bytes[6] + md2Bytes[7] + md2Bytes[8] + md2Bytes[9]), (byte)(md2Bytes[10] + md2Bytes[11] + md2Bytes[12] + md2Bytes[13] + md2Bytes[14]), (byte)(md2Bytes[15] + md2Bytes[16] + md2Bytes[17] + md2Bytes[18] + md2Bytes[19])};
            addressCode = "";
            for (int i = 0; i < uniform.length; ++i) {
                addressCode = addressCode + HexFormatter.toHex(uniform[i], 2);
            }
        }
        catch (Exception e) {
            addressCode = "7f000001";
        }
        return addressCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getRmiServerUID() {
        long time = 0L;
        short count = 0;
        Object object = m_mutex;
        synchronized (object) {
            if (m_lastCount == Short.MAX_VALUE) {
                boolean done = false;
                while (!done) {
                    time = System.currentTimeMillis();
                    if (time < m_lastTime + 1000L) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    m_lastTime = time;
                    m_lastCount = Short.MIN_VALUE;
                    done = true;
                }
            } else {
                time = m_lastTime;
            }
            int unique = m_hostUnique;
            short s = m_lastCount;
            m_lastCount = (short)(s + 1);
            count = s;
            return HexFormatter.toHex(unique, 8) + HexFormatter.toHex(time, 12) + HexFormatter.toHex(count, 4);
        }
    }

    private static int getHostUniqueNum() {
        return new Object().hashCode();
    }
}

