/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.objectid;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.ObjectIdConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.INCId;
import com.cognos.jsmcommon.objectid.IdGenerator;
import com.cognos.jsmcommon.objectid.LongNCIdImpl;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class JDBCIdGenerator
extends IdGenerator {
    private static final long MAXCLASSID = 1000L;
    private static long mLongId = 0L;
    private static final String sInitQuery = "SELECT MAX(NC_OBJECTCATALOGUE.PK_OID) FROM NC_OBJECTCATALOGUE";
    private static final String sUpdate = "UPDATE NC_OBJECTID SET OBJECTID = OBJECTID + " + Long.toString(1000L);
    private static final String sQuery = "SELECT NC_OBJECTID.OBJECTID FROM NC_OBJECTID";

    @Override
    public synchronized INCId getNewId() {
        if (mLongId < 1L) {
            JDBCIdGenerator.staticInit();
        }
        if (mLongId % 1000L == 0L) {
            JDBCIdGenerator.staticInit();
            JDBCIdGenerator.getIdFromDatabase();
        }
        return new LongNCIdImpl(++mLongId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void getIdFromDatabase() {
        JDBCConnection connection = null;
        Statement myStatement = null;
        ObjectIdConnection idConn = new ObjectIdConnection(){};
        try {
            connection = NCConnection.instance().getConnectionFactory().createConnection(idConn);
            connection.setAutoCommit(false);
            myStatement = connection.createStatement();
            if (myStatement.executeUpdate(sUpdate) < 1) {
                throw new SQLException("failed to update nc_objectid");
            }
            connection.commit();
        }
        catch (SQLException ex) {
            try {
                try {
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace(System.err);
                    AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_ROLLBACK_ERROR, ap);
                }
                AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ID_CREATE_EXCP, ap);
                throw new IllegalStateException(I18NUtil.getMessage(I18NCode.MSG_ID_CREATE_EXCP, SDSLogger.getLocale()));
            }
            catch (Throwable throwable) {
                try {
                    SqlResourceCloser.closeResources(null, myStatement);
                    NCConnection.instance().getConnectionFactory().releaseConnection(connection);
                    throw throwable;
                }
                catch (SQLException ex2) {
                    String errMsg = "could not close resources";
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex2);
                    AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, ap);
                    throw new IllegalStateException("could not close resources");
                }
            }
        }
        try {
            SqlResourceCloser.closeResources(null, myStatement);
            NCConnection.instance().getConnectionFactory().releaseConnection(connection);
            return;
        }
        catch (SQLException ex) {
            String errMsg = "could not close resources";
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, ap);
            throw new IllegalStateException("could not close resources");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void staticInit() {
        JDBCConnection connection = null;
        Statement myStatement = null;
        ResultSet resultSet = null;
        try {
            long maxId = mLongId;
            connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            myStatement = connection.createStatement();
            resultSet = myStatement.executeQuery(sInitQuery);
            if (resultSet.next()) {
                maxId = resultSet.getLong(1);
            }
            resultSet.close();
            resultSet = myStatement.executeQuery(sQuery);
            long theId = mLongId;
            if (resultSet.next()) {
                theId = resultSet.getLong(1);
            }
            if (resultSet.next()) {
                String warnMsg = "there are more than one row in NC_OBJECTCATALOGUE";
                AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Warning");
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{warnMsg}, ap);
            }
            mLongId = maxId > theId ? maxId : theId;
        }
        catch (Exception e) {
            try {
                String errMsg = "NC_ObjectIdSlave:init:  could not close resources. ";
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, ap);
                throw new IllegalStateException("NC_ObjectIdSlave:init:  could not close resources. ");
            }
            catch (Throwable throwable) {
                try {
                    SqlResourceCloser.closeResources(resultSet, myStatement);
                    NCConnection.instance().getConnectionFactory().releaseConnection(connection);
                    throw throwable;
                }
                catch (SQLException ex) {
                    String errMsg = "could not close resources. ";
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
                    AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, ap);
                    throw new IllegalStateException("could not close resources. ");
                }
            }
        }
        try {
            SqlResourceCloser.closeResources(resultSet, myStatement);
            NCConnection.instance().getConnectionFactory().releaseConnection(connection);
            return;
        }
        catch (SQLException ex) {
            String errMsg = "could not close resources. ";
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            AuditProperties ap = AuditPropUtil.doProps(JDBCIdGenerator.class, "Failure");
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, ap);
            throw new IllegalStateException("could not close resources. ");
        }
    }
}

