/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.objectid;

import com.cognos.jsmcommon.objectid.AbstractNCObjectIdCreator;
import com.cognos.jsmcommon.objectid.INCId;
import com.cognos.jsmcommon.objectid.INCObjectIdString;
import com.cognos.jsmcommon.objectid.IdGenerator;
import com.cognos.jsmcommon.objectid.LongNCIdImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class LongIdCreatorImpl
extends AbstractNCObjectIdCreator {
    @Override
    public INCId recreate(Object id) {
        Long lId = (Long)id;
        return new LongNCIdImpl(lId);
    }

    @Override
    public INCId createNew() {
        return IdGenerator.getIdGenerator().getNewId();
    }

    @Override
    public void setIntoStatement(INCId ncId, int index, PreparedStatement ps) throws SQLException {
        if (ncId == null) {
            ps.setNull(index, 4);
        } else {
            LongNCIdImpl id = (LongNCIdImpl)ncId;
            ps.setLong(index, id.getId());
        }
    }

    @Override
    public void setIntoStatement(INCId ncId, StringBuffer statement) {
        if (ncId == null) {
            statement.append("NULL");
        } else {
            LongNCIdImpl id = (LongNCIdImpl)ncId;
            statement.append(id.getId());
        }
    }

    @Override
    public INCId valueOf(ResultSet rs, int index) throws SQLException {
        long id = rs.getLong(index);
        if (rs.wasNull()) {
            return null;
        }
        return this.recreate(new Long(id));
    }

    @Override
    public INCId valueOf(ResultSet rs, String column) throws SQLException {
        long id = rs.getLong(column);
        if (rs.wasNull()) {
            return null;
        }
        return this.recreate(new Long(id));
    }

    @Override
    public INCId valueOf(INCObjectIdString idStr) {
        INCId result = null;
        if (idStr == null) {
            return result;
        }
        String str = idStr.getNCObjectIdString();
        return this.valueOf(str);
    }

    @Override
    public INCId valueOf(String idStr) {
        INCId result = null;
        if (idStr == null) {
            return result;
        }
        Long id = null;
        try {
            id = Long.valueOf(idStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id != null) {
            result = this.recreate(id);
        }
        return result;
    }
}

