/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.property;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.AbstractPropertiesManager;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractReportNetProps
extends AbstractPropertiesManager {
    static final String NAME_TAG = "name";
    static final String VALUE_TAG = "value";
    protected static boolean DECRYPT = true;
    protected static boolean RESOLVE = true;
    private Properties m_properties = new Properties();

    @Override
    public void storeProperties(String filename, Properties props) throws PropertiesException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".storeProperties(String filename, Properties props)");
    }

    @Override
    public void resetStatus() {
    }

    @Override
    public String getProperty(String key) throws PropertiesException {
        return this.m_properties.getProperty(key);
    }

    public int getIntProperty(String key, int defaultVal) {
        int val = defaultVal;
        try {
            String s = CRNProperties.getInstance().getProperty(key);
            val = s == null ? defaultVal : Integer.valueOf(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return val;
    }

    @Override
    public Properties getProperties(String fileName) throws PropertiesException {
        Properties addOnPropFile = new Properties();
        try {
            FileInputStream input = new FileInputStream(fileName);
            addOnPropFile.load(input);
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(this.getClass().getName() + " " + fileName + " not found ");
        }
        Properties origProps = this.getProperties();
        Enumeration<Object> keys = addOnPropFile.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            origProps.put(key, addOnPropFile.get(key));
        }
        return origProps;
    }

    @Override
    public synchronized String setProperty(String key, String value) {
        String old_value = this.m_properties.getProperty(key);
        this.m_properties.setProperty(key, value);
        return old_value;
    }

    public synchronized Object removeProperty(Object key) {
        return this.m_properties.remove(key);
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    protected Element searchForNamedProperty(Element element, String paramName, PropertyType propertyType, boolean deep) {
        if (element == null) {
            return element;
        }
        Iterator elementIterator = element.elements().iterator();
        Element theElementToFind = null;
        while (elementIterator.hasNext() && theElementToFind == null) {
            Element childElement = (Element)elementIterator.next();
            String nodeName = childElement.getName();
            Attribute nameAttr = childElement.attribute(NAME_TAG);
            if (nameAttr != null && paramName.equals(nameAttr.getValue()) && nodeName.equals(propertyType.name())) {
                theElementToFind = childElement;
                break;
            }
            if (!deep) continue;
            theElementToFind = this.searchForNamedProperty(childElement, paramName, propertyType, deep);
        }
        return theElementToFind;
    }

    protected synchronized void initFromElement(Element anElement) {
        List paramElements = anElement.elements();
        for (Element paramElement : paramElements) {
            Attribute att = paramElement.attribute(NAME_TAG);
            if (att != null) {
                String name = att.getValue();
                if (!this.hasChildElements(paramElement)) {
                    String value = paramElement.elementText(VALUE_TAG);
                    this.setProperty(name, value);
                }
            }
            this.storeCredentials(paramElement, "");
        }
    }

    protected synchronized void initFromElement(Element anElement, String propertyName) {
        if (anElement == null) {
            return;
        }
        List paramElements = anElement.elements();
        for (Element paramElement : paramElements) {
            String name;
            Attribute att = paramElement.attribute(NAME_TAG);
            if (att == null || !(name = att.getValue()).equals(propertyName)) continue;
            String value = paramElement.elementText(VALUE_TAG);
            this.setProperty(name, value);
            return;
        }
    }

    protected boolean hasChildElements(Element elmt) {
        int s = elmt.elements().size();
        Iterator it = elmt.elements().iterator();
        if (it.hasNext()) {
            Element elmt2 = (Element)it.next();
            s = elmt2.elements().size();
            Iterator it2 = elmt2.elements().iterator();
            if (it2.hasNext()) {
                return true;
            }
        }
        return false;
    }

    protected void storeCredentials(Element paramElement, String prefix) {
        if (!paramElement.elements().iterator().hasNext()) {
            return;
        }
        List paramElements = paramElement.elements();
        for (Element valueElement : paramElements) {
            this.storeAttribute(valueElement, "encryptTemporaryFiles");
            for (Element cred : valueElement.elements()) {
                for (Element credChildElement : cred.elements()) {
                    String value = credChildElement.getText();
                    if (value == null) continue;
                    String name = credChildElement.getQualifiedName();
                    this.setProperty(prefix + name, value);
                }
            }
        }
    }

    protected void storeAttribute(Element paramElement, String name) {
        Attribute att = paramElement.attribute(name);
        if (att != null) {
            String value = att.getValue();
            this.setProperty(name, value);
        }
    }

    protected void storeParameter(Element paramElement) {
        if (!paramElement.elements().iterator().hasNext()) {
            return;
        }
        Attribute att = paramElement.attribute(NAME_TAG);
        if (att == null) {
            return;
        }
        String name = att.getValue();
        for (Element valueElement : paramElement.elements()) {
            String value;
            if (this.hasChildElements(valueElement) || (value = valueElement.getText()) == null) continue;
            this.setProperty(name, value);
        }
    }

    protected void storeParameter(Element paramElement, String propName) {
        if (!paramElement.elements().iterator().hasNext()) {
            return;
        }
        Attribute att = paramElement.attribute(NAME_TAG);
        if (att == null) {
            return;
        }
        for (Element valueElement : paramElement.elements()) {
            String value;
            if (this.hasChildElements(valueElement) || (value = valueElement.getText()) == null) continue;
            this.setProperty(propName, value);
        }
    }

    public static enum PropertyType {
        parameter,
        instance,
        instances;

    }
}

