/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.property;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.jsmcommon.property.AbstractReportNetProps;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class CMProperties
extends AbstractReportNetProps {
    public static final String CM_URL_PARAM = "contentManager";
    public static final String DATABASETYPE = "databaseType";
    public static final String INSTANCE_NAME = "instance";
    public static final String DB_SERVER = "server";
    public static final String SERVICE_NAME = "servicename";
    public static final String DB_USER = "username";
    public static final String DB_PWD = "password";
    public static final String DB_ENCRYPTENABLED = "SSLencryptionEnabled";
    public static final String DB_NAME = "name";
    public static final String DB_SPECIFIER = "specifier";
    public static final String JDBC_DRIVER = "jdbc.driver";
    private static final String CLASS_TAG = "class";
    public static final String COMPONENT_HTS = "HTS";
    public static final String COMPONENT_ZIPI = "ZIP";
    public static final String COMPONENT_SDS = "SDS";
    public static final String PLANNING_USER = "planning_username";
    public static final String PLANNING_PWD = "planning_password";
    public static final String PLANNING_NAMESPACE = "planning_namespace";
    static CMProperties m_instance = new CMProperties();

    public static CMProperties getInstance() {
        return m_instance;
    }

    public synchronized void init(ICCLConfiguration configObj) {
        try {
            this.setProperty(CM_URL_PARAM, configObj.getValue(CM_URL_PARAM, DECRYPT, RESOLVE));
            Element element = configObj.getValueElement("NC", DECRYPT);
            if (!this.isNCInstanceConfigured(element)) {
                element = configObj.getValueElement("CM", DECRYPT);
            }
            Element placDS = configObj.getValueElement("PLACDS", DECRYPT);
            this.storePlanningProperties(placDS);
            this.storeDBInstance(element);
        }
        catch (CCLConfigurationException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public synchronized void initCrConfig(ICCLConfiguration configObj, Boolean aBoo) {
        boolean boo = aBoo;
        try {
            this.setProperty(CM_URL_PARAM, configObj.getValue(CM_URL_PARAM, boo, RESOLVE));
            Element element = configObj.getValueElement("CM", boo);
            Element placDS = configObj.getValueElement("PLACDS", aBoo.booleanValue());
            this.storePlanningProperties(placDS);
            this.storeDBInstance(element);
        }
        catch (CCLConfigurationException e) {
            System.err.println("CMProperties init fail.");
            e.printStackTrace();
        }
    }

    private void storePlanningProperties(Element placDS) {
        Element trustedUser = this.searchForNamedProperty(placDS, "planningTrustedUser", AbstractReportNetProps.PropertyType.parameter, true);
        Element namespace = this.searchForNamedProperty(placDS, "planningNamespace", AbstractReportNetProps.PropertyType.parameter, true);
        if (namespace != null) {
            this.storeParameter(namespace, PLANNING_NAMESPACE);
        }
        if (trustedUser != null) {
            this.storeCredentials(trustedUser, "planning_");
        }
    }

    protected boolean isNCInstanceConfigured(Element root) {
        boolean is_instance = false;
        List elements = root.elements("instances");
        if (elements.size() > 0) {
            is_instance = true;
        }
        return is_instance;
    }

    protected synchronized void storeDBInstance(Element instance) {
        try {
            List itemElements = instance.elements();
            for (Element anElement : itemElements) {
                List paramElements = anElement.elements();
                for (Element paramElement : paramElements) {
                    Attribute att = paramElement.attribute(CLASS_TAG);
                    if (att != null) {
                        String name = att.getValue();
                        this.setProperty(DATABASETYPE, name);
                    }
                    this.storeInstanceVariables(paramElement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getProperties().clear();
        }
    }

    protected void storeInstanceVariables(Element instanceElement) {
        if (!instanceElement.elements().iterator().hasNext()) {
            return;
        }
        for (Element paramElement : instanceElement.elements()) {
            this.storeCredentials(paramElement, "");
            this.storeParameter(paramElement);
            if (!"advancedProperties".equals(paramElement.attributeValue(DB_NAME))) continue;
            this.storeAdvancedProperties(paramElement);
        }
    }

    private void storeAdvancedProperties(Element paramElement) {
        if (paramElement.elements().size() == 0) {
            return;
        }
        for (Element advancedPropertyElement : ((Element)paramElement.elements().get(0)).elements()) {
            String name = advancedPropertyElement.attributeValue(DB_NAME);
            if (name == null) continue;
            List elements = advancedPropertyElement.elements();
            if (elements.size() == 0) {
                System.out.println("WARNING JSMCommon Advanced property " + name + " has no value");
                continue;
            }
            if (elements.size() > 1) {
                System.out.println("WARNING JSMCommon Advanced property " + name + " has multiple values only first will be used");
            }
            this.setProperty(name, ((Element)elements.get(0)).getText());
        }
    }
}

