/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.property;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.AbstractReportNetProps;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class CRNProperties
extends AbstractReportNetProps {
    public static final String DEPLOY_PATH = "deploymentPath";
    public static final String GATEWAY_URI = "gateway";
    public static final String GATEWAY_NS = "gatewayNamespace";
    public static final String DISPATCHER_EXT_URI = "externalDispatcher";
    public static final String DISPATCHER_INT_URI = "internalDispatcher";
    public static final String SDK_URI = "sdk";
    public static final String DATA_DIR = "data";
    public static final String TEMP_DIR = "temp";
    public static final String ENCRYPT = "encryptTemporaryFiles";
    public static final String SERVER_LOCALE = "serverLocale";
    public static final String SERVER_TZ = "serverTimeZoneID";
    public static final String DEFAULT_FONT = "defaultFont";
    public static final String MAX_RUNTASK_THREADS = "run.task.max.threads";
    public static final String MAX_TRUSTED_SESSIONS = "trustedSession.pool.max";
    public static final String RELATIVE_LANG_DIR = "localisation_dir";
    public static final String AXIS_TIMEOUT_KEY = "axis.timeout";
    public static final String SECONDARY_THRESHOLD_KEY = "secondary.threshold";
    public static final String AUTHENTICATE_WHEN_SCHEDULED = "authenticate.when.scheduled";
    public static final String XSL_DYNAMIC_UPDATE_KEY = "dynamic_update.xsl";
    public static final String TEMPORARY_OBJECT_LOCATION = "temporaryObjectLocation";
    private final String SERVER_PROPS_FILE = "server.conf";
    private final String SERVER_DIR = "noticecast.server_dir";
    public static final String SMTPMAILSERVER = "smtpMailServer";
    public static final String DEFAULTSENDER = "defaultSender";
    public static final String ALWAYS_USE_DEFAULT_SENDER = "alwaysUseDefaultSender";
    public static final String USE_SENDER_NAME = "useSenderName";
    public static final String SMTP_USER = "username";
    public static final String SMTP_PWD = "password";
    public static final String MAIL_ENCODING = "emailEncoding";
    public static final String SSL_ENCRYPTION_ENABLED = "SSLencryptionEnabled";
    public static final String MAIL_TLS_ENABLED = "emf.mail.tls.enabled";
    public static final String MAIL_SSL_PROTOCOLS = "mail.smtp.ssl.protocols";
    public static final String ARCHIVE_FILE_ROOT = "archiveLocationFileSchemeRoot";
    public static final String UNCOMPRESSED_ATTACHMENT_LIMIT_DLS = "dsCompressAttachmentLimit";
    public static final String TOTAL_EMAIL_LIMIT_DLS = "dsMaximumEMailSize";
    public static final String DLS_RESPECT_BURST_SECURITY = "dls.respect.burst.security";
    public static final String DLS_BURST_RECIPIENT_CONSISTENCY = "dls.burst.recipient.consistency";
    public static final String DLS_CONNECTION_POOL_FORCE_CLEAN = "dls.connection.pool.force.clean";
    public static final String DLS_CONNECTION_POOL_USED = "dls.connection.pool.used";
    public static final String DLS_SMTP_SENDER_REFRESH_ALWAYS = "dls.smtp.sender.refresh.always";
    public static final String DLS_IPF_lOG_EMAIL_RECIPIENT_TO_ONLY = "dls.ipf.log.email.recipient.to.only";
    public static final String EVENT_TASKQUEUE_CACHE_DISABLED = "event.taskqueue.cache.disabled";
    public static final String MAIL_ATTACHMENT_LIMIT_BRS = "brsMaximumEMailAttachmentSize";
    public static final String MAIL_ATTACHMENT_LIMIT_ASV = "asMaximumEMailAttachmentSize";
    public static final String AGENT_CONDITION_LIMIT = "asMaximumAgentConditionSize";
    public static final String AUTORECOVER_AT_STARTUP = "autorecover.startup";
    public static final String AUTORECOVER_AT_STARTUP_THRESHOLD = "autorecover.hungtasks.threshold";
    public static final String EVENT_STATE_CHECK_POLL_ACTIVE = "event.state.check.active";
    public static final String EVENT_STATE_POLL_INTERVAL = "event.state.check.interval";
    public static final String EVENT_STATE_CHECK_MIN_THRESHOLD = "event.state.check.threshold";
    public static final String EVENT_FINISHED_CLEANER_POLL_ACTIVE = "event.finished.check.active";
    public static final String EVENT_FINISHED_CLEANER_INTERVAL = "event.finished.check.interval";
    public static final String EVENT_FINISHED_CLEANER_THRESHOLD = "event.finished.check.threshold";
    public static final String EVENT_FINISHED_CLEANER_TIME_THRESHOLD = "event.finished.check.time.threshold";
    public static final String EVENT_POLL_INTERVAL = "event.check.interval";
    public static final String EVENT_POLL_ACTIVE = "event.check.active";
    public static final String EVENT_HC_POLL_ACTIVE = "event.historyconsistencycheck.active";
    public static final String EVENT_HC_POLL_INTERVAL = "event.historyconsistencycheck.interval";
    public static final String EVENT_HC_POLL_THRESHOLD = "event.historyconsistencycheck.threshold";
    public static final String EVENT_HC_POLL_BATCH_SIZE = "event.historyconsistencycheck.batch.size";
    public static final String EVENT_HC_POLL_ENABLE_FORCED_CLEAN = "event.historyconsistencycheck.enable.forced.clean";
    public static final String EVENT_HC_POLL_BATCH_INTERVAL = "event.historyconsistencycheck.batch.interval";
    public static final String MAX_SMTP_CONNECTION = "max.smtp.connections";
    public static final String MAX_SMTP_MESSAGES = "max.smtp.messages.per.transport";
    public static final String SMTP_RECONNECTION_DELAY = "smtp.reconnection.delay";
    public static final String SMTP_REDELIVERY_DELAY = "smtp.redelivery.delay";
    public static final String INSTANCE_UPDATE_INTERVAL = "sds.instance.interval";
    public static final String PING_CONNECTION_TIMEOUT = "sds.ping.connection.timeout";
    public static final String MAX_PREVIEW_ROWS = "asv.preview.maxRows";
    public static final String WEB_SERV_CNXT = "asv.webservice.useRunContext";
    public static final String PRIMARY_WAIT_ASV = "primary.wait.asv";
    public static final String PRIMARY_WAIT_JS = "primary.wait.js";
    public static final String PRIMARY_WAIT_MS = "primary.wait.ms";
    public static final String PRIMARY_WAIT_DLS = "primary.wait.dls";
    public static final String PRIMARY_WAIT_EMS = "primary.wait.ems";
    public static final String RETRY_MAXIMUM_MS = "retry.max.ms";
    public static final String RETRY_PERIOD_MS = "retry.period.ms";
    public static final String RETRY_MAXIMUM_PER_PERIOD_MS = "retry.max.per.period.ms";
    public static final String RETRY_ERRORS = "retry.errors";
    public static final String SECONDARY_WAIT_ASV = "secondary.wait.asv";
    public static final String SECONDARY_WAIT_JS = "secondary.wait.js";
    public static final String SECONDARY_WAIT_MS = "secondary.wait.ms";
    public static final String SECONDARY_WAIT_DLS = "secondary.wait.dls";
    public static final String SECONDARY_WAIT_EMS = "secondary.wait.ems";
    public static final String SDK_POLL_INTERVAL = "sdk.service.poll.interval";
    public static final String SMTP_RULES_PROPERTIES_FILE = "smtp.rules.properties.location";
    public static final String SMTP_RULES_PROPERTIES_READ = "smtp.rules.properties.reread";
    public static final String JDBC_USE_TRACKER = "connection.tracker.use";
    public static final String JDBC_RW_WAIT_TIMEOUT = "connection.write.maxwaittime";
    public static final String JSM_JDBC_DRIVER = "jsm.jdbc.driver";
    public static final String JDBC_RW_MAX_CONNS = "connection.write.maxConnections";
    public static final String JDBC_R_WAIT_TIMEOUT = "connection.read.maxwaittime";
    public static final String JDBC_R_MAX_CONNS = "connection.read.maxConnections";
    public static final String JDBC_MAX_HTS_CONNS = "connection.maxHTSConnections";
    public static final String JDBC_TRANSACTION_MAX_RETRIES = "transaction.max.retries";
    public static final String USE_CONNECTION_POOL = "connection.use.pool";
    public static final String JSM_ORA10G_SPECIFIC_SQL = "oracle.extra.filters";
    public static final String CONNECTION_VALID_STATEMENT = "emf.connection.sql.statement";
    public static final String SCHEDULE_VALIDATION_ENABLED = "emf.schedule.validation.enabled";
    public static final String ARCHIVE_FILE_TIMESTAMP_ALWAYS_ENABLED = "emf.archive.filetimestamp.enabled";
    public static final String EMF_PREVIEW_MAX_ITEMS = "emf.preview.max.items";
    public static final String MAIL_SMTP_CONNECTION_TIMEOUT = "emf.mail.smtp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "emf.mail.smtp.timeout";
    public static final String MAIL_SMTP_WRITE_TIMEOUT = "emf.mail.smtp.writetimeout";
    public static final String DLS_MAIL_ATTACHMENT_TIMESTAMP_ENABLED = "emf.dls.attachment.timestamp.enabled";
    public static final String DLS_MAIL_ATTACHMENT_TIMESTAMP_FORMAT = "emf.dls.attachment.timestamp.format";
    public static final String DLS_MAIL_WHITELIST_DOMAINS = "emf.dls.whitelistdomains";
    public static final String WS_CLASSES_FOLDER = "ES.webservice.objs.folder";
    public static final String CRN_WORKING_DIR = "pwd";
    private static final String ADVANCED = "advancedSettings";
    private static final String CONF_ADVANCED = "advancedProperties";
    public static final String LOTUS_COMPATIBILITY = "lotus.compatibility.mode";
    public static final String MAX_BATCHED_UPDATES = "max.batched.updates";
    public static final String CAM_NAMESPACE_ON_EMAIL_LINK = "CAMNamespaceOnEmailLink";
    public static final String FIX_EXCEL_2007 = "fixexcel2007";
    public static final String OLAP_TO_RELATIONAL_DRILL = "olap.rel.drill";
    public static final String LOCK_HISTORY_WRITE = "advanced.history.write.lock";
    public static final String DEFER_HISTORY_CREATION = "defer.history.creation";
    public static final String ADVANCED_FINAL_HISTORY_WRITE = "advanced.history.write";
    public static final String ADVANCED_PARENT_FINAL_HISTORY_THREADS = "advanced.parent.history.threads";
    public static final String ADVANCED_CHILD_FINAL_HISTORY_THREADS = "advanced.child.history.threads";
    public static final String WRITE_CHILD_HISTORIES = "write.child.histories";
    public static final String WRITE_CHILD_HISTORIES_DURING_FAILOVER = "write.child.histories.during.failover";
    public static final String DELETE_NOTIFIED_HISTORY_DETAILS = "delete.notified.history.details";
    public static final String HOUSEKEEPING_RUN_STARTUP = "housekeeping.run.startup";
    public static final String HOUSEKEEPING_RUN_INTERVAL = "housekeeping.run.interval";
    public static final String MAX_FILENAME_LENGTH = "archive.max.filename.length";
    public static final String OVERRIDE_TARGET_VALUES = "agent.task.override.params";
    public static final String MS_PAGING_ABANDON_LIMIT = "ms.paging.abandon.limit";
    public static final String HTS_COMPLETED_TASK_LIFETIME = "htsCompletedTaskLifetime";
    public static final String HTS_CREATED_TASK_LIFETIME = "htsCreatedTaskLifetime";
    public static final String HTS_NUMBER_OF_RECORDS_TO_FETCH_FROM_DB = "htsNumberOfRecordsToFetchFromDB";
    public static final String HTS_MYINBOX_LIST_SIZE = "htsMyinboxListSize";
    public static final String HTS_MYINBOX_LIST_SIZE_FOR_INBOXFEED = "htsMyinboxListSizeForInboxFeed";
    public static final String HTS_AUDIT_LEVEL = "htsAuditLevel";
    public static final String ANS_ANNOTATION_LIFETIME = "ansAnnotationLifetime";
    public static final String ANS_AUDIT_LEVEL = "ansAuditLevel";
    public static final String HTS_MAINTENANCE_ENABLED = "hts.maintenance.enabled";
    public static final String HTS_MAINTENANCE_CM_CHECK_ENABLED = "hts.maintenance.cm.check.enabled";
    public static final String HTS_MAINTENANCE_MANAGE_ALL_TASKS_ENABLED = "hts.maintenance.manage.all.tasks.enabled";
    public static final String HTS_MAINTENANCE_DAYS_OF_WEEK = "hts.maintenance.days.of.week";
    public static final String HTS_MAINTENANCE_MANAGE_ALL_TASKS_DELAY = "hts.maintenance.manage.all.tasks.delay";
    public static final String HTS_MAINTENANCE_MANAGE_COMPLETED_TASKS_ENABLED = "hts.maintenance.manage.completed.tasks.enabled";
    public static final String HTS_MAINTENANCE_HOUR = "hts.maintenance.hour";
    public static final String HTS_MAINTENANCE_INTERVAL = "hts.maintenance.interval";
    public static final String AAA_INACTIVITY_TIMEOUT = "inactivityTimeout";
    public static final String ENABLE_SESSION_AFFINITY = "enable.session.affinity";
    public static final String SESSION_AFFINITY_SERVICES = "session.affinity.services";
    public static final String MS_LOADBALANCE_YIELD_CHUNK = "ms.loadbalance.yield.chunk";
    public static final String STATE_MAP_PROCESSOR_QUEUE_AND_WAIT = "state.map.processor.queue.and.wait";
    public static final String RESOURCE_LOCK_WAIT_PARAM = "com.cognos.jsmcommon.lock.wait.interval";
    public static final String RESOURCE_LOCK_MAX_WAIT_PARAM = "com.cognos.jsmcommon.lock.wait.timeout";
    public static final String RESOURCE_LOCK_VERBOSE_PARAM = "com.cognos.jsmcommon.lock.verbose";
    public static final String DBSCHEMA_VALIDATION_RUN_INTERVAL = "emf.dbSchema.validation.run.interval";
    public static final String DBSCHEMA_VALIDATION_FIRST_RUN_HOUR_OF_DAY = "emf.dbSchema.validation.first.run.hour.of.day";
    public static final String DBSCHEMA_VALIDATION_AT_INTERVALS_ENABLED = "emf.dbSchema.validation.at.intervals.enabled";
    public static final String DBSCHEMA_VALIDATION_ENABLED = "emf.dbSchema.validation.enabled";
    public static final String SCHEDULING_PRIORITY_CAPABILITY_CHECK_DISABLED = "emf.scheduling.priority.capability.check.disabled";
    static CRNProperties m_instance = new CRNProperties();
    public static final String REAUTHENTICATE_QUEUE_ENTRY = "ms.reauthenticate.queue.entry";
    public static final String ACTION_REQUIRES_PERMISSIONS_CHECK = "ems.action.requires.permissions.check";
    public static final ServiceNames serviceNames = new ServiceNames();
    public static final String QUERYSERVICEWAITTIME = "ms.queryservice.wait.time";
    public static final String QUERYSERVICERETRYMAX = "ms.queryservice.retry.max";
    public static final String QUERYSERVICERETRYENABLED = "ms.queryservice.retry.enabled";
    public static final String MAIL_PUSH_NOTIFICATION_ENABLED = "emf.mail.pushnotification.enabled";
    public static final String INACTIVE_TASK_CLEANUP_ENABLED = "inactive.task.cleanup.enabled";
    public static final String INACTIVE_TASK_CLEANUP_CHECK_INTERVAL = "inactive.task.cleanup.check.interval";
    public static final String INACTIVE_TASK_CLEANUP_DURATION = "inactive.task.cleanup.duration";
    public static final String MAX_ACTIVITIES_HARD = "max.activities.hard";
    public static final String MAX_ACTIVITIES_SOFT = "max.activities";
    public static final String LIMIT_PER_EMAIL_SENDER = "limit.per.email.sender";
    private AdvancedPropertyMap m_advanced;

    public CRNProperties() {
        this.m_advanced = new AdvancedPropertyMap();
    }

    public CRNProperties(Object o) {
    }

    public static CRNProperties getInstance() {
        return m_instance;
    }

    public synchronized void init(ICCLConfiguration configObj) {
        this.initCrConfig(configObj, DECRYPT, "Agnostic");
    }

    public synchronized void init(ICCLConfiguration configObj, String serviceName) {
        this.initCrConfig(configObj, DECRYPT, serviceName);
    }

    public synchronized void initCrConfig(ICCLConfiguration configObj, Boolean encrypted, String serviceName) {
        try {
            this.clearAdvancedProps(serviceName);
            Element conf_adv_props = configObj.getValueElement(CONF_ADVANCED, encrypted.booleanValue(), RESOLVE);
            if (conf_adv_props == null) {
                String msg = I18NUtil.getMessage(I18NCode.MSG_FAILED_TO_READ_PROPERTIES, new Object[0], null);
                throw new RuntimeException(msg);
            }
            this.initFromElement(conf_adv_props);
            this.setProperty(DEPLOY_PATH, configObj.getValue(DEPLOY_PATH, encrypted.booleanValue(), RESOLVE));
            this.setProperty(GATEWAY_URI, configObj.getValue(GATEWAY_URI, encrypted.booleanValue(), RESOLVE));
            this.setProperty(GATEWAY_NS, configObj.getValue(GATEWAY_NS, encrypted.booleanValue(), RESOLVE));
            this.setProperty(DISPATCHER_EXT_URI, configObj.getValue(DISPATCHER_EXT_URI, encrypted.booleanValue(), RESOLVE));
            this.setProperty(DISPATCHER_INT_URI, configObj.getValue(DISPATCHER_INT_URI, encrypted.booleanValue(), RESOLVE));
            this.setProperty(SDK_URI, configObj.getValue(SDK_URI, encrypted.booleanValue(), RESOLVE));
            this.setProperty(DATA_DIR, configObj.getValue(DATA_DIR, encrypted.booleanValue(), RESOLVE));
            this.setProperty(TEMP_DIR, configObj.getValue(TEMP_DIR, encrypted.booleanValue(), RESOLVE));
            this.setProperty(ENCRYPT, configObj.getValue(ENCRYPT, encrypted.booleanValue(), RESOLVE));
            this.setProperty(SERVER_LOCALE, configObj.getValue(SERVER_LOCALE, encrypted.booleanValue(), RESOLVE));
            this.setProperty(SERVER_TZ, configObj.getValue(SERVER_TZ, encrypted.booleanValue(), RESOLVE));
            this.setProperty(DEFAULT_FONT, configObj.getValue(DEFAULT_FONT, encrypted.booleanValue(), RESOLVE));
            this.setProperty(MAIL_ENCODING, configObj.getValue(MAIL_ENCODING, encrypted.booleanValue(), RESOLVE));
            this.setProperty(ARCHIVE_FILE_ROOT, configObj.getValue(ARCHIVE_FILE_ROOT, encrypted.booleanValue(), RESOLVE));
            this.setProperty(UNCOMPRESSED_ATTACHMENT_LIMIT_DLS, configObj.getValue(UNCOMPRESSED_ATTACHMENT_LIMIT_DLS, encrypted.booleanValue(), RESOLVE));
            this.setProperty(TEMPORARY_OBJECT_LOCATION, configObj.getValue(TEMPORARY_OBJECT_LOCATION, encrypted.booleanValue(), RESOLVE));
            this.setProperty(TOTAL_EMAIL_LIMIT_DLS, configObj.getValue(TOTAL_EMAIL_LIMIT_DLS, encrypted.booleanValue(), RESOLVE));
            this.setProperty(MAIL_ATTACHMENT_LIMIT_BRS, configObj.getValue(MAIL_ATTACHMENT_LIMIT_BRS, encrypted.booleanValue(), RESOLVE));
            this.setProperty(MAIL_ATTACHMENT_LIMIT_ASV, configObj.getValue(MAIL_ATTACHMENT_LIMIT_ASV, encrypted.booleanValue(), RESOLVE));
            this.setProperty(HTS_COMPLETED_TASK_LIFETIME, configObj.getValue(HTS_COMPLETED_TASK_LIFETIME, encrypted.booleanValue(), RESOLVE));
            this.setProperty(HTS_AUDIT_LEVEL, configObj.getValue(HTS_AUDIT_LEVEL, encrypted.booleanValue(), RESOLVE));
            this.setProperty(ANS_ANNOTATION_LIFETIME, configObj.getValue(ANS_ANNOTATION_LIFETIME, encrypted.booleanValue(), RESOLVE));
            this.setProperty(ANS_AUDIT_LEVEL, configObj.getValue(ANS_AUDIT_LEVEL, encrypted.booleanValue(), RESOLVE));
            this.setProperty(CRN_WORKING_DIR, configObj.resolveEffectivePath("."));
            Element aaaElement = configObj.getValueElement("AAA", false);
            this.initFromElement(aaaElement, AAA_INACTIVITY_TIMEOUT);
            Element sds_config = configObj.getValueElement("NC", encrypted.booleanValue());
            this.initFromElement(sds_config);
            Element adv_props = configObj.getValueElement(ADVANCED, encrypted.booleanValue(), RESOLVE);
            this.resolveAdvProps(adv_props, serviceName);
        }
        catch (CCLConfigurationException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    private void clearAdvancedProps(Object key) {
        Iterator<String> itr;
        Map<String, String> serviceProperties = this.m_advanced.clear(key);
        Iterator<String> iterator = itr = serviceProperties != null ? serviceProperties.keySet().iterator() : null;
        while (itr != null && itr.hasNext()) {
            this.removeProperty(itr.next());
        }
    }

    private void resolveAdvProps(Element adv_props, Object serviceKey) {
        if (adv_props == null) {
            return;
        }
        try {
            String settings = XMLUtils.unEscape(adv_props.getTextTrim());
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(settings));
            Element root = doc.getRootElement();
            List paramElements = root.elements();
            for (Element paramElement : paramElements) {
                Attribute att = paramElement.attribute("name");
                if (att == null) continue;
                String name = att.getValue();
                if (this.hasChildElements(paramElement)) continue;
                String value = paramElement.getTextTrim();
                this.setProperty(name, value);
                if (serviceKey == null) continue;
                this.m_advanced.addProperty(serviceKey.toString(), name, value);
            }
        }
        catch (DocumentException e) {
            this.logException((Exception)((Object)e), e.getLocalizedMessage());
            SDSLogger logger = SDSLogger.getLogger(JSMCommonCategory.TRACE);
            logger.log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
    }

    public String getAdvancedProperty(ServiceNames.ServiceKey[] serviceKeys, String name) throws PropertiesException {
        return this.m_advanced.getProperty(serviceKeys, name);
    }

    public boolean getBoolAdvancedPropertyValue(String key, boolean defaultValue) {
        boolean paramValue = defaultValue;
        try {
            String str = this.getProperty(key);
            if (str != null && str.trim().length() > 0) {
                paramValue = Boolean.valueOf(str);
            }
        }
        catch (Throwable e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        return paramValue;
    }

    private String getServerConfPath() throws PropertiesException {
        StringBuffer theFilePath = new StringBuffer();
        theFilePath.append(System.getProperty("noticecast.server_dir"));
        theFilePath.append(File.separator);
        theFilePath.append("server.conf");
        return theFilePath.toString();
    }

    private void readProperties(String filePath) throws PropertiesException {
        try {
            FileInputStream theFileStream = new FileInputStream(filePath);
            this.getProperties().load(theFileStream);
            theFileStream.close();
        }
        catch (FileNotFoundException ex) {
            String errMsg = "CRNProperties.readProperties(): Could not find file [" + filePath + "].";
            System.out.println(errMsg);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        catch (SecurityException ex) {
            String errMsg = "ServerPropertiesManager.readProperties:Could not open file for reading from [" + filePath + "].";
            System.out.println(errMsg);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        catch (IOException ex) {
            String errMsg = "ServerPropertiesManager.getProperties:Could not open or close file at path [" + filePath + "].";
            System.out.println(errMsg);
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
    }

    private void setServerConfPath(String thePwd) {
        Properties props = System.getProperties();
        if (props.getProperty("noticecast.server_dir") != null) {
            return;
        }
        if (thePwd != null) {
            String genpath;
            StringBuffer theServerConfPath = new StringBuffer();
            theServerConfPath.append(thePwd).append(File.separator).append("..").append(File.separator).append("sds").append(File.separator).append("conf");
            File file = new File(theServerConfPath.toString());
            try {
                genpath = file.getCanonicalPath();
            }
            catch (IOException e) {
                genpath = file.getAbsolutePath();
            }
            props.setProperty("noticecast.server_dir", genpath);
        } else {
            System.out.println("Cognos 8 is reporting that the working dir is null");
        }
    }

    public String getBinDir() {
        String binDir;
        try {
            binDir = CRNProperties.getInstance().getProperty(CRN_WORKING_DIR);
        }
        catch (PropertiesException e) {
            binDir = ".." + File.separator + "bin";
        }
        return binDir;
    }

    public static int getProperty(String propName, int defaultValue) {
        int result = defaultValue;
        try {
            String property = CRNProperties.getInstance().getProperty(propName);
            if (property != null) {
                result = Integer.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return result;
    }

    public static boolean getProperty(String propName, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String property = CRNProperties.getInstance().getProperty(propName);
            if (property != null) {
                result = Boolean.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return result;
    }

    public static class ServiceNames {
        private Map<ServiceKey, String> serviceNames = new HashMap<ServiceKey, String>();

        ServiceNames() {
            this.serviceNames.put(ServiceKey.MONITOR, "monitorServiceHandler");
            this.serviceNames.put(ServiceKey.HUMAN, "wsHTServiceHandler");
            this.serviceNames.put(ServiceKey.DELIVERY, "delivery_service");
            this.serviceNames.put(ServiceKey.EVENT, "eventManagementServiceHandler");
            this.serviceNames.put(ServiceKey.JOB, "jobServiceHandler");
        }

        public void setServiceName(ServiceKey key, String name) {
            this.serviceNames.put(key, name);
        }

        String getServiceName(ServiceKey service) {
            if (!this.serviceNames.containsKey((Object)service)) {
                return "";
            }
            return this.serviceNames.get((Object)service);
        }

        public static enum ServiceKey {
            MONITOR,
            DELIVERY,
            EVENT,
            HUMAN,
            JOB;

        }
    }

    private class AdvancedPropertyMap {
        private Map<String, Map<String, String>> serviceMap = Collections.synchronizedMap(new HashMap());

        private AdvancedPropertyMap() {
        }

        public void addProperty(String serviceKey, String name, String value) {
            this.getServiceMap(serviceKey).put(name, value);
        }

        public void addProperty(ServiceNames.ServiceKey serviceKey, String name, String value) {
            String serviceName = serviceNames.getServiceName(serviceKey);
            this.getServiceMap(serviceName).put(name, value);
        }

        public String getProperty(ServiceNames.ServiceKey serviceKey, String name) throws PropertiesException {
            if (serviceKey == null) {
                return CRNProperties.this.getProperty(name);
            }
            String serviceName = serviceNames.getServiceName(serviceKey);
            return this.getServiceMap(serviceName).get(name);
        }

        public String getProperty(ServiceNames.ServiceKey[] serviceKeys, String name) throws PropertiesException {
            String value = null;
            for (int i = 0; value == null && serviceKeys != null && i < serviceKeys.length; ++i) {
                value = this.getProperty(serviceKeys[i], name);
            }
            return value;
        }

        private Map<String, String> getServiceMap(String serviceKey) {
            Map<String, String> serviceProperties = this.serviceMap.get(serviceKey);
            if (serviceProperties == null) {
                serviceProperties = new HashMap<String, String>();
                this.serviceMap.put(serviceKey, serviceProperties);
            }
            return serviceProperties;
        }

        public void clearAll() {
            this.serviceMap.clear();
        }

        public Map<String, String> clear(Object key) {
            return this.serviceMap.remove(key);
        }
    }
}

