/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.security;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMProtect;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.Identity;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.security.UserIdentity;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.client.ports.SaCAMServiceClientPort;
import com.cognos.jsmcommon.soap.service.ServiceConstants;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ConnectionPool;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.TrustedSession;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.bi.logging.glug.support.InvalidLoggingCookieException;
import com.ibm.bi.logging.glug.support.LoggingCookie;
import com.ibm.bi.logging.glug.support.web.GlugLoggingContext;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CAMAuthenticatorImpl
implements IAuthenticator {
    protected CAMAuthenticatorImpl() {
    }

    @Override
    public void authenticate(JobBiBusHeaders headers) throws EMFSecurityException, SDKClientException {
        ContentManagerServiceClientPort cmPort = this.getCMPort(headers);
        try {
            cmPort.trustedLogon();
            SOAPEnvelope se = cmPort.getResponseEnvelope();
            SOAPHeaderElement h2 = se.getHeaderByName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
            Object value = h2.getObjectValue();
            this.updateCookieVars((BiBusHeader)value);
            headers.setBiBusHeader((BiBusHeader)value);
        }
        catch (AxisFault e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
            throw new SDKClientException((Exception)((Object)e));
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
    }

    @Override
    public void logon(JobBiBusHeaders header) throws EMFSecurityException, SDKClientException {
        String camCredential = header.getCamCredential();
        if (camCredential == null || "".equals(camCredential)) {
            throw new EMFSecurityException(header.getLocale());
        }
        header.setBiBusHeader(new BiBusHeader());
        header.getBiBusHeader().setCAM(new CAM());
        header.getBiBusHeader().getCAM().setCAMCredentialPath(camCredential);
        this.logon(header, "logonAs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logon(JobBiBusHeaders request_header, String action) throws EMFSecurityException, SDKClientException {
        BiBusHeader header = request_header.getBiBusHeader();
        ContentManagerServiceClientPort cmPort = this.getCMPort(request_header);
        cmPort.setEndpointType(Client.DISPATCHER_ENDPOINT);
        CAM prevCAM = header.getCAM();
        CAMProtect prevProtect = header.getCAMProtect();
        CAM newCAM = new CAM();
        newCAM.setAction(action);
        if (prevCAM != null) {
            newCAM.setRoles(prevCAM.getRoles());
            newCAM.setSecurityBlob(prevCAM.getSecurityBlob());
        }
        if (action.equals("logonAs")) {
            newCAM.setCAMCredentialPath(request_header.getCamCredential());
        } else if (prevCAM != null) {
            newCAM.setCAMCredentialPath(prevCAM.getCAMCredentialPath());
            newCAM.setCAMPassport(prevCAM.getCAMPassport());
        }
        header.setCAMProtect(null);
        header.setCAM(newCAM);
        try {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, "logon");
            cmPort.signNextRequest("JSM");
            cmPort.trustedLogon();
            SOAPEnvelope se = cmPort.getResponseEnvelope();
            SOAPHeaderElement h2 = se.getHeaderByName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
            Object value = h2.getObjectValue();
            this.updateCookieVars((BiBusHeader)value);
            request_header.setBiBusHeader((BiBusHeader)value);
        }
        catch (AxisFault e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
            header.setCAM(prevCAM);
            header.setCAMProtect(prevProtect);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, "logon end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clonePassport(JobBiBusHeaders headers) throws EMFSecurityException, SDKClientException {
        BiBusHeader header = headers.getBiBusHeader();
        BiBusHeader responseHeader = headers.getBiBusHeader();
        CAM cam = header.getCAM();
        cam.setAction("clonePassport");
        ContentManagerServiceClientPort cmPort = this.getCMPort(headers);
        try {
            cmPort.signNextRequest("JSM");
            cmPort.trustedLogon();
            SOAPEnvelope se = cmPort.getResponseEnvelope();
            SOAPHeaderElement responseHeaderElement = se.getHeaderByName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
            responseHeader = (BiBusHeader)responseHeaderElement.getObjectValue();
            this.updateCookieVars(responseHeader);
        }
        catch (AxisFault e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        headers.setBiBusHeader(responseHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logoff(BiBusHeader header) throws EMFSecurityException {
        if (header == null || header.getCAM() == null || header.getCAM().getCAMPassport() == null || "".equals(header.getCAM().getCAMPassport())) {
            return;
        }
        IClientBase contentManager = null;
        try {
            contentManager = this.getCMPort(new JobBiBusHeaders(header));
            contentManager.setEndpointType(Client.CONTENT_MANAGER_ENDPOINT);
            contentManager.signNextRequest("JSM");
            contentManager.logoff();
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
    }

    @Override
    public boolean isTrustedCMRequest(BIBusEnvelope env) throws EMFSecurityException {
        boolean trustedRequestFromCM = false;
        TrustedSession session = ConnectionPool.getInstance().getSession();
        try {
            TrustedRequestSession trs = session.getTrustedRequestSession();
            byte[] byteArray = env.getEnvelope().asXML().getBytes("utf-8");
            if (trs.getServiceID(byteArray).compareToIgnoreCase("cm") == 0 && trs.isTrusted(byteArray)) {
                trustedRequestFromCM = true;
            }
        }
        catch (UnsupportedEncodingException trs) {
        }
        catch (CAMCryptoException e) {
            throw new EMFSecurityException(env, (Exception)((Object)e));
        }
        finally {
            session.release();
        }
        return trustedRequestFromCM;
    }

    @Override
    public boolean isTrustedRequest(BIBusEnvelope env) throws EMFSecurityException {
        boolean isTrusted = false;
        try {
            TrustedSession session = ConnectionPool.getInstance().getSession();
            TrustedRequestSession trs = session.getTrustedRequestSession();
            byte[] byteArray = env.getEnvelope().asXML().getBytes("utf-8");
            if (trs.isTrusted(byteArray)) {
                isTrusted = true;
            }
            session.release();
        }
        catch (UnsupportedEncodingException session) {
        }
        catch (CAMCryptoException e) {
            throw new EMFSecurityException(env, (Exception)((Object)e));
        }
        return isTrusted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential getCredential(BiBusHeader header) throws SDKClientException, EMFSecurityException {
        Credential credential = null;
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, "getCredential");
        QueryRequest request = new QueryRequest();
        request.setSearch("~/credential");
        request.setProperties(new PropEnum[]{PropEnum.storeID, PropEnum.searchPath});
        IClientBase cmPort = null;
        try {
            BaseClass[] classes;
            JobBiBusHeaders jobHeaders = new JobBiBusHeaders(header);
            cmPort = this.getCMPort(jobHeaders);
            QueryReply[] replies = cmPort.queryMultiple(new QueryRequest[]{request});
            if (replies != null && replies.length > 0 && (classes = replies[0].getQueryResult()) != null && classes.length > 0) {
                credential = (Credential)classes[0];
            }
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NmtokenArrayProp getExtendedUserCapabilities(BiBusHeader header) {
        NmtokenArrayProp extendedUserCapabilities = null;
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, "getExtendedUserCapabilities");
        IClientBase cmPort = null;
        try {
            JobBiBusHeaders jobHeaders = new JobBiBusHeaders(header);
            cmPort = this.getCMPort(jobHeaders);
            BaseClass[] classes = cmPort.query("~~", new PropEnum[]{PropEnum.extendedUserCapabilities}, new Sort[0], new QueryOptions());
            if (classes != null && classes.length > 0) {
                Session session = (Session)classes[0];
                extendedUserCapabilities = session.getExtendedUserCapabilities();
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return extendedUserCapabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTenantID(BiBusHeader header) {
        String tenantID = "";
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, "getTenantID");
        IClientBase cmPort = null;
        try {
            JobBiBusHeaders jobHeaders = new JobBiBusHeaders(header);
            cmPort = this.getCMPort(jobHeaders);
            BaseClass[] classes = cmPort.query("~~", new PropEnum[]{PropEnum.tenantID}, new Sort[0], new QueryOptions());
            if (classes != null && classes.length > 0) {
                tenantID = classes[0].getTenantID().getValue();
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return tenantID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentity getUserIdentity(BiBusHeader header) {
        Identity id = null;
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, "getUserIdentity");
        IClientBase saCAMPort = null;
        try {
            JobBiBusHeaders jobHeaders = new JobBiBusHeaders(header);
            saCAMPort = this.getSaCAMPort(jobHeaders);
            id = saCAMPort.getIdentity();
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
        }
        finally {
            if (saCAMPort != null) {
                saCAMPort.close();
            }
        }
        UserIdentity userIdentity = new UserIdentity(id);
        this.logUserIdentity(userIdentity);
        return userIdentity;
    }

    private void logUserIdentity(UserIdentity identity) {
        if (SDSLogger.getLogger(JSMCommonCategory.TRACE).isLoggingAt(SDSLevel.DEBUG)) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("===User Identity=== trueTenantID: " + identity.getTrueTenantID() + "; readTenantIDs: " + identity.getReadTenantIDsToString() + "; writeTenantID: " + identity.getWriteTenantID() + "; role: " + identity.getRole().name() + "; isImpersonating: " + identity.isImpersonating() + "; tenantIDsForFiltering: " + identity.getTenantIDsForFiltering());
        }
    }

    private Element toSoapHeaderElt(String busHeaderStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)busHeaderStr);
        Element soapHeaderElt = DocumentHelper.createElement((QName)new QName("Header", new Namespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/")));
        soapHeaderElt.add(doc.getRootElement());
        return soapHeaderElt;
    }

    @Override
    public void generateTC(BiBusHeader header) throws EMFSecurityException {
        IClientBase contentManager = null;
        try {
            header.getCAM().setAction("generateTC");
            contentManager = this.getCMPort(new JobBiBusHeaders(header));
            contentManager.signNextRequest("JSM");
            contentManager.query(new SearchPathMultipleObject("~"), new PropEnum[]{PropEnum.searchPath}, new Sort[0], new QueryOptions());
        }
        catch (Exception e) {
            throw new EMFSecurityException(this.getResponseHeadersAsEnvelope(contentManager.getBinding()));
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
    }

    private BIBusEnvelope getResponseHeadersAsEnvelope(Stub stub) {
        SOAPHeaderElement soapHeader = stub.getResponseHeader(ServiceConstants.BUS_QNAME.getNamespaceURI(), ServiceConstants.BUS_QNAME.getLocalPart());
        BIBusEnvelope envelope = null;
        try {
            BiBusHeader header = null;
            if (soapHeader != null) {
                header = (BiBusHeader)soapHeader.getValueAsType(ServiceConstants.BUS_QNAME);
            }
            if (header != null) {
                envelope = BiBusUtilities.getHeadedEnvelope(header);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        return envelope;
    }

    @Override
    public boolean hasPermissions(BiBusHeader header, SearchPathSingleObject spso, String[] permissions, boolean trusted) throws SDKClientException, EMFSecurityException {
        boolean hasPermission = false;
        BaseClass permissionsOn = this.getBaseClass(header, spso, new PropEnum[]{PropEnum.permissions, PropEnum.searchPath}, trusted);
        if (permissionsOn != null) {
            hasPermission = this.hasPermissions(permissionsOn, permissions);
        }
        return hasPermission;
    }

    @Override
    public boolean hasPermission(BiBusHeader header, SearchPathSingleObject spso, String permission, boolean trusted) throws SDKClientException, EMFSecurityException {
        return this.hasPermissions(header, spso, new String[]{permission}, trusted);
    }

    @Override
    public boolean hasPermission(BiBusHeader header, SearchPathSingleObject spso, String permission) throws SDKClientException, EMFSecurityException {
        return this.hasPermission(header, spso, permission, false);
    }

    @Override
    public boolean hasPermission(BiBusHeader header, String searchPath, String permission) throws SDKClientException, EMFSecurityException {
        SearchPathSingleObject spso = new SearchPathSingleObject();
        spso.set_value(searchPath);
        return this.hasPermission(header, spso, permission);
    }

    @Override
    public boolean hasPermission(BaseClass baseClass, String permission) {
        boolean hasPermission = false;
        if (baseClass != null) {
            NmtokenArrayProp tokens = baseClass.getPermissions();
            hasPermission = this.hasPermission(tokens, permission);
        }
        return hasPermission;
    }

    @Override
    public boolean hasPermission(NmtokenArrayProp tokens, String permission) {
        boolean hasPermission = false;
        if (tokens != null) {
            String[] perms = tokens.getValue();
            for (int i = 0; i < perms.length; ++i) {
                if (!perms[i].equals(permission)) continue;
                hasPermission = true;
                break;
            }
        }
        return hasPermission;
    }

    @Override
    public boolean hasPermissions(BaseClass baseClass, String[] permissions) {
        boolean hasPermissions = true;
        for (int i = 0; i < permissions.length && hasPermissions; ++i) {
            hasPermissions = hasPermissions && this.hasPermission(baseClass, permissions[i]);
        }
        return hasPermissions;
    }

    @Override
    public boolean isOwner(BiBusHeader header, SearchPathSingleObject spso, boolean trusted) throws SDKClientException, EMFSecurityException {
        boolean isOwner = false;
        BaseClass object = this.getBaseClass(header, spso, new PropEnum[]{PropEnum.owner, PropEnum.searchPath, PropEnum.storeID}, trusted);
        if (object == null) {
            return isOwner;
        }
        BaseClass owner = ObjectModelUtil.getBaseClass(object.getOwner(), 0);
        boolean bl = isOwner = owner != null && owner instanceof Account;
        if (isOwner) {
            UserAccountUtil userUtil = new UserAccountUtil(new JobBiBusHeaders(header));
            UserAccountUtil ownerUtil = new UserAccountUtil((Account)owner);
            isOwner = userUtil.equals(ownerUtil);
        }
        return isOwner;
    }

    @Override
    public boolean hasCapability(BiBusHeader header, UserCapabilityEnum capability) throws SDSServiceException {
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        return this.hasCapability(headers, capability);
    }

    public boolean hasCapability(JobBiBusHeaders headers, UserCapabilityEnum capability) throws SDSServiceException {
        boolean found = false;
        UserCapabilityEnum[] capabilities = headers.getUserCapabilities();
        for (int i = 0; capabilities != null && !found && i < capabilities.length; ++i) {
            found = capabilities[i].equals((Object)capability);
        }
        return found;
    }

    @Override
    public boolean hasCapability(NmtokenArrayProp extendedUserCapabilitiesTokenArray, UserCapabilityEnum capability) throws SDSServiceException {
        boolean found = false;
        found = this.hasPermission(extendedUserCapabilitiesTokenArray, capability.getValue());
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseClass getBaseClass(BiBusHeader header, SearchPathSingleObject spso, PropEnum[] props, boolean trusted) throws SDKClientException, EMFSecurityException {
        String searchPath = spso.get_value();
        BaseClass baseClass = null;
        IClientBase contentManager = null;
        try {
            BaseClass[] baseClasses;
            contentManager = this.getCMPort(new JobBiBusHeaders(header));
            if (trusted) {
                contentManager.signNextRequest("JSM");
            }
            if ((baseClasses = contentManager.query(new SearchPathMultipleObject(searchPath), props, new Sort[0], new QueryOptions())) != null && baseClasses.length == 1 && baseClasses[0].getSearchPath().getValue() != null) {
                baseClass = baseClasses[0];
            }
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        return baseClass;
    }

    private void updateCookieVars(BiBusHeader header) {
        if (header.getHdrSession() != null) {
            String name;
            int i;
            HashMap<String, CookieVar> cookieMap = new HashMap<String, CookieVar>();
            HdrSession hdrSession = header.getHdrSession();
            if (hdrSession.getCookieVars() != null) {
                CookieVar[] oldCookieVars = hdrSession.getCookieVars();
                for (i = 0; i < oldCookieVars.length; ++i) {
                    if (oldCookieVars[i] == null || (name = oldCookieVars[i].getName()) == null) continue;
                    cookieMap.put(name, oldCookieVars[i]);
                }
            }
            this.setLoggingSessionCookie(header, cookieMap);
            if (hdrSession.getSetCookieVars() != null) {
                SetCookieVar[] setCookieVars = hdrSession.getSetCookieVars();
                for (i = 0; i < setCookieVars.length; ++i) {
                    if (setCookieVars[i] == null || (name = setCookieVars[i].getName()) == null) continue;
                    if (cookieMap.containsKey(name)) {
                        ((CookieVar)cookieMap.get(name)).setValue(setCookieVars[i].getValue());
                        continue;
                    }
                    CookieVar newCookieVar = new CookieVar();
                    newCookieVar.setName(name);
                    newCookieVar.setValue(setCookieVars[i].getValue());
                    cookieMap.put(name, newCookieVar);
                }
            }
            hdrSession.setCookieVars(cookieMap.values().toArray(new CookieVar[cookieMap.size()]));
            hdrSession.setSetCookieVars(null);
        }
    }

    protected void setLoggingSessionCookie(BiBusHeader header, Map<String, CookieVar> cookieMap) {
        CookieVar cv = cookieMap.get("ba-logging-session");
        LoggingCookie logCookie = null;
        try {
            if (cv == null) {
                UserPreferenceVar[] preferences;
                for (UserPreferenceVar upvar : preferences = header.getUserPreferenceVars()) {
                    String prefName = upvar.getName();
                    if (null == prefName || !prefName.equalsIgnoreCase("backgroundSessionLogging")) continue;
                    logCookie = LoggingCookie.parseCookie((String)upvar.getValue());
                    break;
                }
            } else {
                logCookie = LoggingCookie.parseCookie((String)cv.getValue());
            }
            this.addLoggingCookieToMap(logCookie, cookieMap);
        }
        catch (InvalidLoggingCookieException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("background session logging was not set");
        }
        catch (NullPointerException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Format of Logging cookie invalid");
        }
    }

    private void addLoggingCookieToMap(LoggingCookie cookieValue, Map<String, CookieVar> cookieMap) {
        if (cookieValue != null && !cookieValue.isExpired()) {
            CookieVar newCookieVar = new CookieVar();
            newCookieVar.setName("ba-logging-session");
            newCookieVar.setValue(cookieValue.toEncodedString());
            cookieMap.put("ba-logging-session", newCookieVar);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("adding session logging cookie to background session.");
            GlugLoggingContext.setupLoggingControl((String)newCookieVar.getValue());
        }
    }

    protected ContentManagerServiceClientPort getCMPort(JobBiBusHeaders header) {
        return Client.instance().getContentManagerServiceClient(header);
    }

    protected SaCAMServiceClientPort getSaCAMPort(JobBiBusHeaders header) {
        return Client.instance().getSaCAMServiceClient(header);
    }

    @Override
    public void setIdentity(String u, String p, String n) {
    }
}

