/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.security;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;

public class EMFSecurityException
extends Exception {
    private static final String BODY_ERROR_CODE_PATH = "//*[local-name()='Fault']/  *[local-name()='detail']/ *[local-name()='exception']/ *[local-name()='errorCode']";
    private static final String HEADER_ERROR_MSG_PATH = "//*[local-name()='biBusHeader']/  *[local-name()='CAM']/ *[local-name()='exception']/*[local-name()='messages']";
    BIBusEnvelope m_error_envelope;
    Locale locale;
    private final String m_LOCALE_PATH = "//*[local-name()='biBusHeader']/*[local-name()='userPreferenceVars']//name[text()='contentLocale']/parent::*/value";

    public EMFSecurityException(BIBusEnvelope envelope) {
        this.m_error_envelope = envelope;
        this.locale = this.getHeaderLocale(this.m_error_envelope.getHeader());
    }

    public EMFSecurityException(BIBusEnvelope envelope, Exception cause) {
        super(cause);
        this.m_error_envelope = envelope;
        this.locale = this.getHeaderLocale(this.m_error_envelope.getHeader());
    }

    public EMFSecurityException(Locale locale) {
        this.m_error_envelope = null;
        this.locale = locale;
    }

    @Override
    public String getMessage() {
        return this.extractMessage();
    }

    public BIBusEnvelope getBIBusEnvelope() {
        return this.m_error_envelope;
    }

    private String extractMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(I18NUtil.getMessage(I18NCode.SEC_NO_ACCOUNT_INFO, this.locale));
        buffer.append("  ");
        if (this.m_error_envelope != null) {
            try {
                Element bodyErrorCodeElement = (Element)this.m_error_envelope.getBody().selectSingleNode(BODY_ERROR_CODE_PATH);
                if (bodyErrorCodeElement != null) {
                    String errorCode = bodyErrorCodeElement.getText();
                    if (errorCode.equals("cmHeaderFault")) {
                        Element headerErrorMsgElement = (Element)this.m_error_envelope.getHeader().selectSingleNode(HEADER_ERROR_MSG_PATH);
                        if (headerErrorMsgElement != null) {
                            this.appendChildMessages(buffer, headerErrorMsgElement);
                        }
                    } else {
                        buffer.append(errorCode);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    private void appendChildMessages(StringBuffer message, Element messages) {
        Iterator iterator = messages.elementIterator();
        while (iterator.hasNext()) {
            Element item = (Element)iterator.next();
            Element messageString = item.element("messageString");
            message.append(messageString.getText());
            message.append("  ");
        }
    }

    private Locale getHeaderLocale(Element header) {
        Node localeElement = header.selectSingleNode("//*[local-name()='biBusHeader']/*[local-name()='userPreferenceVars']//name[text()='contentLocale']/parent::*/value");
        if (localeElement != null) {
            String strLocale = localeElement.getText();
            this.locale = LocaleUtil.getLocale(strLocale);
        }
        if (this.locale == null) {
            Locale locale = LocaleUtil.getServerLocale();
        }
        return this.locale;
    }
}

