/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.security;

import com.cognos.developer.schemas.bibus._3.Identity;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Tenancy;

public class UserIdentity {
    private static final String PUBLIC_TENANT_ID = "";
    private String trueTenantID;
    private String[] readTenantIDs;
    private String writeTenantID;
    private boolean isImpersonating = false;
    private Role role;
    private boolean doTenantFiltering = false;
    private String[] tenantIDsForFiltering;

    public UserIdentity(Identity identity) {
        this.role = Role.NON_ADMIN;
        if (identity == null) {
            return;
        }
        SearchPathSingleObject[] camIDs = identity.getSelf();
        if (camIDs != null && camIDs.length > 0) {
            for (int i = 0; i < camIDs.length; ++i) {
                if (Role.SYSTEM_ADMIN.camID.equals(camIDs[i].get_value())) {
                    this.role = Role.SYSTEM_ADMIN;
                    break;
                }
                if (!Role.TENANT_ADMIN.camID.equals(camIDs[i].get_value())) continue;
                this.role = Role.TENANT_ADMIN;
            }
        }
        Tenancy tenancy = identity.getTenancy();
        this.trueTenantID = tenancy.getTenantID();
        this.writeTenantID = tenancy.getWriteTenantID();
        this.readTenantIDs = tenancy.getReadTenantIDs();
        this.isImpersonating = tenancy.isIsImpersonating();
        if (this.role.equals((Object)Role.NON_ADMIN)) {
            this.doTenantFiltering = true;
            this.tenantIDsForFiltering = this.readTenantIDs != null && this.readTenantIDs.length > 0 ? this.readTenantIDs : new String[]{PUBLIC_TENANT_ID, this.trueTenantID};
        } else if (this.readTenantIDs != null && this.readTenantIDs.length > 0) {
            this.doTenantFiltering = true;
            this.tenantIDsForFiltering = this.readTenantIDs;
        }
    }

    public UserIdentity(Role role, String trueTenantID, String[] readTenantIDs, boolean isImpersonating, boolean doFiltering, String[] tenantIDsForFiltering) {
        this.role = role;
        this.trueTenantID = trueTenantID;
        if (readTenantIDs != null) {
            this.readTenantIDs = (String[])readTenantIDs.clone();
        }
        this.isImpersonating = isImpersonating;
        this.doTenantFiltering = doFiltering;
        this.tenantIDsForFiltering = tenantIDsForFiltering;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean isImpersonating() {
        return this.isImpersonating;
    }

    public String getTrueTenantID() {
        return this.trueTenantID;
    }

    public String getWriteTenantID() {
        return this.writeTenantID;
    }

    public String getReadTenantIDsToString() {
        StringBuffer readTenantIDStrBuf = new StringBuffer("[");
        if (this.readTenantIDs != null) {
            for (int i = 0; i < this.readTenantIDs.length; ++i) {
                readTenantIDStrBuf.append(this.readTenantIDs[i]);
                if (i >= this.readTenantIDs.length - 1) continue;
                readTenantIDStrBuf.append(",");
            }
        }
        readTenantIDStrBuf.append("]");
        return readTenantIDStrBuf.toString();
    }

    public boolean doTenantFiltering() {
        return this.doTenantFiltering;
    }

    public String[] getTenantIDsForFiltering() {
        return this.tenantIDsForFiltering;
    }

    public static enum Role {
        SYSTEM_ADMIN("CAMID(\"::System Administrators\")"),
        TENANT_ADMIN("CAMID(\"::Tenant Administrators\")"),
        NON_ADMIN(null);

        public String camID = null;

        private Role(String camID) {
            this.camID = camID;
        }
    }
}

