/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.serverinst;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PingReply;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.PingHandler;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.net.MalformedURLException;
import java.net.URL;

public class DispatcherPingHandler
implements PingHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(SDSInstance staleInstance) {
        SDSInstance thisInstance;
        String dispatcherURLString = staleInstance.getUrl();
        if (dispatcherURLString.equals((thisInstance = SDSInstanceManager.getInstance().getThisInstance()).getUrl()) && staleInstance.getLastUpdate() < thisInstance.getLastUpdate()) {
            return false;
        }
        boolean isRunning = false;
        BiBusHeader header = new BiBusHeader();
        Tracking tracking = new Tracking();
        header.setTracking(tracking);
        IClientBase dispPort = null;
        try {
            URL dispatcherURL = new URL(dispatcherURLString);
            String dispatcherBaseURLString = dispatcherURL.getProtocol() + "://" + dispatcherURL.getHost() + ":" + dispatcherURL.getPort() + "/p2pd";
            String dispatcherSearchString = "/configuration/dispatcher[@name='" + dispatcherBaseURLString + "']";
            dispPort = Client.instance().getDispatcherClient(new JobBiBusHeaders(header));
            dispPort.signNextRequest("JSM");
            SearchPathSingleObject spso = new SearchPathSingleObject();
            spso.set_value(dispatcherSearchString);
            PingReply reply = dispPort.ping(spso);
            int upTime = reply.getUpTime();
            if (upTime > 0) {
                isRunning = true;
            }
        }
        catch (SDKClientException e) {
            this.debugLog((Object)this, "Error pinging a dispatcher: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            this.debugLog((Object)this, "Error pinging a dispatcher: " + e.getMessage());
        }
        catch (EMFSecurityException e) {
            this.debugLog((Object)this, "Error pinging a dispatcher: " + e.getMessage());
        }
        finally {
            if (dispPort != null) {
                dispPort.close();
            }
        }
        return isRunning;
    }

    private void debugLog(Object o, Throwable e) {
        this.debugLog(o, e.getMessage());
    }

    private void debugLog(Object o, String s) {
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(o, s);
    }
}

