/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.serverinst;

import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Dispatcher_Type;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunningStateEnum;
import com.cognos.developer.schemas.bibus._3.RunningStateEnumProp;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.p2plb.model.NodeID;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InstanceUtil {
    public static String TEST_LOCAL_DISPATCHER_GUID = null;
    private static final Map<String, String> mapDispatchers = Collections.synchronizedMap(new HashMap());

    public static URL getLocalDispatcherURL() throws Exception {
        NodeID dispatcherNodeId = NodeID.getSelf();
        String urlString = dispatcherNodeId.getURI();
        String host = dispatcherNodeId.getHost();
        urlString = InstanceUtil.replaceFirst(urlString, host, "localhost");
        return new URL(urlString);
    }

    private static String replaceFirst(String str, String regex, String replacement) {
        if (str == null) {
            return str;
        }
        int index = str.indexOf(regex);
        if (index >= 0) {
            str = str.substring(0, index) + replacement + str.substring(index + regex.length());
        }
        return str;
    }

    public static String getLocalDispatcherNodeIDGuid() {
        if (TEST_LOCAL_DISPATCHER_GUID != null) {
            return TEST_LOCAL_DISPATCHER_GUID;
        }
        String guid = null;
        NodeID dispatcherNodeId = NodeID.getSelf();
        if (dispatcherNodeId != null) {
            guid = dispatcherNodeId.getGuid();
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("InstanceUtil:getLocalDispatcherNodeIDGuid: guid='" + guid + "'");
        }
        return guid;
    }

    public static String getDispatcherPath(ContentManagerServiceClientPort cmPort, String dispatcherId) {
        String dispatcherPath = null;
        try {
            if (mapDispatchers.containsKey(dispatcherId)) {
                return mapDispatchers.get(dispatcherId);
            }
            mapDispatchers.clear();
            cmPort.signNextRequest("JSM");
            BaseClass[] dispatchers = cmPort.query(new SearchPathMultipleObject("//dispatcher"), new PropEnum[]{PropEnum.dispatcherPath, PropEnum.dispatcherID}, null, null);
            if (dispatchers == null) {
                return null;
            }
            for (int i = 0; i < dispatchers.length; ++i) {
                if (dispatchers[i] == null) continue;
                Dispatcher_Type dispatcher = (Dispatcher_Type)dispatchers[i];
                String dispatcherNodeID = dispatcher.getDispatcherID().getValue().get_value();
                String path = dispatcher.getDispatcherPath().getValue().toLowerCase();
                mapDispatchers.put(dispatcherNodeID, path);
                if (dispatcherId.indexOf(dispatcherNodeID) != 0) continue;
                dispatcherPath = path;
            }
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving dispatcher path");
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving dispatcher path");
        }
        return dispatcherPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNodeID(JobBiBusHeaders headers) {
        String dispatcherNodeID = null;
        ContentManagerServiceClientPort cmPort = null;
        IClientBase crnPort = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            cmPort.signNextRequest("JSM");
            BaseClass[] dispatchers = cmPort.query(new SearchPathMultipleObject("//dispatcher"), new PropEnum[]{PropEnum.dispatcherPath, PropEnum.dispatcherID}, null, null);
            String sdsInstanceURL = SDSInstanceManager.getInstance().getThisInstance().getUrl().toLowerCase();
            if (dispatchers != null && dispatchers.length > 0) {
                for (int i = 0; i < dispatchers.length && dispatcherNodeID == null; ++i) {
                    Dispatcher_Type dispatcher;
                    String dispatcherPath;
                    if (dispatchers[i] == null || sdsInstanceURL.indexOf(dispatcherPath = (dispatcher = (Dispatcher_Type)dispatchers[i]).getDispatcherPath().getValue().toLowerCase()) != 0) continue;
                    dispatcherNodeID = dispatcher.getDispatcherID().getValue().get_value();
                }
            }
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving dispatcherNode");
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving dispatcherNode");
        }
        finally {
            if (crnPort != null) {
                crnPort.close();
            }
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return dispatcherNodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseClass[] getListOfDispatchersFromCM(JobBiBusHeaders headers) {
        ContentManagerServiceClientPort cmPort = null;
        BaseClass[] dispatchers = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            cmPort.signNextRequest("JSM");
            dispatchers = cmPort.query(new SearchPathMultipleObject("//dispatcher"), new PropEnum[]{PropEnum.dispatcherPath, PropEnum.dispatcherID, PropEnum.runningState}, null, null);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving dispatcherNode");
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving dispatcherNode");
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return dispatchers;
    }

    public static boolean isDispatcherAvailable(JobBiBusHeaders headers, String dispatcherID) {
        boolean isDispatcherAvailable = false;
        if (headers != null && dispatcherID != null && !"".equals(dispatcherID.trim())) {
            BaseClass[] baseClassList = InstanceUtil.getListOfDispatchersFromCM(headers);
            Dispatcher_Type dispatcher = null;
            String strDispatcherId = null;
            for (BaseClass baseClass : baseClassList) {
                if (baseClass == null || !(baseClass instanceof Dispatcher_Type) || (strDispatcherId = (dispatcher = (Dispatcher_Type)baseClass).getDispatcherID().getValue().get_value()) == null || !dispatcherID.equals(strDispatcherId.trim())) continue;
                RunningStateEnum rse = dispatcher.getRunningState().getValue();
                if (!rse.equals((Object)RunningStateEnum.running)) break;
                isDispatcherAvailable = true;
                break;
            }
        }
        return isDispatcherAvailable;
    }

    public static int isServiceRunningOnDispatcher(JobBiBusHeaders headers, String dispatcherID, String serviceName) {
        int isServiceAvailableOnDispatcher = 1;
        if (headers != null && dispatcherID != null && !"".equals(dispatcherID.trim())) {
            BaseClass[] baseClassList = InstanceUtil.getListOfDispatchersFromCM(headers);
            Dispatcher_Type dispatcher = null;
            String strDispatcherId = null;
            for (BaseClass baseClass : baseClassList) {
                if (baseClass == null || !(baseClass instanceof Dispatcher_Type) || (strDispatcherId = (dispatcher = (Dispatcher_Type)baseClass).getDispatcherID().getValue().get_value()) == null || !dispatcherID.equals(strDispatcherId.trim())) continue;
                RunningStateEnum rse = dispatcher.getRunningState().getValue();
                if (rse.equals((Object)RunningStateEnum.running)) {
                    if (InstanceUtil.isServiceRunningOnDispatcher(headers, dispatcher.getDispatcherPath(), serviceName)) {
                        isServiceAvailableOnDispatcher = 0;
                        break;
                    }
                    isServiceAvailableOnDispatcher = 2;
                    break;
                }
                isServiceAvailableOnDispatcher = 1;
                break;
            }
        }
        return isServiceAvailableOnDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceRunningOnDispatcher(JobBiBusHeaders headers, AnyURIProp dispatcherURL, String serviceName) {
        boolean isServiceRunningOnDispatcher = false;
        String strDispatcherURL = dispatcherURL != null ? dispatcherURL.getValue() : null;
        String strServicePath = null;
        if (headers != null && strDispatcherURL != null && !"".equals(strDispatcherURL.trim()) && serviceName != null && !"".equals(serviceName.trim())) {
            ContentManagerServiceClientPort cmPort = null;
            strServicePath = "/configuration//dispatcher[@dispatcherPath='" + strDispatcherURL + "']/" + serviceName;
            try {
                cmPort = Client.instance().getContentManagerServiceClient(headers);
                cmPort.signNextRequest("JSM");
                BaseClass[] serviceInfoList = cmPort.query(new SearchPathMultipleObject(strServicePath), new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.runningState}, null, null);
                RunningStateEnumProp serviceRunningState = null;
                Method m = null;
                for (BaseClass serviceInfo : serviceInfoList) {
                    try {
                        m = serviceInfo.getClass().getMethod("getRunningState", new Class[0]);
                        if (m == null || (serviceRunningState = (RunningStateEnumProp)m.invoke((Object)serviceInfo, new Object[0])) == null || serviceRunningState.getValue() == null || !serviceRunningState.getValue().equals((Object)RunningStateEnum.running)) continue;
                        isServiceRunningOnDispatcher = true;
                        break;
                    }
                    catch (NoSuchMethodException nsme) {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(nsme);
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving the running state for the service " + strServicePath);
                    }
                    catch (IllegalAccessException iae) {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(iae);
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving the running state for the service " + strServicePath);
                    }
                    catch (InvocationTargetException ite) {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(ite);
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving the running state for the service " + strServicePath);
                    }
                }
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving service information");
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving service information");
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
        return isServiceRunningOnDispatcher;
    }
}

