/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.serverinst;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.Dispatcher_Type;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import java.util.Date;

public class SDSInstance {
    String m_guid;
    String m_url;
    long m_lastUpdate;

    public SDSInstance(String guid, String url) {
        this.m_guid = guid;
        this.m_url = url;
        this.m_lastUpdate = new Date().getTime();
    }

    SDSInstance(String guid, String url, long lastUpdate) {
        this.m_guid = guid;
        this.m_url = url;
        this.m_lastUpdate = lastUpdate;
    }

    public String getGuid() {
        return this.m_guid;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setLastUpdate(long lastUpdate) {
        this.m_lastUpdate = lastUpdate;
    }

    public boolean equals(Object obj) {
        return ((SDSInstance)obj).m_guid.equals(this.m_guid);
    }

    public int hashCode() {
        return this.m_guid.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatcher_Type getDispatcherType(BiBusHeader header) throws SDKClientException, EMFSecurityException {
        ContentManagerServiceClientPort cmPort = null;
        CAM cam = header.getCAM();
        header.setCAM(null);
        try {
            cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            cmPort.signNextRequest("JSM");
            BaseClass[] dispatchers = cmPort.query(new SearchPathMultipleObject("//dispatcher"), new PropEnum[]{PropEnum.dispatcherPath, PropEnum.dispatcherID}, null, null);
            String sdsInstanceURL = this.m_url.toLowerCase();
            Object dispatcherNodeID = null;
            if (dispatchers != null && dispatchers.length > 0) {
                for (int i = 0; i < dispatchers.length && dispatcherNodeID == null; ++i) {
                    Dispatcher_Type dispatcher;
                    String dispatcherPath;
                    if (dispatchers[i] == null || sdsInstanceURL.indexOf(dispatcherPath = (dispatcher = (Dispatcher_Type)dispatchers[i]).getDispatcherPath().getValue().toLowerCase()) != 0) continue;
                    Dispatcher_Type dispatcher_Type = dispatcher;
                    return dispatcher_Type;
                }
            }
        }
        finally {
            header.setCAM(cam);
            cmPort.close();
        }
        return null;
    }
}

