/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.serverinst;

import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.GuidIdGenerator;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.serverinst.InstanceFailedEvent;
import com.cognos.jsmcommon.serverinst.PingHandler;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceListener;
import com.cognos.jsmcommon.serverinst.UrlPingHandler;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SDSInstanceManager {
    private static SDSInstanceManager m_instance = new SDSInstanceManager();
    private static final String TABLE_NAME = "NC_SDS_INSTANCE";
    private static final String F_INSTANCE_ID = "PK_INSTANCE_ID";
    private static final String F_INSTANCE_URL = "PK_INSTANCE_URL";
    private static final String F_LAST_UPDATE = "LAST_UPDATE";
    private static final String F_CLEANUP_ID = "CLEANUP_INSTANCE_ID";
    private static final int CHECK_INTERVAL_MULTIPLIER = 2;
    private static final String DEFAULT_INTERVAL = "30000";
    private static final String LOCALHOST = "localhost";
    private Set<SDSInstanceListener> m_listeners = Collections.synchronizedSet(new HashSet());
    long m_sdsInstanceUpdateInterval = Long.MAX_VALUE;
    long m_sdsInstanceCheckInterval = Long.MAX_VALUE;
    long m_sdsInstanceCheckFirstInterval;
    private long m_sdsInstaceMaxAge;
    private List<SDSInstance> m_otherInstancesHistory = Collections.synchronizedList(new ArrayList());
    private SDSInstance m_thisInstance;
    protected InstanceUpdaterThread m_instanceUpdater;
    private InstanceCheckerThread m_instanceChecker;
    private boolean m_started = false;
    private PingHandler pingHandler = new UrlPingHandler();
    private int liveInstances = 0;
    private String m_recoveredFromCrash;
    private static final String INSERT_INSTANCE_SQL = new StringBuffer().append("INSERT INTO ").append("NC_SDS_INSTANCE").append(" (").append("PK_INSTANCE_ID").append(", ").append("PK_INSTANCE_URL").append(", ").append("LAST_UPDATE").append(")  VALUES (?,?,?)").toString();
    private final String DELETE_INSTANCE_BY_ID_SQL = new StringBuffer().append("DELETE FROM ").append("NC_SDS_INSTANCE").append(" WHERE ").append("PK_INSTANCE_ID").append(" = ?").toString();
    private static final String SELECT_ALL_INSTANCES_SQL = new StringBuffer("").append("SELECT ").append("PK_INSTANCE_ID").append(", ").append("PK_INSTANCE_URL").append(", ").append("LAST_UPDATE").append(" FROM ").append("NC_SDS_INSTANCE").toString();
    private static final String SELECT_INSTANCE_BY_ID_SQL = new StringBuffer("").append("SELECT ").append("PK_INSTANCE_ID").append(", ").append("PK_INSTANCE_URL").append(", ").append("LAST_UPDATE").append(" FROM ").append("NC_SDS_INSTANCE").append(" WHERE ").append("PK_INSTANCE_ID").append(" = ?").toString();
    private static final String SELECT_INSTANCE_BY_URL_SQL = new StringBuffer("").append("SELECT ").append("PK_INSTANCE_ID").append(", ").append("PK_INSTANCE_URL").append(", ").append("LAST_UPDATE").append(" FROM ").append("NC_SDS_INSTANCE").append(" WHERE ").append("PK_INSTANCE_URL").append(" = ?").toString();
    private final String UPDATE_INSTANCE_DATE_SQL = new StringBuffer("").append("UPDATE ").append("NC_SDS_INSTANCE").append(" SET ").append("LAST_UPDATE").append(" = ? ").append(" WHERE ").append("PK_INSTANCE_ID").append(" = ?").toString();
    private final String UPDATE_INSTANCE_FOR_CLEANUP_SQL = new StringBuffer("").append("UPDATE ").append("NC_SDS_INSTANCE").append(" SET ").append("LAST_UPDATE").append(" = ?, ").append("CLEANUP_INSTANCE_ID").append(" = ? ").append(" WHERE ").append("PK_INSTANCE_ID").append(" = ? AND ").append("LAST_UPDATE").append(" = ?").toString();

    protected SDSInstanceManager() {
        String instanceGuid = GuidIdGenerator.createNew().toString();
        String instanceURL = null;
        try {
            instanceURL = CRNProperties.getInstance().getProperty("internalDispatcher");
        }
        catch (PropertiesException e) {
            instanceURL = "CRNProperty error getting dispatcher url";
        }
        try {
            String updateIntervalString = CRNProperties.getInstance().getProperty("sds.instance.interval");
            this.m_sdsInstanceUpdateInterval = this.getUpdateInterval(updateIntervalString);
        }
        catch (PropertiesException updateIntervalString) {
            // empty catch block
        }
        this.m_sdsInstanceCheckInterval = this.m_sdsInstanceUpdateInterval * 2L;
        this.m_sdsInstaceMaxAge = this.m_sdsInstanceUpdateInterval * 3L;
        if (this.m_sdsInstanceCheckInterval < this.m_sdsInstanceUpdateInterval) {
            this.m_sdsInstanceCheckInterval = Long.MAX_VALUE;
        }
        this.m_sdsInstanceCheckFirstInterval = this.m_sdsInstanceCheckInterval;
        try {
            URL dispatcherURL = new URL(instanceURL);
            String host = dispatcherURL.getHost();
            if (host.equalsIgnoreCase(LOCALHOST)) {
                String newURLString;
                String resolvedHost = InetAddress.getLocalHost().getHostName();
                int startIndex = instanceURL.indexOf(host);
                int endIndex = startIndex + host.length();
                instanceURL = newURLString = instanceURL.substring(0, startIndex) + resolvedHost + instanceURL.substring(endIndex);
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.m_thisInstance = new SDSInstance(instanceGuid, instanceURL);
        this.debugLog((Object)this, "created sds instance with ID " + instanceGuid);
    }

    public static SDSInstanceManager getInstance() {
        return m_instance;
    }

    public String getRecoveredFromCrash() {
        return this.m_recoveredFromCrash;
    }

    public synchronized void addInstanceListener(SDSInstanceListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
        this.start();
    }

    public synchronized void clearInstanceListeners() {
        this.m_listeners.clear();
        this.stop();
    }

    public synchronized void removeInstanceListener(SDSInstanceListener listener) {
        this.m_listeners.remove(listener);
        this.stop();
    }

    private void registerInstance() {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("SDSInstanceManager.registerInstance");
        try {
            this.insertIntoRepository(this.getThisInstance());
        }
        finally {
            zipiTimer.stop();
        }
    }

    public synchronized SDSInstance getSDSInstance(String id) {
        SDSInstance result = null;
        for (SDSInstance instance : this.m_otherInstancesHistory) {
            if (!instance.getGuid().equals(id)) continue;
            result = instance;
            break;
        }
        if (result == null && this.getThisInstance().getGuid().equals(id)) {
            result = this.getThisInstance();
        }
        if (result == null) {
            result = this.getDbInstanceById(id);
        }
        return result;
    }

    public synchronized void checkIsFailedSDSInstance(SDSInstanceListener listener, String instanceID) {
        SDSInstance sdsInstance = this.getSDSInstance(instanceID);
        if (sdsInstance == null) {
            SDSInstance unknownInstance = new SDSInstance(instanceID, null);
            listener.instanceFailed(new InstanceFailedEvent(this, unknownInstance));
        }
    }

    SDSInstance getDbInstanceById(String id) {
        return this.getDbInstance(SELECT_INSTANCE_BY_ID_SQL, id);
    }

    private SDSInstance getDbInstanceByUrl(String id) {
        return this.getDbInstance(SELECT_INSTANCE_BY_URL_SQL, id);
    }

    private SDSInstance getDbInstance(final String sql, final String id) {
        SQLExecute<SDSInstance> retriever = new SQLExecute<SDSInstance>(){

            @Override
            public SDSInstance execute() throws TaskPersistLayerException {
                SDSInstance result = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, id);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        String returnedId = rs.getString(1);
                        String returnedUrl = rs.getString(2);
                        long lastUpdate = rs.getLong(3);
                        result = new SDSInstance(returnedId, returnedUrl, lastUpdate);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return result;
            }
        };
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            return handler.execute(retriever);
        }
        catch (TaskPersistLayerException tple) {
            this.debugLog((Object)this, tple);
            return null;
        }
    }

    public synchronized void insertIntoRepository(final SDSInstance instance) {
        SQLExecute<Integer> inserter = new SQLExecute<Integer>(){

            @Override
            public Integer execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(INSERT_INSTANCE_SQL);
                    ps.setString(1, instance.getGuid());
                    ps.setString(2, instance.getUrl());
                    ps.setLong(3, instance.getLastUpdate());
                    Integer n = ps.executeUpdate();
                    return n;
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
            }
        };
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(inserter);
        }
        catch (TaskPersistLayerException tple) {
            this.debugLog((Object)this, tple);
        }
    }

    synchronized boolean deleteFromRepository(final SDSInstance instance) {
        SQLExecute<Boolean> deleter = new SQLExecute<Boolean>(){

            @Override
            public Boolean execute() throws TaskPersistLayerException {
                boolean deleteSuccessful = false;
                PreparedStatement ps = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(SDSInstanceManager.this.DELETE_INSTANCE_BY_ID_SQL);
                    ps.setString(1, instance.getGuid());
                    deleteSuccessful = ps.executeUpdate() > 0;
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps);
                return deleteSuccessful;
            }
        };
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            return handler.execute(deleter);
        }
        catch (TaskPersistLayerException tple) {
            this.debugLog((Object)this, tple);
            return false;
        }
    }

    private synchronized void updateRepositoryInstance(final SDSInstance instance, final boolean attemptReinsert) {
        SQLExecute<Integer> updater = new SQLExecute<Integer>(){

            @Override
            public Integer execute() throws TaskPersistLayerException {
                boolean canAttemptedReinsertOnFail = attemptReinsert;
                boolean attemptReInsert = false;
                Integer updateCount = 0;
                ZipiTimer zipiTimer = ZipiBridge.startTimer("InstanceUpdaterThread.updateRepositoryInstance");
                PreparedStatement ps = null;
                try {
                    instance.setLastUpdate(new Date().getTime());
                    ps = TaskPersistLayer.prepareStatement(SDSInstanceManager.this.UPDATE_INSTANCE_DATE_SQL);
                    ps.setLong(1, instance.getLastUpdate());
                    ps.setString(2, instance.getGuid());
                    updateCount = ps.executeUpdate();
                    attemptReInsert = updateCount != 1;
                }
                catch (SQLException e) {
                    try {
                        attemptReInsert = true;
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps);
                        zipiTimer.stopAndClear();
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps);
                zipiTimer.stopAndClear();
                if (attemptReInsert && canAttemptedReinsertOnFail) {
                    SDSInstanceManager.this.debugLog(this, "attempting to restart the monitor heartbeat");
                    canAttemptedReinsertOnFail = false;
                    SDSInstanceManager.this.insertIntoRepository(instance);
                }
                return updateCount;
            }
        };
        try {
            SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            handler.execute(updater);
        }
        catch (TaskPersistLayerException tple) {
            this.debugLog((Object)this, tple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRepositoryForCleanup(SDSInstance instanceToClean) {
        boolean weAreGameOnForTheCleanup = false;
        this.getThisInstance().setLastUpdate(new Date().getTime());
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(this.UPDATE_INSTANCE_FOR_CLEANUP_SQL);
            ps.setLong(1, new Date().getTime());
            ps.setString(2, this.getThisInstance().getGuid());
            ps.setString(3, instanceToClean.getGuid());
            ps.setLong(4, instanceToClean.getLastUpdate());
            weAreGameOnForTheCleanup = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                this.debugLog((Object)this, e);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, ps);
                if (conn != null) {
                    try {
                        this.releaseConnection(conn);
                    }
                    catch (SQLException e2) {
                        this.debugLog((Object)this, e2);
                    }
                }
                throw throwable;
            }
            SqlResourceCloser.closeResources(null, ps);
            if (conn != null) {
                try {
                    this.releaseConnection(conn);
                }
                catch (SQLException e3) {
                    this.debugLog((Object)this, e3);
                }
            }
        }
        SqlResourceCloser.closeResources(null, ps);
        if (conn != null) {
            try {
                this.releaseConnection(conn);
            }
            catch (SQLException e) {
                this.debugLog((Object)this, e);
            }
        }
        return weAreGameOnForTheCleanup;
    }

    public int getOtherInstanceCount() {
        return this.m_otherInstancesHistory == null ? 1 : this.m_otherInstancesHistory.size();
    }

    public synchronized SDSInstance getThisInstance() {
        return this.m_thisInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SDSInstance> getRepositoryInstances() {
        ArrayList<SDSInstance> otherInstances = new ArrayList<SDSInstance>();
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("SDSInstanceManager.getRepositoryInstances");
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(SELECT_ALL_INSTANCES_SQL);
            rs = ps.executeQuery();
            while (rs.next()) {
                String id = rs.getString(1);
                String url = rs.getString(2);
                long lastUpdate = rs.getLong(3);
                if (id.equals(this.getThisInstance().getGuid())) continue;
                otherInstances.add(new SDSInstance(id, url, lastUpdate));
            }
        }
        catch (SQLException e) {
            try {
                this.debugLog((Object)this, e);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, ps);
                if (conn != null) {
                    try {
                        this.releaseConnection(conn);
                    }
                    catch (SQLException e2) {
                        this.debugLog((Object)this, e2);
                    }
                }
                zipiTimer.stop();
                throw throwable;
            }
            SqlResourceCloser.closeResources(rs, ps);
            if (conn != null) {
                try {
                    this.releaseConnection(conn);
                }
                catch (SQLException e3) {
                    this.debugLog((Object)this, e3);
                }
            }
            zipiTimer.stop();
        }
        SqlResourceCloser.closeResources(rs, ps);
        if (conn != null) {
            try {
                this.releaseConnection(conn);
            }
            catch (SQLException e) {
                this.debugLog((Object)this, e);
            }
        }
        zipiTimer.stop();
        return otherInstances;
    }

    private synchronized void notifyInstancesChanged(List<SDSInstance> instances) {
        Iterator<SDSInstanceListener> sdili = this.m_listeners.iterator();
        while (sdili.hasNext()) {
            sdili.next().otherInstanceCountChanged(instances);
        }
    }

    public synchronized List<SDSInstance> doStaleInstanceChecks() {
        ArrayList<SDSInstance> staleInstances = null;
        List<SDSInstance> dbInstances = this.getRepositoryInstances();
        block0: for (SDSInstance historyInstance : this.m_otherInstancesHistory) {
            for (SDSInstance dbInstance : dbInstances) {
                long entryAge;
                if (!historyInstance.getGuid().equals(dbInstance.getGuid())) continue;
                if (historyInstance.getLastUpdate() != dbInstance.getLastUpdate() || (entryAge = new Date().getTime() - dbInstance.getLastUpdate()) <= this.m_sdsInstaceMaxAge) continue block0;
                if (staleInstances == null) {
                    staleInstances = new ArrayList<SDSInstance>();
                }
                staleInstances.add(dbInstance);
                continue block0;
            }
        }
        this.m_otherInstancesHistory.clear();
        this.m_otherInstancesHistory.addAll(dbInstances);
        return staleInstances;
    }

    public boolean ping(SDSInstance staleInstance) {
        return this.pingHandler.ping(staleInstance);
    }

    private JDBCConnection getConnection() throws SQLException {
        JDBCConnection connection = null;
        connection = NCConnection.instance().getConnectionFactory().createConnection();
        return connection;
    }

    private void releaseConnection(JDBCConnection conn) throws SQLException {
        NCConnection.instance().getConnectionFactory().releaseConnection(conn);
    }

    private synchronized void start() {
        if (this.m_started) {
            return;
        }
        this.m_started = true;
        this.debugLog((Object)this, "starting sds instance manager");
        SDSInstance inst = this.getDbInstanceByUrl(this.m_thisInstance.getUrl());
        if (inst != null) {
            if (inst.getGuid().equals(this.m_thisInstance.getGuid())) {
                this.restart();
            } else {
                this.crashRecoveryStart(inst);
            }
        } else {
            this.cleanStart(inst);
        }
        this.m_instanceUpdater = new InstanceUpdaterThread(this.getThisInstance(), true);
        this.m_instanceChecker = new InstanceCheckerThread();
        this.m_instanceUpdater.setDaemon(true);
        this.m_instanceChecker.setDaemon(true);
        this.m_instanceUpdater.start();
        this.m_instanceChecker.start();
        this.debugLog((Object)this, "started sds instance manager");
    }

    private void restart() {
        this.m_sdsInstanceCheckFirstInterval = this.m_sdsInstanceCheckInterval;
        this.m_recoveredFromCrash = null;
    }

    private void cleanStart(SDSInstance inst) {
        this.m_sdsInstanceCheckFirstInterval = this.m_sdsInstanceCheckInterval;
        this.m_recoveredFromCrash = null;
        this.registerInstance();
    }

    private void crashRecoveryStart(SDSInstance inst) {
        this.m_sdsInstanceCheckFirstInterval = Math.min(20000L, this.m_sdsInstanceCheckInterval);
        this.m_otherInstancesHistory.add(inst);
        this.m_recoveredFromCrash = inst.getGuid();
        this.registerInstance();
    }

    protected synchronized void stop() {
        if (!this.m_started) {
            return;
        }
        if (this.m_listeners.size() > 0) {
            return;
        }
        this.m_instanceUpdater.setEnabled(false);
        this.m_instanceChecker.setEnabled(false);
        this.m_instanceUpdater.interrupt();
        this.m_instanceChecker.interrupt();
        this.m_instanceChecker = null;
        this.m_instanceUpdater = null;
        this.m_started = false;
    }

    public synchronized void testStop() {
        this.m_listeners.clear();
        if (this.m_instanceUpdater != null) {
            this.m_instanceUpdater.setEnabled(false);
            this.m_instanceUpdater.interrupt();
            this.m_instanceUpdater = null;
        }
        if (this.m_instanceChecker != null) {
            this.m_instanceChecker.setEnabled(false);
            this.m_instanceChecker.interrupt();
            this.m_instanceChecker = null;
        }
        this.m_started = false;
    }

    public synchronized void clear() {
        this.m_listeners.clear();
        if (this.m_instanceUpdater != null) {
            this.m_instanceUpdater.setEnabled(false);
            this.m_instanceUpdater.interrupt();
            this.m_instanceUpdater = null;
        }
        if (this.m_instanceChecker != null) {
            this.m_instanceChecker.setEnabled(false);
            this.m_instanceChecker.interrupt();
            this.m_instanceChecker = null;
        }
        this.m_started = false;
        this.deleteFromRepository(this.m_thisInstance);
        m_instance = new SDSInstanceManager();
    }

    private void debugLog(Object o, Throwable e) {
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(e);
        this.debugLog(o, e.getMessage());
    }

    private void debugLog(Object o, String s) {
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(o, s);
    }

    private long getUpdateInterval(String updateIntervalString) {
        long updateInterval = 0L;
        if (updateIntervalString == null || updateIntervalString.equals("")) {
            updateInterval = Long.valueOf(DEFAULT_INTERVAL);
        } else {
            try {
                updateInterval = Long.parseLong(updateIntervalString);
                updateInterval = updateInterval <= 0L ? Long.MAX_VALUE : (updateInterval *= 1000L);
            }
            catch (NumberFormatException ex) {
                this.debugLog((Object)this, ex);
                updateInterval = Long.valueOf(DEFAULT_INTERVAL);
            }
        }
        return updateInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void updateInstances(boolean alwaysNotify) {
        List<SDSInstance> staleInstances = this.doStaleInstanceChecks();
        if (staleInstances != null) {
            for (SDSInstance staleInstance : staleInstances) {
                if (!staleInstance.getGuid().equals(this.m_recoveredFromCrash) && this.ping(staleInstance) || !this.updateRepositoryForCleanup(staleInstance)) continue;
                InstanceUpdaterThread iut = null;
                try {
                    iut = (SDSInstanceManager)this.new InstanceUpdaterThread(staleInstance, false);
                    iut.start();
                    InstanceFailedEvent event = new InstanceFailedEvent(this, staleInstance);
                    SDSInstanceListener[] listeners = null;
                    SDSInstanceListener[] sDSInstanceListenerArray = this;
                    // MONITORENTER : this
                    listeners = this.m_listeners.toArray(new SDSInstanceListener[0]);
                    // MONITOREXIT : sDSInstanceListenerArray
                    for (SDSInstanceListener listener : listeners) {
                        listener.instanceFailed(event);
                    }
                    sDSInstanceListenerArray = this;
                    // MONITORENTER : this
                    if (event.getCanDeleteFailedInstance()) {
                        this.deleteFromRepository(staleInstance);
                        this.m_otherInstancesHistory.remove(staleInstance);
                    } else {
                        super.debugLog((Object)this, "Unable to complete recovery of sdsInstance: " + staleInstance.getGuid());
                    }
                    // MONITOREXIT : sDSInstanceListenerArray
                }
                finally {
                    if (iut == null) continue;
                    iut.setEnabled(false);
                    iut.interrupt();
                }
            }
        }
        SDSInstanceListener[] sDSInstanceListenerArray = this;
        // MONITORENTER : this
        if (alwaysNotify || this.liveInstances != this.m_otherInstancesHistory.size()) {
            this.notifyInstancesChanged(this.m_otherInstancesHistory);
        }
        this.liveInstances = this.m_otherInstancesHistory.size();
        // MONITOREXIT : sDSInstanceListenerArray
    }

    public synchronized void notifyInstancesChanged() {
        this.notifyInstancesChanged(this.m_otherInstancesHistory);
    }

    public void setPingHandler(PingHandler pingHandler) {
        this.pingHandler = pingHandler;
    }

    public static void main(String[] args) {
        SDSInstanceManager sdsInstanceChecker = SDSInstanceManager.getInstance();
        sdsInstanceChecker.start();
    }

    class InstanceCheckerThread
    extends Thread {
        private boolean m_isEnabled;

        InstanceCheckerThread() {
            super("JSM.Instance.Checker");
            this.m_isEnabled = true;
        }

        public void setEnabled(boolean enable) {
            this.m_isEnabled = enable;
        }

        @Override
        public void run() {
            boolean firstRun = true;
            while (this.m_isEnabled) {
                try {
                    if (firstRun) {
                        firstRun = false;
                        Thread.sleep(SDSInstanceManager.this.m_sdsInstanceCheckFirstInterval);
                    } else {
                        Thread.sleep(SDSInstanceManager.this.m_sdsInstanceCheckInterval);
                    }
                    ZipiTimer zipiTimer = ZipiBridge.startTimer("InstanceCheckerThread.doStaleChecksAndCleanUp");
                    try {
                        SDSInstanceManager.this.updateInstances(false);
                    }
                    finally {
                        zipiTimer.stopAndClear();
                    }
                }
                catch (InterruptedException e) {
                    SDSInstanceManager.this.debugLog(this, e);
                }
                catch (Throwable e) {
                    SDSInstanceManager.this.debugLog(this, e);
                }
            }
        }
    }

    class InstanceUpdaterThread
    extends Thread {
        private SDSInstance m_sdsInstance;
        private boolean m_isEnabled;
        private boolean m_attemptReinsert;

        InstanceUpdaterThread(SDSInstance sdsInstance, boolean attemptReinsert) {
            super("JSM.Instance.Updater");
            this.m_isEnabled = true;
            this.m_sdsInstance = sdsInstance;
            this.m_attemptReinsert = attemptReinsert;
        }

        public void setEnabled(boolean enable) {
            this.m_isEnabled = enable;
        }

        @Override
        public void run() {
            boolean sleep = true;
            while (this.m_isEnabled) {
                try {
                    if (sleep) {
                        Thread.sleep(SDSInstanceManager.this.m_sdsInstanceUpdateInterval);
                    }
                    SDSInstanceManager.this.updateRepositoryInstance(this.m_sdsInstance, this.m_attemptReinsert);
                    sleep = true;
                }
                catch (InterruptedException e) {
                    sleep = !sleep;
                    SDSInstanceManager.this.debugLog(this, e);
                }
                catch (Throwable e) {
                    SDSInstanceManager.this.debugLog(this, e);
                    sleep = !sleep;
                }
            }
        }
    }
}

