/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.serverinst;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.serverinst.PingHandler;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlPingHandler
implements PingHandler {
    private static final int DEFAULT_PING_CONNECTION_TIMEOUT = 10000;

    @Override
    public boolean ping(SDSInstance staleInstance) {
        boolean pingOk = true;
        int pingTimeout = CRNProperties.getInstance().getIntProperty("sds.ping.connection.timeout", 10000);
        try {
            URL url = new URL(staleInstance.getUrl());
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setConnectTimeout(pingTimeout);
            int responseCode = huc.getResponseCode();
            pingOk = responseCode == 200;
        }
        catch (Throwable e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, e.getLocalizedMessage());
            pingOk = false;
        }
        return pingOk;
    }
}

