/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.service;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.util.BiBusSoapAction;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ApiTransformer {
    protected static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ApiTransformer.class.getName());
    protected static final String XALAN_TRANSFORMER_FACTORY = "org.apache.xalan.processor.TransformerFactoryImpl";
    protected static final String JDXSLT_TRANSFORMER_FACTORY = "jd.xml.xslt.trax.TransformerFactoryImpl";
    private static List<String> additionalTransformPackages = new ArrayList<String>();
    private String transformPackage;

    public ApiTransformer(String transformPackage) {
        this.transformPackage = transformPackage;
    }

    private TransformerFactory getFactory() throws Exception {
        TransformerFactory factory = null;
        try {
            factory = TransformerFactory.newInstance();
        }
        catch (Exception ex) {
            logger.error("cannot instantiate factory for 'jd.xml.xslt.trax.TransformerFactoryImpl'", (Throwable)ex);
            throw ex;
        }
        URIResolver resolver = new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                StreamSource ss = null;
                InputStream transformStream = this.getClass().getResourceAsStream(ApiTransformer.this.transformPackage + href);
                if (transformStream != null) {
                    ss = new StreamSource(transformStream);
                    ss.setSystemId(ApiTransformer.this.transformPackage + href);
                }
                return ss;
            }
        };
        factory.setURIResolver(resolver);
        return factory;
    }

    protected Element transform(Element requestEnvelope, String actionName, String[] soapAction) throws LocalizableException {
        try {
            String transformedEnv = this.transformToString(requestEnvelope, actionName, soapAction);
            if (transformedEnv != null) {
                Document document = DocumentHelper.parseText((String)transformedEnv);
                return document.getRootElement();
            }
        }
        catch (DocumentException e) {
            throw new LocalizableException(I18NCode.OTH_TRANSFORM_ERROR, new Object[]{e.getMessage()}){};
        }
        return null;
    }

    public String getResponseActionName(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (envelope != null) {
            return this.getActionName(envelope);
        }
        return null;
    }

    public String getRequestActionName(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (envelope != null) {
            return this.getActionName(envelope);
        }
        return null;
    }

    public String getActionName(BIBusEnvelope envelope) {
        Element body = envelope.getBody();
        if (body != null) {
            return this.getActionName(body);
        }
        return null;
    }

    public String getActionName(Element soapBody) {
        Element operationElement = (Element)soapBody.selectSingleNode("./*");
        if (operationElement != null) {
            return operationElement.getName();
        }
        return null;
    }

    public String transformToString(BIBusEnvelope requestEnvelope, String[] soapAction) throws LocalizableException {
        return this.transformToString(requestEnvelope.getAsDocument().getRootElement(), this.getActionName(requestEnvelope), soapAction);
    }

    protected String transformToString(Element requestEnvelope, String actionName, String[] soapAction) throws LocalizableException {
        String transformedEnvelope = null;
        try {
            InputStream transformStream = this.findResource(actionName, this.extractSoapActionVersion(soapAction));
            if (transformStream != null) {
                StringReader input = new StringReader(requestEnvelope.asXML());
                StringWriter output = new StringWriter();
                TransformerFactory tFactory = this.getFactory();
                Templates templates = tFactory.newTemplates(new StreamSource(transformStream));
                Transformer transformer = templates.newTransformer();
                transformer.transform(new StreamSource(input), new StreamResult(output));
                transformedEnvelope = output.toString();
            }
        }
        catch (Exception e) {
            throw new LocalizableException(I18NCode.OTH_TRANSFORM_ERROR, new Object[]{e.getMessage()}){};
        }
        return transformedEnvelope;
    }

    private String extractSoapActionVersion(String[] soapAction) {
        String version = null;
        if (soapAction != null && soapAction.length > 0) {
            BiBusSoapAction action = new BiBusSoapAction(soapAction[0]);
            version = action.getVersion();
        }
        return version;
    }

    private InputStream findResource(String actionName, String version) {
        StringBuffer resourceBuff = new StringBuffer(this.transformPackage);
        if (version != null) {
            if (!version.startsWith("_")) {
                resourceBuff.append("_");
            }
            resourceBuff.append(version);
            resourceBuff.append("/");
        }
        resourceBuff.append(actionName);
        resourceBuff.append(".xsl");
        InputStream resource = this.getClass().getResourceAsStream(resourceBuff.toString());
        if (resource == null && additionalTransformPackages != null && additionalTransformPackages.size() > 0) {
            for (String resourcePackage : additionalTransformPackages) {
                resource = this.getClass().getResourceAsStream(resourcePackage + actionName + ".xsl");
                if (resource == null) continue;
                break;
            }
        }
        return resource;
    }

    public void setTransformPackage(String transformPackage) {
        this.transformPackage = transformPackage;
    }

    public static void addAdditionalTransformPackage(String transformPackage) {
        additionalTransformPackages.add(transformPackage);
    }

    public static void clearAdditionalTransformPackage(String transformPackage) {
        additionalTransformPackages.clear();
    }
}

