/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.service;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ValidateSOAPHandler
extends BasicHandler {
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName SOAPHeader = QName.get((String)"Header", (Namespace)NS_SOAP_ENV);
    private static Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ValidateSOAPHandler.class.getName());
    private static final String err = ValidateSOAPHandler.class.getName() + "Error trying to validate soap envelope";

    public ValidateSOAPHandler() {
        super(cat);
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            Document doc = envelope.getAsDocument();
            Element el = doc.getRootElement().element(SOAPHeader).element("biBusHeader");
            String passport = el.element("CAM").element("CAMPassport").elementText("id");
            String docSOAPActionVersion = el.element("dispatcherTransportVars").selectSingleNode("//*[name='originalSOAPAction']/value").getText();
            if (passport != null && !passport.isEmpty()) {
                String highestVersion = (String)BridgeHandler.getSupportedVersions().get(0);
                if (docSOAPActionVersion != null && !docSOAPActionVersion.contains(highestVersion)) {
                    if (BridgeHandler.BRIDGE_ACTIVATED) {
                        String oldVersion = (String)BridgeHandler.getSupportedVersions().get(1);
                        BridgeHandler.processMessage((Document)doc, (String)oldVersion, (String)highestVersion, (String)passport);
                        if (doc != null) {
                            mc.setProperty("request.envelope", (Object)new BIBusEnvelope(doc));
                        }
                    } else {
                        cat.debug("Bridge is not activated");
                    }
                } else {
                    cat.debug("Bridge is not called as docSOAPActionVersion:" + docSOAPActionVersion + " is same as bridge highest version:" + highestVersion);
                }
            } else {
                cat.debug("Passport id missing");
            }
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                cat.debug("No SOAPHeader, biBusHeader, CAM, or CAMPassport element found in soap envelope", (Throwable)e);
            }
            cat.error(err, (Throwable)e);
            throw new PogoException(err + e.getLocalizedMessage());
        }
    }
}

