/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.jsmcommon.util.IMimeHeaderConstants;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;

public class Attachment
implements Serializable,
IMimeHeaderConstants {
    static final long serialVersionUID = 70009003L;
    private String m_contentType;
    private String m_contentId;
    private String m_contentLocation;
    private NCDataSource m_datasource;

    Attachment(String contentType, File file) throws IOException {
        this.m_contentType = contentType;
        this.m_datasource = DataSourceFactory.getDataSource(file, contentType);
    }

    Attachment(String contentType, URL url) throws IOException {
        this.m_contentType = contentType;
        this.m_datasource = DataSourceFactory.getDataSource(url, contentType);
    }

    Attachment(String contentType, byte[] bytes) throws IOException {
        this.m_contentType = contentType;
        this.m_datasource = DataSourceFactory.getDataSource(bytes, contentType);
    }

    Attachment(NCDataSource ds) {
        this.m_contentType = ds.getContentType();
        this.m_datasource = ds;
    }

    public String getContentId() {
        return this.m_contentId;
    }

    public String getContentLocation() {
        return this.m_contentLocation;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public DataHandler getDataHandler() {
        return new DataHandler((DataSource)this.m_datasource);
    }

    public void setContentId(String contentId) {
        this.m_contentId = contentId;
    }

    public void setContentLocation(String contentLocation) {
        this.m_contentLocation = contentLocation;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public void wasSent() {
    }
}

