/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.AttachmentException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.axis.Message;

public class AttachmentFactory {
    public static Attachment getAttachment(DataSource ds) throws AttachmentException {
        try {
            if (ds instanceof FileDataSource) {
                FileDataSource fds = (FileDataSource)ds;
                return new Attachment(fds.getContentType(), fds.getFile());
            }
            if (ds instanceof URLDataSource) {
                URLDataSource urlds = (URLDataSource)ds;
                return new Attachment(urlds.getContentType(), urlds.getURL());
            }
            if (ds instanceof NCDataSource) {
                return new Attachment((NCDataSource)ds);
            }
            throw new AttachmentException(I18NCode.MSG_ATTACHMENT_MANAGER_EXCEPTION);
        }
        catch (IOException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e.getLocalizedMessage());
            throw new AttachmentException(I18NCode.MSG_ATTACHMENT_MANAGER_EXCEPTION);
        }
    }

    public static Attachment[] getAttachments(Message message) throws AttachmentException {
        Iterator attachmentsIter = message.getAttachments();
        ArrayList<Attachment> attachmentsList = new ArrayList<Attachment>();
        while (attachmentsIter.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)attachmentsIter.next();
            try {
                DataSource ds = attachmentPart.getDataHandler().getDataSource();
                Attachment attachment = AttachmentFactory.getAttachment(ds);
                String[] cids = attachmentPart.getMimeHeader("Content-ID");
                if (cids == null || cids.length <= 0) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("No cids found for ");
                    throw new AttachmentException(I18NCode.MSG_READING_ATTACH_ITR, new Object[]{"null"});
                }
                attachment.setContentId(cids[0]);
                String[] locations = attachmentPart.getMimeHeader("Content-Location");
                if (locations != null && locations.length > 0) {
                    attachment.setContentLocation(locations[0]);
                }
                attachmentsList.add(attachment);
                attachmentPart.clearContent();
            }
            catch (SOAPException e) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("SOAP Exception when reading Attachments from the message.");
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e.getLocalizedMessage());
                throw new AttachmentException(I18NCode.MSG_SOAP_ATTACH_ERROR);
            }
        }
        Attachment[] attachments = new Attachment[attachmentsList.size()];
        attachmentsList.toArray(attachments);
        return attachments;
    }
}

