/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.developer.schemas.bibus._3.FaultDetail;
import com.cognos.developer.schemas.bibus._3.FaultDetailMessage;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AxisFaultAdapter {
    private static final String SEVERITY = "severity";
    private static final String ERROR_CODE_STRING = "errorCodeString";
    private static final String ERROR_CODE = "errorCode";
    private static final String MESSAGE = "message";
    private static final String NESTING_LEVEL = "nestingLevel";
    private static final String MESSAGE_STRING = "messageString";
    private static final String TRACE_BACK_MARKER = "Trace back:";
    private AxisFault m_axisFault;
    private FaultDetail m_faultDetail;
    private String[] m_messages = new String[0];

    public AxisFaultAdapter(AxisFault axisFault) {
        this.m_axisFault = axisFault;
        this.extractSDKFaultDetails();
    }

    public QName getFaultCode() {
        return this.m_axisFault.getFaultCode();
    }

    public String getFaultActor() {
        return this.m_axisFault.getFaultActor();
    }

    public String getFaultString() {
        return this.m_axisFault.getFaultString();
    }

    public FaultDetail getFaultDetail() {
        return this.m_faultDetail;
    }

    private void extractSDKFaultDetails() {
        Element[] elements = this.m_axisFault.getFaultDetails();
        if (elements.length == 0) {
            return;
        }
        if (elements.length > 1) {
            // empty if block
        }
        this.m_faultDetail = new FaultDetail();
        ArrayList<FaultDetailMessage> faultMessageList = new ArrayList<FaultDetailMessage>();
        NodeList childNodes = elements[0].getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i) instanceof Element) {
                String localName;
                String string = localName = childNodes.item(i) != null ? childNodes.item(i).getLocalName() : "unknown";
                if (SEVERITY.equals(localName)) {
                    this.m_faultDetail.setSeverity(childNodes.item(i).getFirstChild().getNodeValue());
                    continue;
                }
                if (ERROR_CODE_STRING.equals(localName) || ERROR_CODE.equals(localName)) {
                    this.m_faultDetail.setErrorCode(childNodes.item(i).getFirstChild().getNodeValue());
                    continue;
                }
                if (!MESSAGE.equals(localName)) continue;
                FaultDetailMessage fdm = new FaultDetailMessage();
                faultMessageList.add(fdm);
                NodeList messageNodes = childNodes.item(i).getChildNodes();
                for (int j = 0; j < messageNodes.getLength(); ++j) {
                    String text;
                    String messageLocalName = messageNodes.item(j).getLocalName();
                    Node childNode = messageNodes.item(j).getFirstChild();
                    if (null != childNode) {
                        if (NESTING_LEVEL.equals(messageLocalName)) {
                            String nestLevString = childNode.getNodeValue();
                            try {
                                int nestingLevel = Integer.parseInt(nestLevString);
                                fdm.setNestingLevel(nestingLevel);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (MESSAGE_STRING.equals(messageLocalName)) {
                            String messageString = childNode.getNodeValue();
                            fdm.setMessage(messageString);
                        }
                    }
                    if (messageLocalName != null || !TRACE_BACK_MARKER.equals(text = messageNodes.item(j).getNodeValue())) continue;
                    fdm.setMessage(text);
                }
                continue;
            }
            if (!(childNodes.item(i) instanceof Text)) continue;
            FaultDetailMessage fdm = new FaultDetailMessage();
            faultMessageList.add(fdm);
            String text = childNodes.item(i).getNodeValue();
            fdm.setMessage(text);
            fdm.setNestingLevel(1);
        }
        FaultDetailMessage[] fdmArray = new FaultDetailMessage[faultMessageList.size()];
        faultMessageList.toArray(fdmArray);
        this.m_faultDetail.setMessage(fdmArray);
    }
}

