/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BatchReportService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.DeliveryService_PortType;
import com.cognos.developer.schemas.bibus._3.Dispatcher_PortType;
import com.cognos.developer.schemas.bibus._3.EventManagementService_PortType;
import com.cognos.developer.schemas.bibus._3.MonitorService_PortType;
import com.cognos.developer.schemas.bibus._3.SaCAMService_PortType;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ClientPortCache;
import com.cognos.jsmcommon.soap.client.IClient;
import com.cognos.jsmcommon.soap.client.SDSAxisEngineConfigurationFactory;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientStub;
import com.cognos.jsmcommon.soap.client.ports.ClientBase;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientStub;
import com.cognos.jsmcommon.soap.client.ports.DeliveryServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.DeliveryServiceClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.DeliveryServiceClientStub;
import com.cognos.jsmcommon.soap.client.ports.DispatcherClientPort;
import com.cognos.jsmcommon.soap.client.ports.DispatcherClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.DispatcherClientStub;
import com.cognos.jsmcommon.soap.client.ports.EventManagementClientStub;
import com.cognos.jsmcommon.soap.client.ports.EventManagementServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.EventManagementServiceClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientStub;
import com.cognos.jsmcommon.soap.client.ports.SaCAMServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.SaCAMServiceClientPortImpl;
import com.cognos.jsmcommon.soap.client.ports.SaCAMServiceClientStub;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPIImpl;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPIStubWrapper;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.soap.util.ServiceMetadata;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.Service;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.utils.XMLUtils;

public class ClientImpl
implements IClient {
    public static final int DISPATCHER_ENDPOINT = 0;
    public static final int CONTENT_MANAGER_ENDPOINT = 1;
    private static org.apache.axis.client.Service m_service;
    private static Map<String, ClientPortCache> m_portCaches;
    private static Map<String, ClientPortCache> m_serviceAPIportCaches;
    private static ServiceMetadata m_serviceMetadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientImpl() {
        EngineConfigurationFactory factory = EngineConfigurationFactoryFinder.newFactory((Object)"sds");
        EngineConfiguration config = factory.getClientEngineConfig();
        Class<AxisServiceHandler> clazz = AxisServiceHandler.class;
        synchronized (AxisServiceHandler.class) {
            m_service = new org.apache.axis.client.Service(config);
            TypeMappingRegistry tmr = m_service.getTypeMappingRegistry();
            this.addServiceTypeMappings(tmr);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public org.apache.axis.client.Service getService() {
        return m_service;
    }

    @Override
    public List<String> getSessionAffinityServices() {
        return m_serviceMetadata.getSessionAffinityServices();
    }

    @Override
    public synchronized ContentManagerServiceClientPort getContentManagerServiceClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(1);
        ClientPortCache cmPortCache = m_portCaches.get("contentManagerService");
        if (cmPortCache == null) {
            cmPortCache = new ClientPortCache(m_service, "contentManagerService", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new ContentManagerServiceClientStub((Service)m_service);
                }
            });
            m_portCaches.put("contentManagerService", cmPortCache);
        }
        ContentManagerService_PortType cmPort = (ContentManagerService_PortType)cmPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        ContentManagerServiceClientPortImpl clientPort = new ContentManagerServiceClientPortImpl(headers, cmPort);
        return clientPort;
    }

    @Override
    public synchronized SaCAMServiceClientPort getSaCAMServiceClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(0);
        ClientPortCache saCAMPortCache = m_portCaches.get("SACamSrvc");
        if (saCAMPortCache == null) {
            saCAMPortCache = new ClientPortCache(m_service, "SACamSrvc", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new SaCAMServiceClientStub((Service)m_service);
                }
            });
            m_portCaches.put("SACamSrvc", saCAMPortCache);
        }
        SaCAMService_PortType saCAMPort = (SaCAMService_PortType)saCAMPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        SaCAMServiceClientPortImpl clientPort = new SaCAMServiceClientPortImpl(headers, saCAMPort);
        return clientPort;
    }

    @Override
    public synchronized BatchReportServiceClientPort getBatchReportServiceClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(0);
        ClientPortCache brsPortCache = m_portCaches.get("batchReportService");
        if (brsPortCache == null) {
            brsPortCache = new ClientPortCache(m_service, "batchReportService", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new BatchReportServiceClientStub((Service)m_service);
                }
            });
            m_portCaches.put("batchReportService", brsPortCache);
        }
        BatchReportService_PortType brsPort = (BatchReportService_PortType)brsPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        BatchReportServiceClientPortImpl clientPort = new BatchReportServiceClientPortImpl(headers, brsPort);
        return clientPort;
    }

    @Override
    public synchronized EventManagementServiceClientPort getEventmanagementServiceClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(0);
        ClientPortCache emsPortCache = m_portCaches.get("eventManagementService");
        if (emsPortCache == null) {
            emsPortCache = new ClientPortCache(m_service, "eventManagementService", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new EventManagementClientStub((Service)m_service);
                }
            });
            m_portCaches.put("eventManagementService", emsPortCache);
        }
        EventManagementService_PortType emsPort = (EventManagementService_PortType)emsPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        EventManagementServiceClientPortImpl clientPort = new EventManagementServiceClientPortImpl(headers, emsPort);
        return clientPort;
    }

    @Override
    public synchronized MonitorServiceClientPort getMonitorServiceClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(0);
        ClientPortCache monitorPortCache = m_portCaches.get("monitorService");
        if (monitorPortCache == null) {
            monitorPortCache = new ClientPortCache(m_service, "monitorService", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new MonitorServiceClientStub((Service)m_service);
                }
            });
            m_portCaches.put("monitorService", monitorPortCache);
        }
        MonitorService_PortType monitorPort = (MonitorService_PortType)monitorPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        MonitorServiceClientPortImpl clientPort = new MonitorServiceClientPortImpl(headers, monitorPort);
        return clientPort;
    }

    @Override
    public synchronized DeliveryServiceClientPort getDeliveryServiceClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(0);
        ClientPortCache deliveryPortCache = m_portCaches.get("deliveryService");
        if (deliveryPortCache == null) {
            deliveryPortCache = new ClientPortCache(m_service, "deliveryService", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new DeliveryServiceClientStub((Service)m_service);
                }
            });
            m_portCaches.put("deliveryService", deliveryPortCache);
        }
        DeliveryService_PortType deliveryPort = (DeliveryService_PortType)deliveryPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        DeliveryServiceClientPortImpl clientPort = new DeliveryServiceClientPortImpl(headers, deliveryPort);
        return clientPort;
    }

    @Override
    public synchronized DispatcherClientPort getDispatcherClient(JobBiBusHeaders headers) {
        String endpoint = this.getEndpointString(0);
        ClientPortCache dispatcherPortCache = m_portCaches.get("dispatcher");
        if (dispatcherPortCache == null) {
            dispatcherPortCache = new ClientPortCache(m_service, "dispatcher", new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    return new DispatcherClientStub((Service)m_service);
                }
            });
            m_portCaches.put("dispatcher", dispatcherPortCache);
        }
        Dispatcher_PortType dispatcherPort = (Dispatcher_PortType)dispatcherPortCache.getPortStub(headers.getBiBusHeader(), endpoint);
        DispatcherClientPortImpl clientPort = new DispatcherClientPortImpl(headers, dispatcherPort);
        return clientPort;
    }

    @Override
    public synchronized ServiceAPI getServiceAPI(JobBiBusHeaders headers, BaseClass baseClass) throws SDSServiceException {
        String serviceName = m_serviceMetadata.getServiceName(baseClass);
        ServiceAPI service = null;
        try {
            service = this.getServiceAPI(headers, serviceName);
        }
        catch (SDSServiceException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
            throw new SDSServiceException(I18NCode.SSV_INVALID_BASE_CLASS, (Object[])new String[]{baseClass.getSearchPath().getValue()}, e);
        }
        return service;
    }

    @Override
    public synchronized ServiceAPI getServiceAPI(JobBiBusHeaders headers, Client.ServiceEnum senum) {
        ServiceAPI service = null;
        try {
            service = this.getServiceAPI(headers, senum.toString());
        }
        catch (SDSServiceException sDSServiceException) {
            // empty catch block
        }
        return service;
    }

    @Override
    public synchronized ServiceAPI getServiceAPI(JobBiBusHeaders headers, final String serviceName) throws SDSServiceException {
        String endpoint = this.getEndpointString(0);
        ClientPortCache portCache = m_serviceAPIportCaches.get(serviceName);
        if (portCache == null) {
            portCache = new ClientPortCache(m_service, serviceName, new ClientPortCache.PortFactory(){

                @Override
                public Stub createPort(org.apache.axis.client.Service service) throws AxisFault {
                    Stub stub = null;
                    try {
                        String stubClassString = m_serviceMetadata.getStubImplClass(serviceName);
                        Class<?> stubClass = Class.forName(stubClassString);
                        Constructor<?> stubClassConstructor = stubClass.getConstructor(Service.class);
                        stub = (Stub)stubClassConstructor.newInstance(m_service);
                        ServiceAPIStubWrapper serviceImpl = new ServiceAPIStubWrapper(stub);
                        return serviceImpl;
                    }
                    catch (InvocationTargetException e) {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
                        if (e.getTargetException() instanceof AxisFault) {
                            throw (AxisFault)e.getTargetException();
                        }
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
                        throw new RuntimeException(e);
                    }
                }
            });
            m_serviceAPIportCaches.put(serviceName, portCache);
        }
        Stub stub = portCache.getPortStub(headers.getBiBusHeader(), endpoint);
        ServiceAPIImpl service = new ServiceAPIImpl(headers, stub);
        return service;
    }

    @Override
    public synchronized ServiceAPI getServiceAPI(JobBiBusHeaders headers, AsynchSpecification specification) throws SDSServiceException {
        String serviceName = m_serviceMetadata.getServiceName(specification);
        ServiceAPI service = null;
        try {
            service = this.getServiceAPI(headers, serviceName);
        }
        catch (SDSServiceException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
            throw new SDSServiceException(I18NCode.SSV_INVALID_ASYNC_SPEC, new Object[]{specification}, e);
        }
        return service;
    }

    @Override
    public String getEndpointString(int targetType) {
        try {
            switch (targetType) {
                case 0: {
                    return CRNProperties.getInstance().getProperty("internalDispatcher");
                }
                case 1: {
                    return CMProperties.getInstance().getProperty("contentManager");
                }
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
            return "";
        }
        return "";
    }

    @Override
    public synchronized void releasePort(ClientBase port) {
        if (port != null) {
            String portName = port.getPortName();
            Stub binding = port.getBinding();
            ClientPortCache cache = null;
            cache = binding instanceof ServiceAPIStubWrapper ? m_serviceAPIportCaches.get(portName) : m_portCaches.get(portName);
            if (cache != null) {
                cache.releasePort(port.getBinding());
            }
        }
    }

    @Override
    public String getServiceName(BaseClass baseClass) {
        String serviceName = null;
        try {
            serviceName = m_serviceMetadata.getServiceName(baseClass);
        }
        catch (SDSServiceException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("A service could not be found for baseClass: " + baseClass);
        }
        return serviceName;
    }

    @Override
    public String getServiceName(AsynchSpecification spec) {
        String serviceName = null;
        try {
            serviceName = m_serviceMetadata.getServiceName(spec);
        }
        catch (SDSServiceException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("A service could not be found for specfication: " + spec.getClass().getName());
        }
        return serviceName;
    }

    private void addServiceTypeMappings(TypeMappingRegistry tmr) {
        EngineConfigurationFactory factory = EngineConfigurationFactoryFinder.newFactory((Object)"sds");
        InputStream stream = null;
        try {
            WSDDDocument doc;
            WSDDDeployment deployment;
            WSDDService[] wsdds;
            if (factory instanceof SDSAxisEngineConfigurationFactory) {
                stream = ((SDSAxisEngineConfigurationFactory)factory).getServerEngineConfigAsStream();
            }
            if ((wsdds = (deployment = (doc = new WSDDDocument(XMLUtils.newDocument((InputStream)stream))).getDeployment()).getServices()) != null && wsdds.length > 0) {
                org.apache.axis.encoding.TypeMapping tm = wsdds[0].getTypeMapping(Constants.URI_DEFAULT_SOAP_ENC);
                tmr.register(Constants.URI_DEFAULT_SOAP_ENC, (TypeMapping)tm);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
    }

    static {
        m_portCaches = new HashMap<String, ClientPortCache>();
        m_serviceAPIportCaches = new HashMap<String, ClientPortCache>();
        m_serviceMetadata = new ServiceMetadata();
    }

    public static class ServiceEnum {
        public static final ServiceEnum AGENT_SERVICE = new ServiceEnum("agentService");
        public static final ServiceEnum BATCH_REPORT = new ServiceEnum("batchReportService");
        public static final ServiceEnum CM_SERVICE = new ServiceEnum("contentManagerService");
        public static final ServiceEnum SACAM_SERVICE = new ServiceEnum("SACamSrvc");
        public static final ServiceEnum DELIVERY_SERVICE = new ServiceEnum("deliveryService");
        public static final ServiceEnum DISPATCHER_SERVICE = new ServiceEnum("dispatcher");
        public static final ServiceEnum EVENT_MANAGEMENT_SERVICE = new ServiceEnum("eventManagementService");
        public static final ServiceEnum JOB_SERVICE = new ServiceEnum("jobService");
        public static final ServiceEnum MONITOR_SERVICE = new ServiceEnum("monitorService");
        public static final ServiceEnum REPORT_SERVICE = new ServiceEnum("reportService");
        public static final ServiceEnum DATA_INTEGRATION_SERVICE = new ServiceEnum("dataIntegrationService");
        public static final ServiceEnum PLANNING_TASK_SERVICE = new ServiceEnum("planningTaskService");
        public static final ServiceEnum PLANNING_RUNTIME_SERVICE = new ServiceEnum("planningRuntimeService");
        public static final ServiceEnum PLANNING_ADMIN_CONSOLE_SERVICE = new ServiceEnum("planningAdministrationConsoleService");
        public static final ServiceEnum INDEX_DATA_SERVICE = new ServiceEnum("indexDataService");
        public static final ServiceEnum INDEX_SEARCH_SERVICE = new ServiceEnum("indexSearchService");
        public static final ServiceEnum INDEX_UPDATE_SERVICE = new ServiceEnum("indexUpdateService");
        public static final ServiceEnum DATA_MOVEMENT_SERVICE = new ServiceEnum("dataMovementService");
        public static final ServiceEnum MIGRATION_SERVICE = new ServiceEnum("migrationService");
        public static final ServiceEnum POWERPLAY_SERVICE = new ServiceEnum("powerPlayService");
        public static final ServiceEnum REST_BRIDGE_SERVICE = new ServiceEnum("restBridgeService");
        private String m_serviceName;

        private ServiceEnum(String serviceName) {
            this.m_serviceName = serviceName;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ServiceEnum) {
                return ((ServiceEnum)obj).m_serviceName.equals(this.m_serviceName);
            }
            return false;
        }

        public int hashCode() {
            return this.m_serviceName.hashCode();
        }

        public String toString() {
            return this.m_serviceName;
        }
    }
}

