/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.client.ITypeMappingLoader;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class ClientPortCache {
    private static final int CACHE_INCREMENT = 5;
    private Service m_service;
    private int m_currentCacheMax = 5;
    private int m_cachedPorts = 0;
    private List m_cache;
    private String m_serviceName;
    private PortFactory m_portFactory;
    private int AXIS_TIMEOUT_DEFAULT = 0;

    public ClientPortCache(Service service, String serviceName, PortFactory portFactory) {
        this.m_service = service;
        this.m_serviceName = serviceName;
        this.m_portFactory = portFactory;
        this.m_cache = new ArrayList();
    }

    public synchronized Stub getPortStub(BiBusHeader header, String portAddress) {
        if (this.m_cache.size() == 0) {
            if (this.m_cachedPorts == this.m_currentCacheMax) {
                this.m_currentCacheMax += 5;
                String s = this.m_serviceName + " : incrementing client port cache to " + this.m_currentCacheMax;
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(s);
            }
            if (this.m_cachedPorts < this.m_currentCacheMax) {
                this.m_cache.add(this.createPort());
                ++this.m_cachedPorts;
            }
        }
        Stub stub = (Stub)this.m_cache.remove(0);
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)portAddress);
        AxisUtils.setHeader(stub, header);
        return stub;
    }

    public synchronized void releasePort(Stub stub) {
        stub.clearAttachments();
        stub.clearHeaders();
        this.m_cache.add(stub);
    }

    private Stub createPort() {
        Stub stub = null;
        try {
            stub = this.m_portFactory.createPort(this.m_service);
            stub.setPortName(this.m_serviceName);
            stub.setTimeout(this.getAxisTimeout());
            if (stub instanceof ITypeMappingLoader) {
                ((ITypeMappingLoader)stub).disableLoadTypeMapping();
            } else {
                String msg = "ClientPortCache.createPort() stub type [" + stub.getClass().getName() + "] does not implement ITypeMappingLoader. " + "Stub loading of typemappings will not be disabled";
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(msg);
            }
        }
        catch (AxisFault ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(ex);
        }
        return stub;
    }

    private int getAxisTimeout() {
        int timeout = this.AXIS_TIMEOUT_DEFAULT;
        try {
            String tmpStr = CRNProperties.getInstance().getProperty("axis.timeout");
            if (tmpStr != null && tmpStr.trim().length() > 0) {
                timeout = Integer.valueOf(tmpStr);
            }
        }
        catch (PropertiesException e) {
            timeout = this.AXIS_TIMEOUT_DEFAULT;
        }
        return timeout;
    }

    public static interface PortFactory {
        public Stub createPort(Service var1) throws AxisFault;
    }
}

