/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDKClientException
extends LocalizableException {
    private Exception m_remote;

    public SDKClientException(Exception e, Message message) {
        super(I18NCode.GEN_3RD_PARTY_FAULT, new Object[]{e.getMessage()});
        this.m_remote = e;
    }

    public SDKClientException(Exception e) {
        super(I18NCode.GEN_3RD_PARTY_FAULT, new Object[]{e.getMessage()}, e);
        this.m_remote = e;
    }

    @Override
    public String getMessage() {
        String message = null;
        message = this.m_remote instanceof AxisFault ? this.getAxisFaultMessage((AxisFault)((Object)this.m_remote)) : this.m_remote.getMessage();
        return message;
    }

    public String[] getMessages() {
        String[] messages = null;
        messages = this.m_remote instanceof AxisFault ? this.getAxisFaultMessages((AxisFault)((Object)this.m_remote)) : new String[]{this.m_remote.getMessage()};
        return messages;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getMessage();
    }

    public QName getFaultCode() {
        if (this.m_remote instanceof AxisFault) {
            return ((AxisFault)((Object)this.m_remote)).getFaultCode();
        }
        return null;
    }

    public String getFaultString() {
        if (this.m_remote instanceof AxisFault) {
            return ((AxisFault)((Object)this.m_remote)).getFaultString();
        }
        return null;
    }

    private String getAxisFaultMessage(AxisFault axisFault) {
        String[] messages = this.getAxisFaultMessages(axisFault);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < messages.length; ++i) {
            if (i != 0) {
                buffer.append(" ");
            }
            buffer.append(messages[i]);
        }
        return buffer.toString();
    }

    private String[] getAxisFaultMessages(AxisFault axisFault) {
        ArrayList<String> faults = new ArrayList<String>();
        Element[] details = axisFault.getFaultDetails();
        if (details == null || details.length == 0 || details[0].getChildNodes() == null) {
            return new String[]{axisFault.getFaultString()};
        }
        NodeList nodeList = details[0].getChildNodes();
        Element msgNode = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getLocalName().equals("message")) {
                msgNode = details[0];
                break;
            }
            if (!node.getLocalName().equals("exception")) continue;
            msgNode = (Element)node;
            break;
        }
        if (msgNode == null) {
            return new String[]{axisFault.getFaultString()};
        }
        nodeList = msgNode.getElementsByTagNameNS("*", "message");
        int ignoreNestLevel = -1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            NodeList messageChildren = node.getChildNodes();
            String msg = null;
            int nestLevel = 0;
            boolean firstMessage = true;
            for (int j = 0; j < messageChildren.getLength(); ++j) {
                Node child = messageChildren.item(j);
                if (!(child instanceof Element) || child.getFirstChild() == null) continue;
                if (child.getLocalName().equals("messageString")) {
                    msg = child.getFirstChild().getNodeValue();
                    continue;
                }
                if (!child.getLocalName().equals("nestingLevel")) continue;
                try {
                    nestLevel = Integer.parseInt(child.getFirstChild().getNodeValue());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (nestLevel <= ignoreNestLevel || msg == null) continue;
            if (msg.startsWith("RSV-SRV") && msg.indexOf("Trace") != -1) {
                ignoreNestLevel = 1;
                continue;
            }
            if (msg.indexOf("CCL_CAUGHT:") != -1) {
                ignoreNestLevel = 1;
                if (faults.size() < 2 || ((String)faults.get(faults.size() - 1)).indexOf("RSV-SRV") == -1) continue;
                faults.remove(1);
                continue;
            }
            if (firstMessage) {
                firstMessage = false;
            }
            faults.add(msg);
        }
        String[] faultstrings = null;
        faultstrings = faults != null && faults.size() > 0 ? faults.toArray(new String[faults.size()]) : new String[]{axisFault.getFaultString()};
        return faultstrings;
    }
}

