/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class SetSoapActionHandler
extends BasicHandler {
    private static ThreadLocal currentSoapActionURI = new ThreadLocal();
    private static ThreadLocal currentSoapActionAffinity = new ThreadLocal();
    public static String SERVER_AFFINITY = "server";
    public static String SESSION_AFFINITY = "session";
    public static String NONE = "";
    private static final String PLANNING = "planning";
    private static final String PACS = "planningAdministrationConsoleService";
    private static final String PDS = "planningDataService";
    private static final String PRTS = "planningRuntimeService";
    private static final String PTS = "planningTaskService";
    private static final String prefix = "http://developer.cognos.com/schemas/";
    private static final String suffix = "/1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            this.fixUpSoapActionForPlanning(msgContext);
            String soapActionURI = (String)currentSoapActionURI.get();
            String soapActionAffinity = (String)currentSoapActionAffinity.get();
            if (soapActionURI != null) {
                msgContext.setSOAPActionURI(soapActionURI);
            } else if (soapActionAffinity != null) {
                String currentSoapyAction = msgContext.getSOAPActionURI();
                int dotIndex = -1;
                dotIndex = currentSoapyAction.lastIndexOf(".");
                if (dotIndex != -1) {
                    currentSoapyAction = currentSoapyAction.substring(0, dotIndex);
                }
                currentSoapyAction = !"".equals(soapActionAffinity) ? currentSoapyAction + "." + soapActionAffinity : currentSoapyAction + soapActionAffinity;
                msgContext.setSOAPActionURI(currentSoapyAction);
            }
        }
        finally {
            SetSoapActionHandler.setSoapActionURI(null);
            SetSoapActionHandler.setSoapActionAffinity(null);
        }
    }

    public static void setSoapActionURI(String uri) {
        currentSoapActionURI.set(uri);
    }

    public static void setSoapActionAffinity(String affinity) {
        currentSoapActionAffinity.set(affinity);
    }

    public void fixUpSoapActionForPlanning(MessageContext msgContext) {
        String currentSoapAction = msgContext.getSOAPActionURI();
        if (!currentSoapAction.contains(PLANNING)) {
            return;
        }
        if (currentSoapAction.contains(PACS)) {
            String updatedSoapAction = this.fixUpSoapActionForPlanning(currentSoapAction, PACS);
            msgContext.setSOAPActionURI(updatedSoapAction);
        } else if (currentSoapAction.contains(PDS)) {
            String updatedSoapAction = this.fixUpSoapActionForPlanning(currentSoapAction, PDS);
            msgContext.setSOAPActionURI(updatedSoapAction);
        } else if (currentSoapAction.contains(PRTS)) {
            String updatedSoapAction = this.fixUpSoapActionForPlanning(currentSoapAction, PRTS);
            msgContext.setSOAPActionURI(updatedSoapAction);
        } else if (currentSoapAction.contains(PTS)) {
            String updatedSoapAction = this.fixUpSoapActionForPlanning(currentSoapAction, PTS);
            msgContext.setSOAPActionURI(updatedSoapAction);
        }
    }

    String fixUpSoapActionForPlanning(String soapAction, String planningService) {
        String[] parts = soapAction.split(planningService);
        String newSoapAction = prefix + planningService + suffix;
        if (parts[1].lastIndexOf(".") != -1) {
            newSoapAction = newSoapAction + parts[1].substring(parts[1].lastIndexOf("."), parts[1].length());
        }
        return newSoapAction;
    }
}

