/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.jsmcommon.util.ConnectionPool;
import com.cognos.jsmcommon.util.TrustedSession;
import java.io.ByteArrayInputStream;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class TrustedRequestAxisHandler
extends BasicHandler {
    private static ThreadLocal m_signRequestLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        block7: {
            try {
                String serviceId = (String)m_signRequestLocal.get();
                if (serviceId == null || serviceId.length() == 0) break block7;
                Message msg = msgContext.getRequestMessage();
                byte[] rawBytes = msg.getSOAPPartAsBytes();
                try {
                    byte[] signedBytes = this.sign(serviceId, rawBytes);
                    ByteArrayInputStream bais = new ByteArrayInputStream(signedBytes);
                    msg.getSOAPPart().setContent((Source)new StreamSource(bais));
                }
                catch (CAMCryptoException ex) {
                    String message = ex.getMessage();
                    String error = "CAM-CRP-1126";
                    if (message.startsWith(error)) {
                        break block7;
                    }
                    throw AxisFault.makeFault((Exception)((Object)ex));
                }
                catch (SOAPException ex) {
                    throw AxisFault.makeFault((Exception)((Object)ex));
                }
            }
            finally {
                TrustedRequestAxisHandler.signRequest(null);
            }
        }
    }

    public static void signRequest(String serviceId) {
        m_signRequestLocal.set(serviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sign(String serviceId, byte[] bytes) throws CAMCryptoException {
        TrustedSession session = ConnectionPool.getInstance().getSession();
        byte[] signedBytes = null;
        try {
            TrustedRequestSession trusted = session.getTrustedRequestSession();
            signedBytes = trusted.setMessageTrust(serviceId, bytes);
        }
        finally {
            session.release();
        }
        return signedBytes;
    }
}

