/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client.ports;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMException;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.SetSoapActionHandler;
import com.cognos.jsmcommon.soap.client.TrustedRequestAxisHandler;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.client.ports.PortMethod;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;

public abstract class ClientBase
implements IClientBase {
    private JobBiBusHeaders m_headers;
    private Stub m_stubBinding;
    private SDSCategory m_auditLogCategory;
    private String m_signServiceId = null;
    private String m_soapAction = null;
    private String m_soapActionAffinity = null;
    private boolean m_userRequired = true;
    private boolean m_doReconnect = false;
    private static final int DEFAULT_POLL_INTERVAL = 30;
    protected static final int MAX_POLL_INTERVAL = 1800;
    private int m_endpointType = -1;
    private List m_formFieldVars = null;
    private static final QName m_bus_qname = new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
    private static int DEFAULT_SLEEP_BETWEEN_RETRIES_IN_MS = 30000;
    private int sleepBetweenRetries = DEFAULT_SLEEP_BETWEEN_RETRIES_IN_MS;
    private static Stack<Exception> stacks = new Stack();
    private static boolean findLeaks = false;

    protected ClientBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBase(JobBiBusHeaders headers, Stub binding) {
        if (findLeaks) {
            Stack<Exception> stack = stacks;
            synchronized (stack) {
                if (stacks.size() % 20 == 0 && stacks.size() > 20) {
                    for (Exception ex : stacks) {
                        ex.printStackTrace();
                    }
                }
                stacks.push(new Exception(this.getClass().getName()));
            }
        }
        this.m_headers = headers;
        this.m_stubBinding = binding;
        this.m_auditLogCategory = JSMCommonCategory.RUNTIME;
    }

    @Override
    public void setAttachments(Attachment[] attachments) {
        for (int i = 0; i < attachments.length; ++i) {
            this.m_stubBinding.addAttachment((Object)attachments[i].getDataHandler());
        }
    }

    @Override
    public void setBiBusHeader(BiBusHeader header) {
        this.m_headers.setBiBusHeader(header);
        AxisUtils.setHeader(this.m_stubBinding, header);
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        BiBusHeader obj = null;
        if (this.m_stubBinding == null) {
            return null;
        }
        try {
            obj = AxisUtils.getHeader(this.m_stubBinding);
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        return obj;
    }

    @Override
    public JobBiBusHeaders getJobBiBusHeaders() {
        return this.m_headers;
    }

    @Override
    public Message getResponseMessage() {
        Message responseMessage = null;
        if (this.m_stubBinding._getCall() == null) {
            MessageContext msgContext = MessageContext.getCurrentContext();
            if (msgContext != null) {
                responseMessage = msgContext.getResponseMessage();
            }
        } else {
            responseMessage = this.m_stubBinding._getCall().getResponseMessage();
        }
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPEnvelope getResponseEnvelope() {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "ENTER");
        SOAPEnvelope env = null;
        try {
            Message response = this.getResponseMessage();
            if (response != null) {
                env = response.getSOAPEnvelope();
            }
        }
        catch (AxisFault e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        catch (NullPointerException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
        }
        finally {
            perf.stop();
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPBodyElement getResponseBody() {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "ENTER");
        SOAPBodyElement body = null;
        try {
            Vector bodies;
            SOAPEnvelope env = this.getResponseEnvelope();
            if (env != null && (bodies = env.getBodyElements()) != null && bodies.size() >= 1) {
                body = (SOAPBodyElement)bodies.get(0);
            }
        }
        catch (AxisFault e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        finally {
            perf.stop();
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPHeaderElement getResponseHeader() {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "ENTER");
        SOAPHeaderElement header = null;
        try {
            Vector headers;
            SOAPEnvelope env = this.getResponseEnvelope();
            if (env != null && (headers = env.getHeaders()) != null && headers.size() >= 1) {
                header = (SOAPHeaderElement)headers.get(0);
            }
        }
        catch (AxisFault e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
        }
        finally {
            perf.stop();
        }
        return header;
    }

    @Override
    public Stub getBinding() {
        return this.m_stubBinding;
    }

    void setBinding(Stub binding) {
        this.m_stubBinding = binding;
    }

    @Override
    public void addAttachment(Object handler) {
        this.m_stubBinding.addAttachment(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        try {
            Client.instance().releasePort(this);
            this.m_signServiceId = null;
            this.m_endpointType = -1;
            this.m_doReconnect = false;
            this.setBinding(null);
            this.m_auditLogCategory = JSMCommonCategory.RUNTIME;
            if (this.getJobBiBusHeaders() != null) {
                BiBusUtilities.removeConversationContext(this.getJobBiBusHeaders().getBiBusHeader());
            }
            BiBusUtilities.removeConversationContext(this.getBiBusHeader());
        }
        finally {
            perf.stop();
            if (findLeaks) {
                Stack<Exception> stack = stacks;
                synchronized (stack) {
                    stacks.pop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(PortMethod portMethod) throws SDKClientException, EMFSecurityException {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "CALL");
        Object returnObject = null;
        boolean logonRetryDone = false;
        boolean trustedRequestWithoutCAMDone = false;
        boolean retry = false;
        int bindRetry = 4;
        try {
            do {
                try {
                    this.callPreProcessing();
                    String axisTimeout = CRNProperties.getInstance().getProperty("axis.timeout");
                    AxisProperties.setProperty((String)"axis.http.client.connection.pool.timeout", (String)axisTimeout);
                    returnObject = portMethod.execute();
                    retry = false;
                }
                catch (PropertiesException axisTimeout) {
                }
                catch (NullPointerException e) {
                    throw new SDKClientException(e);
                }
                catch (RemoteException e) {
                    this.debugLog(this, ", ", this.getClass().getName(), " -- RemoteException: ", e);
                    boolean isNoProcessAvailableResponse = false;
                    try {
                        Message message = this.getResponseMessage();
                        String soap = message.getSOAPPartAsString();
                        isNoProcessAvailableResponse = soap != null && soap.contains("DPR-ERR-2002");
                        this.debugLog("[RemoteException] ClientBase.execute(PortMethod) : ResponseMessage is: ", soap);
                    }
                    catch (AxisFault e2) {
                        this.debugLog("Error when attempting to get the SOAP response message after catching RemoteException in ClientBase.execute(PortMethod). ", e2.getMessage());
                    }
                    catch (Throwable e2) {
                        this.debugLog("Throwable Error when attempting to get the SOAP response message after catching RemoteException in ClientBase.execute(PortMethod). ", e2.getMessage());
                    }
                    CAM cam = this.m_headers.getBiBusHeader().getCAM();
                    Throwable cause = e.getCause();
                    boolean serviceDown = false;
                    if (this.isReconnecting()) {
                        serviceDown = this.isServiceDown(e);
                        this.log("[RemoteException] Reconnecting Service Port - target service [" + this.getBinding()._getProperty("javax.xml.rpc.service.endpoint.address") + "] 'isDown' value is " + serviceDown);
                    }
                    if (serviceDown) {
                        this.waitOnService();
                        retry = this.isReconnecting();
                    } else if (cause != null && cause instanceof BindException && bindRetry != 0) {
                        int sleepTime = 5000;
                        bindRetry = (short)(bindRetry - 1);
                        try {
                            this.log("BindException occured, no socket is available. Waiting " + sleepTime + " seconds for a socket");
                            Thread.sleep(5000L);
                            retry = true;
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (e.toString().contains("SAXParseException") && bindRetry >= 0) {
                        int sleepTime = 3000;
                        bindRetry = (short)(bindRetry - 1);
                        try {
                            int attemptNumber = 4 - bindRetry;
                            this.log("SAXParseException occurred, retrying with attempt number = " + attemptNumber);
                            Thread.sleep(sleepTime);
                            retry = true;
                        }
                        catch (InterruptedException attemptNumber) {}
                    } else if (this.logonRequired(e)) {
                        if (!this.m_userRequired) {
                            if (!trustedRequestWithoutCAMDone) {
                                String msg = "Removing invalidated CAM element from trusted request header";
                                this.getLogger().debug(msg);
                                trustedRequestWithoutCAMDone = true;
                                this.getBiBusHeader().setCAM(null);
                                retry = true;
                            } else {
                                retry = false;
                            }
                        } else if (cam != null && this.m_headers.getCamCredential() != null && (cam.getAction() == null || cam.getAction().equals(""))) {
                            if (!logonRetryDone) {
                                logonRetryDone = true;
                                this.renewLogon();
                                retry = true;
                            } else {
                                retry = false;
                            }
                        } else {
                            retry = false;
                        }
                    } else {
                        retry = false;
                    }
                    if (isNoProcessAvailableResponse) {
                        this.debugLog("Received no processes available response. Will retry a little later.");
                        this.sleepBeforeRetrying();
                        this.debugLog("Woke up. Retrying now.");
                        retry = true;
                    }
                    if (!retry) {
                        try {
                            if (this.logonRequired(e)) {
                                Message message = this.getResponseMessage();
                                String wholeEnv = message.getSOAPPartAsString();
                                this.log("Error when authenticating; response envelope is " + wholeEnv);
                                ByteArrayInputStream bais = new ByteArrayInputStream(message.getSOAPPartAsBytes());
                                BIBusEnvelope env = new BIBusEnvelope((InputStream)bais);
                                throw new EMFSecurityException(env, e);
                            }
                            throw new SDKClientException(e);
                        }
                        catch (AxisFault e1) {
                            throw new SDKClientException(e);
                        }
                        catch (SOAPException e1) {
                            throw new SDKClientException(e);
                        }
                    }
                    this.debugLog("Done handling remote exception. Will ", retry ? "retry." : "not retry.");
                }
            } while (retry);
        }
        finally {
            this.callPostProcessing();
            perf.stop();
        }
        return returnObject;
    }

    protected void sleepBeforeRetrying() {
        try {
            Thread.sleep(this.sleepBetweenRetries);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected boolean logonRequired(RemoteException e) {
        boolean retValue = false;
        if (e instanceof AxisFault) {
            AxisFault fault = (AxisFault)((Object)e);
            ArrayList headers = fault.getHeaders();
            if (headers != null) {
                Iterator headIter = headers.iterator();
                while (headIter.hasNext() && !retValue) {
                    SOAPHeaderElement element = (SOAPHeaderElement)headIter.next();
                    BiBusHeader busHeader = null;
                    try {
                        busHeader = (BiBusHeader)element.getValueAsType(m_bus_qname);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    retValue = this.isCAMRecovorable(busHeader);
                }
            }
        } else {
            BiBusHeader header = this.getBiBusHeader();
            retValue = this.isCAMRecovorable(header);
        }
        return retValue;
    }

    private boolean isCAMRecovorable(BiBusHeader header) {
        String errorCodeString;
        CAMException camException;
        CAM cam;
        boolean retValue = false;
        if (header != null && (cam = header.getCAM()) != null && (camException = cam.getException()) != null && (errorCodeString = camException.getErrorCodeString()) != null && (errorCodeString.equalsIgnoreCase("camAuthUserRecoverable") || errorCodeString.equalsIgnoreCase("camAuthSystemRecoverable"))) {
            retValue = true;
        }
        return retValue;
    }

    private void renewLogon() throws EMFSecurityException, SDKClientException {
        AuthenticatorFactory.getInstance().logon(this.m_headers);
        this.setBiBusHeader(this.m_headers.getBiBusHeader());
    }

    @Override
    public void log(String logMessage) {
        this.log(logMessage, SDSLevel.WARN);
    }

    protected void logMethodCall(String methodName) {
        this.log("Calling " + methodName, SDSLevel.INFO);
    }

    @Override
    public void log(String logMessage, SDSLevel level) {
        logMessage = "[" + this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length()) + "] " + logMessage;
        this.getLogger().log(level, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{logMessage});
    }

    public void debugLog(Object ... msgs) {
        if (this.getLogger().isLoggingAt(SDSLevel.DEBUG)) {
            this.getLogger().debug(this.buildLogMessage(msgs));
        }
    }

    private String buildLogMessage(Object ... msgs) {
        StringBuilder sb = new StringBuilder();
        for (Object msg : msgs) {
            sb.append(msg.toString());
        }
        return sb.toString();
    }

    @Override
    public SDSLogger getLogger() {
        return SDSLogger.getLogger(this.m_auditLogCategory);
    }

    @Override
    public void setEndpoint(URL endpoint) {
        this.m_stubBinding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpoint.toString());
    }

    @Override
    public String getPortName() {
        return this.m_stubBinding.getPortName().getLocalPart();
    }

    @Override
    public void signNextRequest(String serviceId) {
        this.signNextRequest(serviceId, true);
    }

    @Override
    public void signNextRequest(String serviceId, boolean userRequired) {
        this.m_signServiceId = serviceId;
        this.m_userRequired = userRequired;
    }

    @Override
    public void setLogCategory(SDSCategory auditCategory) {
        this.m_auditLogCategory = auditCategory;
    }

    @Override
    public void setNextSoapAction(String soapAction) {
        this.m_soapAction = soapAction;
    }

    @Override
    public void setNextSoapActionAffinity(String affinity) {
        this.m_soapActionAffinity = affinity;
    }

    @Override
    public void setReconnecting(boolean doReconnect, int endPointType) {
        this.m_doReconnect = doReconnect;
        this.m_endpointType = endPointType;
    }

    @Override
    public void setEndpointType(int endPointType) {
        this.m_endpointType = endPointType;
    }

    @Override
    public boolean isReconnecting() {
        return this.m_doReconnect;
    }

    public boolean doAddRequesterDispatcherTransportVar() {
        return false;
    }

    @Override
    public void callPreProcessing() throws SDKClientException {
        SOAPHeaderElement soapHeaderElement;
        if (this.m_signServiceId != null) {
            TrustedRequestAxisHandler.signRequest(this.m_signServiceId);
        }
        if (this.m_soapAction != null) {
            SetSoapActionHandler.setSoapActionURI(this.m_soapAction);
        } else if (this.m_soapActionAffinity != null) {
            SetSoapActionHandler.setSoapActionAffinity(this.m_soapActionAffinity);
        }
        if (this.m_formFieldVars != null) {
            for (FormFieldVar formFieldVar : this.m_formFieldVars) {
                BiBusUtilities.addFormFieldVar(this.m_headers.getBiBusHeader(), formFieldVar.getName(), formFieldVar.getValue());
            }
        }
        if (this.m_endpointType != -1) {
            this.m_stubBinding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)Client.instance().getEndpointString(this.m_endpointType));
        }
        if (this.doAddRequesterDispatcherTransportVar()) {
            String requestorValue = this.buildRequesterVar();
            BiBusUtilities.addRequesterDispatcherTransportVar(this.m_headers.getBiBusHeader(), requestorValue);
        }
        BiBusUtilities.addDispatcherTransportVar(this.m_headers.getBiBusHeader(), "NoQueueing", "true");
        if (BiBusUtilities.getEnvironmentVar(this.m_headers.getBiBusHeader(), "SERVER_NAME").equals("") && (soapHeaderElement = this.getResponseHeader()) != null) {
            BiBusHeader busHeader = null;
            try {
                busHeader = (BiBusHeader)soapHeaderElement.getValueAsType(m_bus_qname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (busHeader != null) {
                String serverName = BiBusUtilities.getEnvironmentVar(busHeader, "SERVER_NAME");
                if (this.m_headers.getBiBusHeader().getHdrSession() == null) {
                    this.m_headers.getBiBusHeader().setHdrSession(new HdrSession());
                }
                BiBusUtilities.addEnvironmentVar(this.m_headers.getBiBusHeader(), "SERVER_NAME", serverName);
            }
        }
    }

    @Override
    public void callPostProcessing() throws SDKClientException {
        this.updateHeaderWithResponse();
        if (this.doAddRequesterDispatcherTransportVar()) {
            String requestorValue = this.buildRequesterVar();
            BiBusUtilities.updateRequesterDispatcherTransportVarResponse(this.m_headers.getBiBusHeader(), requestorValue);
        }
        this.m_signServiceId = null;
        this.m_endpointType = -1;
        this.m_doReconnect = false;
        this.m_soapAction = null;
        this.m_soapActionAffinity = null;
        this.m_userRequired = true;
    }

    private String buildRequesterVar() {
        String requestOperation;
        String requestorValue = ThreadProperties.getProperty("componentID");
        if (requestorValue == null) {
            requestorValue = "JSM";
        }
        if ((requestOperation = ThreadProperties.getProperty("requestOperation")) != null) {
            requestorValue = requestorValue + ":" + requestOperation;
        }
        return requestorValue;
    }

    @Override
    public FormFieldVar addFormFieldVar(String name, String value) {
        FormFieldVar formFieldVar = new FormFieldVar();
        formFieldVar.setName(name);
        formFieldVar.setValue(value);
        if (this.m_formFieldVars == null) {
            this.m_formFieldVars = new ArrayList();
        }
        this.m_formFieldVars.add(formFieldVar);
        return formFieldVar;
    }

    @Override
    public boolean removeFormFieldVar(FormFieldVar formFieldVar) {
        boolean removed = false;
        if (this.m_formFieldVars == null) {
            removed = this.m_formFieldVars.remove(formFieldVar);
        }
        return removed;
    }

    private void updateHeaderWithResponse() throws SDKClientException {
        Message response = this.getResponseMessage();
        BiBusHeader responseHeader = null;
        try {
            try {
                if (response == null || response.getContentLength() == 0L) {
                    return;
                }
            }
            catch (Throwable t) {
                return;
            }
            responseHeader = BiBusUtilities.extractBiBusHeader(response.getSOAPEnvelope());
        }
        catch (AxisFault e) {
            throw new SDKClientException((Exception)((Object)e));
        }
        if (responseHeader == null) {
            return;
        }
        CAM responseCam = responseHeader.getCAM();
        String credPath = this.getJobBiBusHeaders().getCamCredential();
        Tracking tracking = responseHeader.getTracking();
        this.updateHeader(this.getBiBusHeader(), credPath, tracking, responseCam);
        this.updateHeader(this.getJobBiBusHeaders().getBiBusHeader(), credPath, tracking, responseCam);
    }

    private void updateHeader(BiBusHeader header, String camCredPath, Tracking tracking, CAM cam) {
        if (header == null) {
            return;
        }
        if (cam == null) {
            cam = new CAM();
        }
        if (camCredPath == null && header.getCAM() != null && header.getCAM().getCAMCredentialPath() != null) {
            camCredPath = header.getCAM().getCAMCredentialPath();
        }
        if (cam.getCAMCredentialPath() == null && camCredPath != null) {
            cam.setCAMCredentialPath(camCredPath);
        }
        header.setCAM(cam);
        if (tracking != null) {
            if (header.getTracking() == null) {
                header.setTracking(tracking);
            } else {
                header.getTracking().setConversationContext(tracking.getConversationContext());
            }
        }
    }

    protected boolean isServiceDown(RemoteException remote) {
        boolean serviceDown = false;
        if (remote.detail != null && remote.detail instanceof ConnectException) {
            serviceDown = true;
        }
        return serviceDown;
    }

    private void waitOnService() {
        int sleepTime = this.getSDKPollInterval();
        try {
            this.log("Waiting on target service to restart. Thread will sleep for " + sleepTime + " seconds");
            Thread.sleep(sleepTime * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String endpoint = Client.instance().getEndpointString(this.m_endpointType);
        this.log("Reseting endpoint string for reconnecting client to " + endpoint);
        this.m_stubBinding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpoint);
    }

    protected int getSDKPollInterval() {
        int pollValue = 30;
        String strPollValue = null;
        try {
            strPollValue = CRNProperties.getInstance().getProperty("sdk.service.poll.interval");
        }
        catch (PropertiesException pe) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Error reading sdk.service.poll.interval+: " + pe.getMessage() + " default interval [" + 30 + "] will be used.");
        }
        if (!(strPollValue == null || "".equals(strPollValue) || (pollValue = Integer.valueOf(strPollValue).intValue()) != 0 && pollValue <= 1800)) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("SDK connection polling value of [" + pollValue + "] is outside the recomended range of 0 seconds to 30 minutes; default interval [" + 30 + "] will be used.");
            pollValue = 30;
        }
        return pollValue;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }
}

