/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.client.ports;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ClientBase;
import com.cognos.jsmcommon.soap.client.ports.IServiceAPI;
import com.cognos.jsmcommon.soap.client.ports.PortMethod;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import java.rmi.RemoteException;
import org.apache.axis.client.Stub;

public class ServiceAPIImpl
extends ClientBase
implements ServiceAPI {
    private IServiceAPI port;

    public ServiceAPIImpl(JobBiBusHeaders headers, Stub stubBinding) {
        super(headers, stubBinding);
        this.port = (IServiceAPI)stubBinding;
    }

    @Override
    public void cancel(AsynchRequest conversation) throws SDKClientException, EMFSecurityException {
        this.logMethodCall("cancel(AsynchRequest)");
        this.execute(new Cancel(this.port, conversation));
    }

    @Override
    public void release(AsynchRequest conversation) throws SDKClientException, EMFSecurityException {
        this.logMethodCall("release(AsynchRequest)");
        this.execute(new Release(this.port, conversation));
    }

    @Override
    public AsynchReply run(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws SDKClientException, EMFSecurityException {
        this.logMethodCall("run(SearchPathSingleObject, ParameterValue[], Option[])");
        return (AsynchReply)this.execute(new Run(this.port, objectPath, parameterValues, options));
    }

    @Override
    public AsynchReply runSpecification(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws SDKClientException, EMFSecurityException {
        this.logMethodCall("runSpecification(AsynchSpecification, ParameterValue[], Option[])");
        return (AsynchReply)this.execute(new RunSpecification(this.port, specification, parameterValues, options));
    }

    @Override
    public AsynchReply wait(AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) throws SDKClientException, EMFSecurityException {
        this.logMethodCall("wait(AsynchRequest, ParameterValue[], Option[])");
        return (AsynchReply)this.execute(new Wait(this.port, conversation, parameterValues, options));
    }

    public class Wait
    implements PortMethod {
        private final IServiceAPI client;
        private AsynchRequest conversation;
        private ParameterValue[] parameterValues;
        private Option[] options;

        public Wait(IServiceAPI client, AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) {
            this.conversation = conversation;
            this.client = client;
            this.parameterValues = parameterValues;
            this.options = options;
        }

        @Override
        public Object execute() throws RemoteException {
            return this.client.wait(this.conversation, this.parameterValues, this.options);
        }
    }

    public class RunSpecification
    implements PortMethod {
        private final IServiceAPI serviceAPI;
        private AsynchSpecification specification;
        private ParameterValue[] parameterValues;
        private Option[] options;

        public RunSpecification(IServiceAPI serviceAPI, AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) {
            this.specification = specification;
            this.serviceAPI = serviceAPI;
            this.parameterValues = parameterValues;
            this.options = options;
        }

        @Override
        public Object execute() throws RemoteException {
            return this.serviceAPI.runSpecification(this.specification, this.parameterValues, this.options);
        }
    }

    public class Run
    implements PortMethod {
        private final IServiceAPI serviceAPI;
        private SearchPathSingleObject objectPath;
        private ParameterValue[] parameterValues;
        Option[] options;

        public Run(IServiceAPI serviceAPI, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) {
            this.objectPath = objectPath;
            this.serviceAPI = serviceAPI;
            this.parameterValues = parameterValues;
            this.options = options;
        }

        @Override
        public Object execute() throws RemoteException {
            return this.serviceAPI.run(this.objectPath, this.parameterValues, this.options);
        }
    }

    public class Release
    implements PortMethod {
        private final IServiceAPI serviceAPI;
        private AsynchRequest conversation;

        public Release(IServiceAPI serviceAPI, AsynchRequest conversation) {
            this.conversation = conversation;
            this.serviceAPI = serviceAPI;
        }

        @Override
        public Object execute() throws RemoteException {
            this.serviceAPI.release(this.conversation);
            return null;
        }
    }

    public class Cancel
    implements PortMethod {
        private final IServiceAPI serviceAPI;
        private AsynchRequest conversation;

        public Cancel(IServiceAPI serviceAPI, AsynchRequest conversation) {
            this.conversation = conversation;
            this.serviceAPI = serviceAPI;
        }

        @Override
        public Object execute() throws RemoteException {
            this.serviceAPI.cancel(this.conversation);
            return null;
        }
    }
}

