/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.service;

import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.util.AsyncServiceConstants;
import com.cognos.jsmcommon.soap.util.AttachmentUtils;
import com.cognos.jsmcommon.soap.util.PrimaryRequestToResponse;
import com.cognos.jsmcommon.soap.util.XMLHelper;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class AsyncServiceImpl
extends AsyncServiceBase
implements AsyncServiceConstants {
    private BasicHandler m_handler;
    protected SDSCategory m_category;
    private int m_primary_threshold = 0;
    private int m_secondary_threshold = 0;
    private static final String PRIMARY_REQUEST_OPTION_PATH = "//*[local-name()='options']/*[./*[local-name()='name']='alwaysIncludePrimaryRequest']/*[local-name()='value']";
    private static final String RESULT_PATH = "//*[local-name()='body']/*[local-name()='result'][@xsi:type = 'bus:asynchReply']";

    public AsyncServiceImpl(BasicHandler handler, SDSCategory category, MessageContext context) {
        this.m_handler = handler;
        this.m_category = category;
        this.m_primary_threshold = this.getDefaultPrimaryThreshold();
        this.m_secondary_threshold = this.getDefaultSecondaryThreshold();
        this.updateThresholds(context);
        this.setAsyncThreshold(this.m_primary_threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(AsyncContext ac) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("AsyncServiceImpl.invoke");
        try {
            String conversationID = ac.getConversationID();
            ac.getMessageContext().setProperty("conversation.id", (Object)conversationID);
            ac.getMessageContext().setProperty("jsmcommon.async.context", (Object)ac);
            MessageContext mc = ac.getMessageContext();
            try {
                this.m_handler.invoke(mc);
                if (this.includePrimaryRequest(mc)) {
                    PrimaryRequestToResponse prtr = new PrimaryRequestToResponse(this.m_category);
                    BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
                    BIBusEnvelope response = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
                    Element responseElement = this.addResponseElement(request, response);
                    Element resultElement = this.addResultElement(responseElement);
                    prtr.addPrimaryRequest(resultElement, response);
                }
            }
            catch (Throwable e) {
                String msg = "Error in AsyncServiceImpl#invoke(AsyncContext)";
                SDSLogger.getLogger(this.m_category).debug(msg);
                SDSLogger.getLogger(this.m_category).debug(e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    public void abandonImpl(AsyncContext ac) {
        String msg = "AsyncServiceImpl#abandonImpl(AsyncContext) called";
        SDSLogger.getLogger(this.m_category).debug(msg);
    }

    protected void cancelImpl(MessageContext mc, AsyncContext ac) {
        try {
            mc.setProperty("jsmcommon.async.context", (Object)ac);
            this.m_handler.invoke(mc);
        }
        catch (PogoException e) {
            String msg = "Error in AsyncServiceImpl#cancelImpl(MessageContext, AsyncContext)";
            SDSLogger.getLogger(this.m_category).debug(msg);
            SDSLogger.getLogger(this.m_category).debug(e);
        }
    }

    public void getOutputImpl(MessageContext mc, AsyncContext ac) {
        boolean debug = false;
    }

    public void releaseImpl(MessageContext mc) {
        try {
            AsyncContext ac = (AsyncContext)mc.getProperty("request.asyncContextImpl");
            if (ac != null) {
                mc.setProperty("jsmcommon.async.context", (Object)ac);
            }
            this.m_handler.invoke(mc);
        }
        catch (PogoException e) {
            String msg = "Error in AsyncServiceImpl#releaseImpl(MessageContext)";
            SDSLogger.getLogger(this.m_category).debug(msg);
            SDSLogger.getLogger(this.m_category).debug(e);
        }
    }

    public void stillWorkingImpl(MessageContext mc, AsyncContext ac) {
        this.setAsychResponse(mc, ac, AsynchReplyStatusEnum.stillWorking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workingImpl(MessageContext mc, AsyncContext ac) {
        MessageContext asyncMc = ac.getMessageContext();
        Object obj = asyncMc.getProperty("jsmcommon.attachmentutils.key");
        if (obj != null && obj instanceof AttachmentUtils) {
            AttachmentUtils au = (AttachmentUtils)obj;
            boolean hasReadAttachments = au.hasProcessedAttachments();
            int waitInMillis = 5000;
            int waitTotal = 0;
            int maxWait = 300000;
            int primaryThresholdMultiple = this.getDefaultPrimaryThreshold() * 1000 * 10;
            if (maxWait > primaryThresholdMultiple) {
                maxWait = primaryThresholdMultiple;
            }
            while (!hasReadAttachments && waitTotal < maxWait) {
                try {
                    Thread.sleep(waitInMillis);
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    waitTotal += waitInMillis;
                    hasReadAttachments = au.hasProcessedAttachments();
                }
            }
            String msg = "Attachment processing has delayed response in AsyncServiceImpl#workingImpl(...): delayed for " + waitTotal + " seconds";
            SDSLogger.getLogger(this.m_category).debug(msg);
            asyncMc.setProperty("jsmcommon.attachmentutils.key", null);
        }
        this.setAsychResponse(mc, ac, AsynchReplyStatusEnum.working);
    }

    public void waitReceived(MessageContext mc, AsyncContext ac) {
        this.updateSecondaryThreshold(mc);
        this.setAsyncThreshold(this.m_secondary_threshold);
    }

    protected void setAsychResponse(MessageContext mc, AsyncContext ac, AsynchReplyStatusEnum statusEnum) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        Element responseElement = this.addResponseElement(request, response);
        Element resultElement = this.addResultElement(responseElement);
        if (AsynchReplyStatusEnum.complete.equals((Object)statusEnum) || this.includePrimaryRequest(mc)) {
            PrimaryRequestToResponse prtr = new PrimaryRequestToResponse(this.m_category);
            prtr.addPrimaryRequest(resultElement, request);
            prtr.addResponseAttachments(mc);
        }
        this.addStatusElement(resultElement, statusEnum.getValue());
        if (AsynchReplyStatusEnum.working.equals((Object)statusEnum) || AsynchReplyStatusEnum.stillWorking.equals((Object)statusEnum)) {
            this.addWorkingSecondaryRequestElement(resultElement);
        }
        this.addRequestEnvelopeNamespacesToResponse(request, response);
    }

    protected Element addAsynchDetail(Element resultElement, AsyncContext ac, String status) {
        this.addStatusElement(resultElement, status);
        return null;
    }

    protected boolean includePrimaryRequest(MessageContext mc) {
        boolean includePrimary = false;
        try {
            Element includePrimaryValue = this.getElement(mc, PRIMARY_REQUEST_OPTION_PATH);
            if (includePrimaryValue != null) {
                String primString = includePrimaryValue.getText();
                includePrimary = Boolean.valueOf(primString);
            }
        }
        catch (Throwable t) {
            SDSLogger.getLogger(this.m_category).debug("Error retrieving threhold value. " + t.getMessage());
        }
        return includePrimary;
    }

    private Element getElement(MessageContext mc, String path) throws Throwable {
        BIBusEnvelope biBusEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element element = null;
        if (biBusEnv != null) {
            Element body = biBusEnv.getBody();
            element = body == null ? null : (Element)body.selectSingleNode(path);
        }
        return element;
    }

    private void setReplyAsychResponse(MessageContext mc, AsyncContext ac, AsynchReplyStatusEnum statusEnum) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        QName requiredResponseQName = this.getResponseQName(request);
        Element bodyElem = response.getBody();
        List bodyElements = bodyElem.elements();
        if (bodyElem.element(requiredResponseQName) != null || bodyElements.size() == 0) {
            Element resultElement;
            Element responseElement = null;
            if (bodyElements.size() == 0) {
                responseElement = bodyElem.addElement(requiredResponseQName);
            }
            if (bodyElem.element(requiredResponseQName) != null) {
                responseElement = bodyElem.element(requiredResponseQName);
            }
            if ((resultElement = this.addResultElement(responseElement)).element(DETAILS) == null) {
                this.addAsynchDetail(resultElement, ac, statusEnum.getValue());
            }
            this.addRequestEnvelopeNamespacesToResponse(request, response);
        } else if (bodyElements.size() == 1) {
            Element currentResponseElement = (Element)bodyElements.iterator().next();
            Element requiredResponseElement = bodyElem.addElement(requiredResponseQName);
            Iterator it = currentResponseElement.elementIterator();
            while (it.hasNext()) {
                Element childElement = (Element)it.next();
                Element childClone = childElement.createCopy();
                requiredResponseElement.add(childClone);
            }
            currentResponseElement.detach();
        } else {
            String msg = "Error in AsyncServiceImpl#setReplyAsyncResponse(MessageContext, AsyncContext) - invalid SOAP-BODY.\n";
            msg = msg + "More than a single element in the SOAP-BODY";
            SDSLogger.getLogger(this.m_category).debug(msg);
        }
    }

    public void replyNow(MessageContext mc, AsyncContext ac) {
        ((MessageContextImpl)mc).collectResponse((MessageContextImpl)ac.getMessageContext());
        BIBusEnvelope respEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String status = "conversationComplete";
        if (respEnv != null) {
            Element bodyElement = respEnv.getBody();
            Element statusElement = (Element)bodyElement.selectSingleNode("//*[local-name()='result']/*[local-name()='status']");
            if (statusElement != null) {
                status = statusElement.getText();
            }
            respEnv.setConversationContextStatus(status);
        }
        if (request != null) {
            request.setConversationContextStatus(status);
        }
        if (respEnv != null && respEnv.getFault() == null) {
            this.setReplyAsychResponse(mc, ac, AsynchReplyStatusEnum.conversationComplete);
        }
    }

    public void responseReady(MessageContext mc, AsyncContext ac) {
        this.replyNow(mc, ac);
    }

    private QName getResponseQName(BIBusEnvelope requestEnvelope) {
        QName responceQName = null;
        String method = null;
        String namespaceURL = null;
        String prefix = null;
        Element body = requestEnvelope.getBody();
        Iterator children = body.elementIterator();
        if (children.hasNext()) {
            Element child = (Element)children.next();
            method = child.getName();
            namespaceURL = child.getNamespaceURI();
            prefix = child.getNamespacePrefix();
            Namespace responseNamespace = Namespace.get((String)prefix, (String)namespaceURL);
            responceQName = new QName(method + "Response", responseNamespace);
        }
        if (!("cancel".equals(method) || "run".equals(method) || "runSpecification".equals(method) || "release".equals(method) || "background".equals(method) || "wait".equals(method) || "deleteAllNotifications".equals(method) || "previewAgent".equals(method) || "validateAgent".equals(method) || "currentPage".equals(method) || "firstPage".equals(method) || "nextPage".equals(method) || "previousPage".equals(method) || "lastPage".equals(method) || "add".equals(method) || "collectParameterValues".equals(method) || "forward".equals(method) || "back".equals(method))) {
            String msg = "Method not supported by AsynchService: " + method;
            SDSLogger.getLogger(this.m_category).debug(msg);
            return null;
        }
        return responceQName;
    }

    protected abstract int getDefaultPrimaryThreshold();

    protected abstract int getDefaultSecondaryThreshold();

    protected int calculateThreshold(int defaultValue, String propKey) {
        try {
            int newValue = defaultValue;
            String configValue = CRNProperties.getInstance().getProperty(propKey);
            newValue = configValue != null ? Integer.valueOf(configValue) : defaultValue;
            defaultValue = newValue < 0 ? -newValue : newValue;
        }
        catch (PropertiesException propertiesException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private void updateThresholds(MessageContext mc) {
        this.updatePrimaryThreshold(mc);
        this.updateSecondaryThreshold(mc);
    }

    private void updatePrimaryThreshold(MessageContext mc) {
        try {
            Element primaryThreshValue = this.getElement(mc, "//*[local-name()='options']/*[local-name()='item'][./*[local-name()='name']='primaryWaitThreshold']/*[local-name()='value']");
            if (primaryThreshValue != null) {
                String threshString = primaryThreshValue.getText();
                this.m_primary_threshold = Integer.parseInt(threshString);
            }
        }
        catch (Throwable t) {
            SDSLogger.getLogger(this.m_category).debug("Error retrieving threhold value. " + t.getMessage());
        }
    }

    private void updateSecondaryThreshold(MessageContext mc) {
        try {
            Element secondaryThreshValue = this.getElement(mc, "//*[local-name()='options']/*[local-name()='item'][./*[local-name()='name']='secondaryWaitThreshold']/*[local-name()='value']");
            if (secondaryThreshValue != null) {
                String threshString = secondaryThreshValue.getText();
                this.m_secondary_threshold = Integer.parseInt(threshString);
            }
        }
        catch (Throwable t) {
            SDSLogger.getLogger(this.m_category).debug("Error retrieving threhold value. " + t.getMessage());
        }
    }

    protected Element addResponseElement(BIBusEnvelope request, BIBusEnvelope response) {
        QName responseQName = this.getResponseQName(request);
        Element bodyElem = response.getBody();
        if (bodyElem.element(responseQName) != null) {
            return bodyElem.element(responseQName);
        }
        AsyncServiceImpl.removePreparedSkeletalResponseBody(response);
        return bodyElem.addElement(responseQName);
    }

    protected Element addResultElement(Element responseElement) {
        Element resultElement = responseElement.element(RESULT);
        if (resultElement == null) {
            resultElement = responseElement.addElement(RESULT.getName());
            resultElement.addAttribute(XMLHelper.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
            Element badResultElement = responseElement.element("collectParameterValuesReturn");
            if (badResultElement != null) {
                List elements = badResultElement.elements();
                for (Element element : elements) {
                    element.detach();
                    element.setDocument(resultElement.getDocument());
                    resultElement.add(element);
                }
                badResultElement.detach();
            }
        }
        return resultElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Element addStatusElement(Element resultElement, String status) {
        Element statusElement = resultElement.element(STATUS);
        if (statusElement != null) {
            if (statusElement.attribute(BIBusEnvelope.XSI_NIL) == null) return statusElement;
            statusElement.attribute(BIBusEnvelope.XSI_NIL).detach();
        } else {
            statusElement = resultElement.addElement(STATUS.getName());
            statusElement.addAttribute(XMLHelper.XSI_TYPE, BUS_ASYNC_REPLY_STATUS_ENUM.getQualifiedName());
        }
        statusElement.setText(status);
        return statusElement;
    }

    protected Element addWorkingSecondaryRequestElement(Element resultElement) {
        Element secondaryRequestElement = resultElement.addElement(SECONDARY_REQUESTS);
        secondaryRequestElement.addAttribute(XMLHelper.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        secondaryRequestElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, ASYNCH_SECONDARY_REQUEST.getQualifiedName() + "[1]");
        Element itemElement = secondaryRequestElement.addElement(ITEM);
        itemElement.addAttribute(XMLHelper.XSI_TYPE, ASYNCH_SECONDARY_REQUEST.getQualifiedName());
        Element nameElement = itemElement.addElement(NAME);
        nameElement.addAttribute(XMLHelper.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        nameElement.addText("wait");
        Element optionsElement = itemElement.addElement(OPTIONS);
        optionsElement.addAttribute(XMLHelper.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, OPTION.getQualifiedName() + "[0]");
        Element parametersElement = itemElement.addElement(PARAMETERS);
        parametersElement.addAttribute(XMLHelper.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        parametersElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, PARAMETER_VALUE.getQualifiedName() + "[0]");
        return secondaryRequestElement;
    }

    public static void removePreparedSkeletalResponseBody(BIBusEnvelope response) {
        Element soapBody = response.getBody();
        List bodyContent = soapBody.content();
        if (bodyContent == null) {
            return;
        }
        Element responseBody = null;
        for (int i = 0; i < bodyContent.size(); ++i) {
            Namespace responseNamespace;
            if (!(bodyContent.get(i) instanceof Element) || !BIBusEnvelope.NS_BUS.equals((Object)(responseNamespace = (responseBody = (Element)bodyContent.get(i)).getNamespace()))) continue;
            responseBody.detach();
            break;
        }
    }

    protected void addRequestEnvelopeNamespacesToResponse(BIBusEnvelope request, BIBusEnvelope response) {
        Element requestEnv = request.getEnvelope();
        Iterator namespaceIter = requestEnv.declaredNamespaces().iterator();
        Element responseEnv = response.getEnvelope();
        while (namespaceIter.hasNext()) {
            Namespace ns = (Namespace)namespaceIter.next();
            if (ns.getPrefix() == null || responseEnv.getNamespaceForPrefix(ns.getPrefix()) != null) continue;
            responseEnv.addNamespace(ns.getPrefix(), ns.getURI());
        }
    }

    protected BasicHandler getHandler() {
        return this.m_handler;
    }
}

