/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.service;

import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.service.IHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.soap.service.SDSSoapService;
import com.cognos.jsmcommon.soap.service.ServiceConfigurationException;
import com.cognos.jsmcommon.soap.service.ServiceContext;
import com.cognos.jsmcommon.soap.util.AttachmentUtils;
import com.cognos.jsmcommon.soap.util.IAttachmentUtils;
import com.cognos.jsmcommon.soap.util.SDSConfiguration;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.server.AxisServer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AxisServiceHandler
implements IHandler {
    static final QName BUS_credential = DocumentHelper.createQName((String)"CAMCredentialPath", (Namespace)BIBusEnvelope.NS_BUS);
    private static final String RESPONSE_NAME = "response";
    public static final String SOAP_ENVELOPE = "request.envelope";
    protected static Map m_servicesMap = new HashMap();
    protected MessageContext m_message_context = null;
    private IServiceConfiguration m_config = null;
    private SDSSoapService m_service = null;
    private IAttachmentUtils m_attachmentUtils;
    private boolean m_useRequestTestFile = false;
    private boolean m_useResponseTestFile = false;
    private String m_testRequestFile = "c:/scratch/ms-run.xml";
    private String m_testResponseFile = "Y:/amazonCR1.02/xmltests/workingAddScheduleResponse.xml";
    private boolean m_isAsync = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AxisServiceHandler(MessageContext mc) {
        Class<AxisServiceHandler> clazz = AxisServiceHandler.class;
        synchronized (AxisServiceHandler.class) {
            this.m_config = SDSConfiguration.getInstance();
            this.m_message_context = mc;
            Iterator iter = (Iterator)this.m_message_context.getProperty("request.attachments");
            if (iter != null) {
                this.m_attachmentUtils = new AttachmentUtils(mc);
                mc.setProperty("jsmcommon.attachmentutils.key", (Object)this.m_attachmentUtils);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AxisServiceHandler(IServiceConfiguration config, MessageContext mc) {
        Class<AxisServiceHandler> clazz = AxisServiceHandler.class;
        synchronized (AxisServiceHandler.class) {
            this.m_config = config;
            this.m_message_context = mc;
            Iterator iter = (Iterator)this.m_message_context.getProperty("request.attachments");
            if (iter != null) {
                this.m_attachmentUtils = new AttachmentUtils(mc);
                mc.setProperty("jsmcommon.attachmentutils.key", (Object)this.m_attachmentUtils);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AxisServiceHandler getHandler(IServiceConfiguration config, MessageContext mc) {
        AxisServiceHandler handler = new AxisServiceHandler(config, mc);
        Class<AxisServiceHandler> clazz = AxisServiceHandler.class;
        synchronized (AxisServiceHandler.class) {
            SDSSoapService service = (SDSSoapService)m_servicesMap.get(config);
            if (service == null) {
                try {
                    service = AxisServiceHandler.getSoapService(config);
                }
                catch (ServiceConfigurationException e) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_SOAP_SERVICE_CONFIG_ERROR);
                    BIBusEnvelope soap_env = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
                    handler.setUnexpectedError(e, new Date(), soap_env);
                }
            }
            handler.setService(service);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SDSSoapService getSoapService(IServiceConfiguration config) throws ServiceConfigurationException {
        SDSSoapService service = (SDSSoapService)m_servicesMap.get(config);
        if (service != null) return service;
        Class<AxisServiceHandler> clazz = AxisServiceHandler.class;
        synchronized (AxisServiceHandler.class) {
            service = new SDSSoapService(config);
            service.init();
            m_servicesMap.put(config, service);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return service;
        }
    }

    public void setService(SDSSoapService service) {
        this.m_service = service;
    }

    public static AxisServer getServer(IServiceConfiguration config) throws ServiceConfigurationException {
        return AxisServiceHandler.getSoapService(config).getServer();
    }

    @Override
    public void prepare() {
    }

    @Override
    public synchronized void execute() {
        Date affinityTimerStart = new Date();
        BIBusEnvelope soap_env = (BIBusEnvelope)this.m_message_context.getProperty(SOAP_ENVELOPE);
        this.outputBIBusEnvelope(soap_env, I18NCode.MSG_SOAP_ENVELOPE_REQUEST);
        if (this.m_useRequestTestFile) {
            soap_env = this.getTestEnvelopeFromFile(this.m_testRequestFile);
        }
        try {
            AsyncContext asyncContext;
            ServiceContext serviceContext = this.getServiceContext(this.m_message_context);
            String conversationId = (String)this.m_message_context.getProperty("conversation.id");
            if (conversationId != null) {
                serviceContext.setConversationId(conversationId);
            }
            if ((asyncContext = (AsyncContext)this.m_message_context.getProperty("jsmcommon.async.context")) != null) {
                serviceContext.setAsyncContext(asyncContext);
            }
            String sessionUser = (String)this.m_message_context.getProperty("job.sessionUser");
            Element cam = soap_env.getCAM();
            Element credential = cam.element(BUS_credential);
            if (credential != null) {
                sessionUser = credential.getText();
            }
            if (sessionUser != null && sessionUser != "") {
                serviceContext.setSessionUser(sessionUser);
            }
            serviceContext.setBiBusEnvelope(soap_env);
            Document doc = soap_env.getAsDocument();
            Message response = this.m_service.process(doc, this.m_attachmentUtils, serviceContext);
            this.setResponse(response, affinityTimerStart, soap_env);
        }
        catch (EMFSecurityException e) {
            this.setEnvelope(e.getBIBusEnvelope(), affinityTimerStart);
        }
        catch (Throwable t) {
            System.out.println(t.getLocalizedMessage());
            t.printStackTrace();
            this.setUnexpectedError(t, affinityTimerStart, soap_env);
        }
    }

    private ServiceContext getServiceContext(MessageContext mc) {
        ServiceContext serviceContext = (ServiceContext)mc.getProperty("service.context");
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        return serviceContext;
    }

    @Override
    public synchronized void setContext(MessageContext context) {
        this.m_message_context = context;
    }

    protected void setResponse(Message responseMsg, Date startTime, BIBusEnvelope soapRequest) throws AxisFault {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            responseMsg.writeTo((OutputStream)baos);
            BIBusEnvelope envelope = new BIBusEnvelope((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            String status = "conversationComplete";
            envelope.setConversationContextStatus(status);
            this.setEnvelope(envelope, startTime);
        }
        catch (Exception e) {
            this.setUnexpectedError(e, startTime, soapRequest);
        }
    }

    private void setFaultResponse(APIException e, Date startTime, BIBusEnvelope soapRequest) {
        BIBusEnvelope envelope = new BIBusEnvelope();
        soapRequest.copyNamespacesTo((SOAPEnvelope)envelope);
        BIBusEnvelope request = (BIBusEnvelope)this.m_message_context.getProperty(SOAP_ENVELOPE);
        String locale = request.getUserPreferenceValue("productLocale");
        envelope.setTracking(request.getTracking().createCopy());
        envelope.createFaultElement(e.getFaultCode(Locale.getDefault()), e.getFaultString(Locale.getDefault()));
        Element detail = envelope.getFaultDetail();
        detail = e.getDom4JDetail(detail, Locale.getDefault());
        this.setEnvelope(envelope, startTime);
    }

    protected void setUnexpectedError(Throwable e, Date startTime, BIBusEnvelope soapRequest) {
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_ERROR_GENERATING_RESPONSE, new String[]{"" + e.getMessage()});
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
        this.setFaultResponse(new APIException(new SDSServiceException(I18NCode.GEN_THROWABLE_ERROR, new Object[]{"" + e.getMessage()})), startTime, soapRequest);
    }

    private void setEnvelope(BIBusEnvelope envelope, Date startTime) {
        try {
            AsyncContext async;
            boolean scenario2;
            if (this.m_isAsync) {
                this.setAffinityStrength(envelope, startTime);
                envelope.setConversationContextStatus("conversationComplete");
            }
            envelope.addRequiredEnvNamespaces(envelope.getEnvelope());
            this.outputBIBusEnvelope(envelope, I18NCode.MSG_SOAP_ENVELOPE_RESPONSE);
            this.fillContext(this.m_message_context, envelope);
            Element bigFault = envelope.getBody().element("Fault");
            Element littleFault = envelope.getBody().element("fault");
            boolean scenario1 = !this.m_isAsync;
            boolean bl = scenario2 = this.m_isAsync && (bigFault != null || littleFault != null);
            if (scenario1) {
                this.m_message_context.respond(RESPONSE_NAME);
            } else if (scenario2 && (async = (AsyncContext)this.m_message_context.getProperty("jsmcommon.async.context")) != null) {
                MessageContext asyncMC = async.getMessageContext();
                this.fillContext(asyncMC, envelope);
                if (envelope.getFault() != null) {
                    asyncMC.setFault(new Fault("Error", (SOAPEnvelope)envelope));
                }
            }
        }
        catch (IOException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_BALTIC_HANDLER_FAILED_TO_RESPOND, new String[]{"" + e.getMessage()});
        }
    }

    private void fillContext(MessageContext context, BIBusEnvelope envelope) {
        context.setProperty("response.envelope", (Object)envelope);
        context.setProperty("response.status_code", (Object)"200");
        context.setProperty("response.status_msg", (Object)"OK");
        context.setProperty("response.headers", (Object)new InternetHeaders());
        context.setResponseName(RESPONSE_NAME);
    }

    private void outputBIBusEnvelope(BIBusEnvelope envelope, I18NCode code) {
        if (SDSLogger.getLogger(JSMCommonCategory.AUDIT_REQUEST).isLoggingAt(SDSLevel.INFO)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                envelope.writeAsXML((OutputStream)baos);
                String requestString = baos.toString("UTF-8");
                SDSLogger.getLogger(JSMCommonCategory.AUDIT_REQUEST).log(SDSLevel.INFO, code, new String[]{requestString});
            }
            catch (IOException ex) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Exception logging debug " + ex.getMessage());
            }
        }
    }

    private void debugOutputBIBusEnvelope(String envelopeName, BIBusEnvelope envelope) {
        try {
            System.out.println(envelopeName);
            envelope.writeAsXML((OutputStream)System.out);
            System.out.println("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BIBusEnvelope getTestEnvelopeFromFile(String fileName) {
        BIBusEnvelope testEnvelope = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            testEnvelope = new BIBusEnvelope((InputStream)fis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return testEnvelope;
    }

    public void setAsAsync(boolean isAsync) {
        this.m_isAsync = isAsync;
    }

    private void setAffinityStrength(BIBusEnvelope env, Date startTime) {
        int strength = 0;
        if (startTime != null) {
            Date endTime = new Date();
            long processingTime = endTime.getTime() - startTime.getTime();
            strength = (int)processingTime;
            if (processingTime > Integer.MAX_VALUE) {
                strength = Integer.MAX_VALUE;
            }
        }
        env.setConversationContextAffinityStrength(strength);
    }
}

