/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.service;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.soap.service.ServiceConfigurationException;
import com.cognos.jsmcommon.soap.service.ServiceContext;
import com.cognos.jsmcommon.soap.util.IAttachmentUtils;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.Mapping;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class SDSSoapService {
    private IServiceConfiguration config;
    private AxisServer engine;
    private SOAPService service;
    private static final String SOAP_ENC_PREFIX = "SOAP-ENC";
    private static final String SOAP_ENC_URI = "http://schemas.xmlsoap.org/soap/encoding/";

    public SDSSoapService(IServiceConfiguration config) {
        this.config = config;
    }

    public void init() throws ServiceConfigurationException {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.FATAL, "ENTER");
        InputStream stream = this.getClass().getResourceAsStream((String)this.config.getProperty("wsdd.file"));
        FileProvider fp = new FileProvider(stream);
        PerfLog perf2 = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.FATAL, "BEGIN", "creating axis server");
        this.engine = new AxisServer((EngineConfiguration)fp);
        perf2.stop();
        this.engine.setOption("sendMultiRefs", (Object)Boolean.FALSE);
        try {
            String tempDir = CRNProperties.getInstance().getProperty("temp");
            if (tempDir != null) {
                AxisProperties.setProperty((String)"axis.attachments.Directory", (String)tempDir);
                AxisProperties.setProperty((String)"attachments.Directory", (String)tempDir);
                this.engine.setOption("axis.attachments.Directory", (Object)tempDir);
                this.engine.setOption("attachments.Directory", (Object)tempDir);
            }
        }
        catch (PropertiesException tempDir) {
            // empty catch block
        }
        String serviceName = (String)this.config.getProperty("service.name");
        if (serviceName == null) {
            serviceName = "CognosReportNetPort";
        }
        try {
            this.service = fp.getServiceByNamespaceURI(serviceName);
        }
        catch (ConfigurationException ex) {
            throw new ServiceConfigurationException(I18NCode.GEN_SERVICE_START_ERROR, new Object[]{serviceName, ex.getMessage()});
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message process(Document requestDocument, Object attachments, ServiceContext serviceContext) throws AxisFault, IOException, DocumentException, SOAPException, SAXException, EMFSecurityException {
        PerfLog perf = SDSLogger.getLogger(JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.WARN, "ENTER");
        Message responseMsg = null;
        try {
            boolean cmFaultWithHeaders;
            Message requestMsg;
            MessageContext msgContext;
            block14: {
                ByteArrayInputStream requestIs = new ByteArrayInputStream(requestDocument.asXML().getBytes("UTF-8"));
                msgContext = new MessageContext((AxisEngine)this.engine);
                msgContext.setProperty("jsmcommon.service.context", (Object)serviceContext);
                msgContext.setProperty("dom4j.request.document", (Object)requestDocument);
                msgContext.setHighFidelity(false);
                msgContext.setService(this.service);
                requestMsg = new Message((Object)requestIs, false);
                if (attachments != null && attachments instanceof IAttachmentUtils) {
                    ((IAttachmentUtils)attachments).setAttachmentParts((SOAPMessage)requestMsg);
                }
                msgContext.setRequestMessage(requestMsg);
                cmFaultWithHeaders = false;
                try {
                    this.engine.invoke(msgContext);
                }
                catch (AxisFault fault) {
                    String requestOp = ThreadProperties.getProperty("requestOperation");
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, new String[]{"RequestOperation = " + requestOp + "  ERROR : " + fault.getMessage()});
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, new String[]{"RequestOperation = " + requestOp + "  ERROR ON REQUEST : " + requestDocument.asXML()});
                    if (fault.detail instanceof SAXException) {
                        throw (SAXException)fault.detail;
                    }
                    if (fault.detail instanceof EMFSecurityException) {
                        throw (EMFSecurityException)fault.detail;
                    }
                    if (fault.getHeaders() == null) break block14;
                    cmFaultWithHeaders = true;
                }
            }
            responseMsg = msgContext.getResponseMessage();
            if (cmFaultWithHeaders) {
                boolean hasBiBusSoapEnc = false;
                ArrayList respNS = responseMsg.getSOAPEnvelope().namespaces;
                Iterator iter = respNS.iterator();
                while (iter.hasNext() && !hasBiBusSoapEnc) {
                    Mapping mapping = (Mapping)iter.next();
                    if (!mapping.getPrefix().equals(SOAP_ENC_PREFIX)) continue;
                    hasBiBusSoapEnc = true;
                }
                if (!hasBiBusSoapEnc) {
                    respNS.add(new Mapping(SOAP_ENC_URI, SOAP_ENC_PREFIX));
                }
            } else {
                Vector headers = requestMsg.getSOAPEnvelope().getHeaders();
                for (SOAPHeaderElement header : headers) {
                    responseMsg.getSOAPEnvelope().addHeader(header);
                }
                ArrayList reqNS = requestMsg.getSOAPEnvelope().namespaces;
                ArrayList respNS = responseMsg.getSOAPEnvelope().namespaces;
                for (Object mapping : reqNS) {
                    if (respNS.contains(mapping)) continue;
                    respNS.add(mapping);
                }
                responseMsg.getSOAPEnvelope().setNSMappings(respNS);
            }
        }
        finally {
            perf.stop();
        }
        return responseMsg;
    }

    public AxisServer getServer() {
        return this.engine;
    }

    private void outputMessage(Message msg, OutputStream os) {
        try {
            msg.writeTo(os);
            os.flush();
        }
        catch (IOException iOException) {
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }
}

