/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.service;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.ProcessHandlerException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.AttachmentException;
import com.cognos.jsmcommon.soap.client.AttachmentFactory;
import com.cognos.jsmcommon.soap.service.ServiceContext;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public abstract class ServiceImplBase {
    private IAuthenticator m_authenticator = AuthenticatorFactory.getInstance();

    protected void setContextObject(Object obj) {
        AsyncContext ac = this.getServiceContext().getAsyncContext();
        if (ac != null) {
            ac.setContextObj(obj);
        }
    }

    protected final Object getContextObject() {
        Object ctxObj = null;
        AsyncContext ac = this.getServiceContext().getAsyncContext();
        if (ac != null) {
            ctxObj = ac.getContextObj();
        }
        return ctxObj;
    }

    protected final void throwAxisFault(LocalizableException e) throws AxisFault {
        this.throwAxisFault(new APIException(e));
    }

    protected final void throwAxisFault(APIException e) throws AxisFault {
        AxisFault fault = AxisFault.makeFault((Exception)e);
        BiBusHeader header = BiBusUtilities.extractBiBusHeader();
        String eventId = ThreadProperties.getProperty("asynchDetailEventID");
        BiBusUtilities.addFormFieldVarToResponseHeader("asynchDetailEventID", eventId);
        Locale locale = LocaleUtil.getRequestProductLocale(header);
        fault.setFaultCodeAsString(e.getFaultCode(locale));
        fault.setFaultString(e.getFaultString(locale));
        fault.setFaultDetail(e.getDetails(locale));
        throw fault;
    }

    protected BiBusHeader extractBiBusHeader() throws AxisFault {
        return this.extractBiBusHeader(false);
    }

    protected BiBusHeader extractBiBusHeader(boolean maintainContext) throws AxisFault {
        BiBusHeader header = BiBusUtilities.extractBiBusHeader(MessageContext.getCurrentContext());
        return maintainContext ? header : BiBusUtilities.removeConversationContext(header);
    }

    protected final void throwUnsupportedOperation() throws RemoteException {
        ProcessHandlerException phe = new ProcessHandlerException(I18NCode.OTH_UNSUPPORTED_OPERATION);
        this.throwAxisFault(new APIException(phe));
    }

    protected IAuthenticator getAuthenticator() {
        return this.m_authenticator;
    }

    protected Attachment[] getAttachments() throws AttachmentException {
        Message currentMessage = MessageContext.getCurrentContext().getRequestMessage();
        return AttachmentFactory.getAttachments(currentMessage);
    }

    protected final void authenticate(JobBiBusHeaders headers) throws AxisFault {
        try {
            this.getAuthenticator().authenticate(headers);
        }
        catch (Exception e) {
            AxisFault fault = null;
            fault = e.getCause() instanceof AxisFault ? (AxisFault)e.getCause() : AxisFault.makeFault((Exception)e);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(this, e.getLocalizedMessage());
            throw fault;
        }
    }

    protected final BIBusEnvelope getBIBusEnvelope() {
        ServiceContext serviceContext = this.getServiceContext();
        return serviceContext.getBIBusEnvelope();
    }

    protected final String getSessionUser() {
        ServiceContext serviceContext = this.getServiceContext();
        return serviceContext.getSessionUser();
    }

    protected final void isCMTrustedRequest() throws AxisFault {
        BIBusEnvelope env = this.getBIBusEnvelope();
        boolean isTrusted = false;
        try {
            isTrusted = this.getAuthenticator().isTrustedCMRequest(env);
        }
        catch (EMFSecurityException ex) {
            throw AxisFault.makeFault((Exception)ex);
        }
        if (!isTrusted) {
            throw new AxisFault("Request is not trusted");
        }
    }

    protected void isTrustedRequest() throws AxisFault {
        BIBusEnvelope env = this.getBIBusEnvelope();
        boolean isTrusted = false;
        try {
            isTrusted = this.getAuthenticator().isTrustedRequest(env);
        }
        catch (EMFSecurityException ex) {
            throw AxisFault.makeFault((Exception)ex);
        }
        if (!isTrusted) {
            throw new AxisFault("Request is not trusted");
        }
    }

    public ServiceContext getServiceContext() {
        return (ServiceContext)MessageContext.getCurrentContext().getProperty("jsmcommon.service.context");
    }

    protected void debugWait(String propKey) {
        try {
            int newValue;
            String configValue = CRNProperties.getInstance().getProperty(propKey);
            if (configValue != null && (newValue = Integer.valueOf(configValue).intValue()) < 0) {
                Thread.sleep(-newValue * 1000);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
    }
}

