/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.AsyncConversationStatusListener;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadFactoryImpl;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ThreadRequestAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AsyncConversation
implements Serializable {
    ArrayList m_status_listeners = new ArrayList();
    AsynchReplyStatusEnum m_status = null;
    boolean m_set_to_cancel = false;
    boolean m_was_cancelled = false;
    String m_id;
    private static final ExecutorService m_threadPool = Executors.newCachedThreadPool(new ThreadFactoryImpl("TaskRunner.wait:"));
    private static final int MAX_INTERRUPT_COUNT = 8;

    public AsyncConversation() {
    }

    public AsyncConversation(String m_id) {
        this.m_id = m_id;
    }

    public AsynchReply doConversationWithRelease(ServiceAPI service, AsynchReply reply) throws LocalizableException {
        this.getRTLogger().debug(this.generateLogMessage("Before calling doWaitConversation(...)", "AsyncConversation", "doConversationWithRelease(ServiceAPI service, AsynchReply reply)"));
        reply = this.doWaitConversation(service, reply);
        this.getRTLogger().debug(this.generateLogMessage("After calling doWaitConversation(...)", "AsyncConversation", "doConversationWithRelease(ServiceAPI service, AsynchReply reply)"));
        if (!this.isCancelled() && AsynchReplyStatusEnum.complete.equals((Object)this.getStatus())) {
            try {
                service.log("Response output ready, releasing service resources.");
                service.release(reply.getPrimaryRequest());
            }
            catch (EMFSecurityException e) {
                throw new SDSServiceException(I18NCode.ACCESS_CONTROL_CONNECTION, (Throwable)e);
            }
            this.updateStatus(reply, AsynchReplyStatusEnum.conversationComplete);
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply doWaitConversation(ServiceAPI service, AsynchReply reply) throws LocalizableException {
        this.getRTLogger().debug(this.generateLogMessage("In method doWaitConversation(ServiceAPI service, AsynchReply reply)", "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
        WaitWorker ww = null;
        this.updateStatus(reply, reply.getStatus());
        if (AsynchReplyStatusEnum.conversationComplete.equals((Object)this.getStatus()) || AsynchReplyStatusEnum.complete.equals((Object)this.getStatus())) {
            return reply;
        }
        try {
            AsyncConversation asyncConversation = this;
            synchronized (asyncConversation) {
                if (this.isCancelled()) {
                    this.getRTLogger().debug(this.generateLogMessage("Cancelling executing process.", "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                    service.log("cancelling executing process.");
                    service.cancel(reply.getPrimaryRequest());
                    this.m_was_cancelled = true;
                    this.getRTLogger().debug(this.generateLogMessage("Cancelled executing process.", "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                } else {
                    ww = new WaitWorker(this, service, reply.getPrimaryRequest());
                    service.log("Starting async wait thread.");
                    this.getRTLogger().debug(this.generateLogMessage("Starting async wait thread", "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                    m_threadPool.execute(ww);
                    int interruptRetyCount = 8;
                    while (!AsynchReplyStatusEnum.conversationComplete.equals((Object)ww.getWorkerStatus())) {
                        try {
                            this.getRTLogger().debug(this.generateLogMessage("Going into wait... waiting to be woken up by Async wait thread: " + ww.getThreadName(), "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                            this.wait();
                            service.log("Woke up from " + ww.getThreadName());
                            this.getRTLogger().debug(this.generateLogMessage("Woke up from async wait thread: " + ww.getThreadName(), "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                            break;
                        }
                        catch (InterruptedException e) {
                            this.getRTLogger().debug(this.generateLogMessage(String.valueOf(--interruptRetyCount) + " interrupted from async wait thread: " + ww.getThreadName(), "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                            if (interruptRetyCount != 0) continue;
                            ww.cancel();
                            throw new SDSServiceException(I18NCode.KEY_INTERRUPTED_CONVERSATION);
                        }
                    }
                }
            }
            if (this.m_was_cancelled) {
                this.updateStatus(reply, AsynchReplyStatusEnum.conversationComplete);
                reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
                return reply;
            }
            this.checkException(service, ww);
            AsynchReply tempReply = ww.getAsynchReply();
            AsynchReplyStatusEnum tempStatus = null;
            AsynchRequest primaryRequest = reply.getPrimaryRequest();
            if (tempReply != null) {
                reply = tempReply;
                tempStatus = tempReply.getStatus();
            }
            if (tempStatus == null || !AsynchReplyStatusEnum.conversationComplete.equals((Object)tempStatus) && !AsynchReplyStatusEnum.complete.equals((Object)tempStatus)) {
                if (this.isCancelled()) {
                    service.log("cancelling executing process.");
                    this.getRTLogger().debug(this.generateLogMessage("Cancelling executing process.", "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
                    ww.cancel();
                    service.cancel(primaryRequest);
                    tempStatus = AsynchReplyStatusEnum.conversationComplete;
                    reply.setStatus(tempStatus);
                    this.m_was_cancelled = true;
                } else {
                    if (tempReply == null || tempStatus == null) {
                        this.logLostReply(service);
                        throw new SDSServiceException(I18NCode.KEY_UNKNOWN);
                    }
                    throw new SDSServiceException(I18NCode.KEY_UNKNOWN);
                }
            }
            this.updateStatus(tempReply, tempStatus);
        }
        catch (EMFSecurityException e) {
            service.log("Security Exception when cancelling the task: " + e.getLocalizedMessage());
            this.getRTLogger().debug(this.generateLogMessage("Security Exception when cancelling the task: " + e.getLocalizedMessage(), "AsyncConversation", "doWaitConversation(ServiceAPI service, AsynchReply reply)"));
            throw new SDSServiceException(I18NCode.ACCESS_CONTROL_CONNECTION, (Throwable)e);
        }
        return reply;
    }

    private void checkException(ServiceAPI service, WaitWorker ww) throws LocalizableException {
        if (ww.getException() != null) {
            service.log("Java exception: " + ww.getException().getMessage());
            throw new SDSServiceException(I18NCode.AGENT_ERROR, ww.getException());
        }
        if (ww.getServiceException() != null) {
            service.log("Service exception: " + ww.getServiceException().getMessage());
            throw ww.getServiceException();
        }
    }

    private void logLostReply(ServiceAPI service) {
        BiBusHeader header = service.getBiBusHeader();
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("lost our conversation");
        this.getRTLogger().debug(this.generateLogMessage("Lost our conversation.", "AsyncConversation", "logLostReply(ServiceAPI service)"));
        header = service.getBiBusHeader();
        if (header.getTracking() != null) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(header.getTracking().getConversationContext().getStatus());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(header.getTracking().getConversationContext().getId());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(header.getTracking().getConversationContext().getNodeID());
        }
    }

    public void reset() {
        this.m_set_to_cancel = false;
        this.m_was_cancelled = false;
        this.m_status = null;
    }

    public synchronized void cancel() {
        this.getRTLogger().debug(this.generateLogMessage("cancel() method called.", "AsyncConversation", "cancel()"));
        this.m_set_to_cancel = true;
        for (AsyncConversationStatusListener listener : this.m_status_listeners) {
            listener.onConversationCancel();
        }
        this.notify();
    }

    public synchronized boolean isCancelled() {
        return this.m_set_to_cancel;
    }

    public boolean didCancelSucceed() {
        return this.m_was_cancelled;
    }

    public void updateStatus(AsynchReply reply, AsynchReplyStatusEnum status) throws LocalizableException {
        if (status != null && status.equals((Object)this.getStatus())) {
            return;
        }
        this.m_status = status;
        for (AsyncConversationStatusListener listener : this.m_status_listeners) {
            listener.updateConversationStatus(reply, this.m_status);
        }
    }

    public void addStatusListener(AsyncConversationStatusListener statusListener) {
        this.m_status_listeners.add(statusListener);
    }

    public void removeStatusListener(AsyncConversationStatusListener statusListener) {
        this.m_status_listeners.remove(statusListener);
    }

    public void clearStatusListeners(AsyncConversationStatusListener statusListener) {
        this.m_status_listeners.clear();
    }

    public AsynchReplyStatusEnum getStatus() {
        return this.m_status;
    }

    private String generateLogMessage(String msg, String objectName, String methodName) {
        String oName = "";
        String mName = "";
        if (objectName != null) {
            oName = objectName;
        }
        if (methodName != null) {
            mName = methodName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" TASK:LOG:START: OBJECT=");
        sb.append(oName);
        sb.append(" : METHOD=");
        sb.append(mName);
        sb.append(" : EVENTID=");
        if (this.m_id != null) {
            sb.append(this.m_id);
        }
        sb.append(" : MSG=");
        sb.append(msg);
        sb.append(" : TASK:LOG:END");
        return sb.toString();
    }

    SDSLogger getRTLogger() {
        return SDSLogger.getLogger(JSMCommonCategory.RUNTIME);
    }

    private class WaitWorker
    implements Runnable {
        private Object m_owner;
        private ServiceAPI m_serviceAPI;
        private AsynchReply m_asynchReply;
        private AsynchRequest m_asynchRequest;
        private Throwable m_runtime;
        private LocalizableException m_service_exception;
        private boolean m_cancelled = false;
        private String m_threadName = "";
        private AsynchReplyStatusEnum m_workerStatus = AsynchReplyStatusEnum.working;
        private ThreadRequestAdapter m_threadRequestAdapter;

        public WaitWorker(Object owner, ServiceAPI serviceAPI, AsynchRequest asynchRequest) {
            this.m_owner = owner;
            this.m_serviceAPI = serviceAPI;
            this.m_asynchRequest = asynchRequest;
            this.m_threadRequestAdapter = new ThreadRequestAdapter();
        }

        public String getThreadName() {
            return this.m_threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ZipiTimer zipiTimer = ZipiBridge.startTimer(this.m_threadRequestAdapter, "WaitWorker.run");
            try {
                this.m_threadName = Thread.currentThread().getName();
                while (!(this.m_cancelled || AsynchReplyStatusEnum.conversationComplete.equals((Object)this.m_workerStatus) || AsynchReplyStatusEnum.complete.equals((Object)this.m_workerStatus))) {
                    AsyncConversation.this.getRTLogger().debug(AsyncConversation.this.generateLogMessage("Before calling wait(...) on the target service", "WaitWorker", "run()"));
                    this.m_asynchReply = this.m_serviceAPI.wait(this.m_asynchRequest, null, null);
                    AsyncConversation.this.getRTLogger().debug(AsyncConversation.this.generateLogMessage("After calling wait(...) on the target service", "WaitWorker", "run()"));
                    if (this.m_asynchReply == null) break;
                    if (this.m_asynchReply.getStatus() == null) {
                        break;
                    }
                    this.m_workerStatus = this.m_asynchReply.getStatus();
                    if (this.m_asynchReply.getPrimaryRequest() == null) continue;
                    this.m_asynchRequest = this.m_asynchReply.getPrimaryRequest();
                }
            }
            catch (SDKClientException e) {
                this.m_service_exception = e;
                AsyncConversation.this.getRTLogger().debug(e);
            }
            catch (EMFSecurityException e) {
                this.m_service_exception = new SDSServiceException(I18NCode.ACCESS_CONTROL_CONNECTION, (Throwable)e);
                AsyncConversation.this.getRTLogger().debug(e);
            }
            catch (Throwable rt) {
                this.m_runtime = rt;
                AsyncConversation.this.getRTLogger().debug(rt);
            }
            finally {
                Object e = this.m_owner;
                synchronized (e) {
                    this.m_owner.notify();
                }
                zipiTimer.stopAndClear();
            }
        }

        public synchronized void cancel() {
            this.m_cancelled = true;
            AsyncConversation.this.getRTLogger().debug(AsyncConversation.this.generateLogMessage("cancel() called", "WaitWorker", "cancel()"));
        }

        public Throwable getException() {
            return this.m_runtime;
        }

        public LocalizableException getServiceException() {
            return this.m_service_exception;
        }

        public AsynchReply getAsynchReply() {
            return this.m_asynchReply;
        }

        public AsynchReplyStatusEnum getWorkerStatus() {
            return this.m_workerStatus;
        }
    }
}

