/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.IAttachmentUtils;
import com.cognos.jsmcommon.util.IMimeHeaderConstants;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.DechunkingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;

public class AttachmentUtils
implements IAttachmentUtils,
IMimeHeaderConstants {
    public static final String REQUEST_ATTACHMENTS = "request.attachments";
    public static final String RESPONSE_ATTACHMENTS = "response.attachments";
    public static final String RESPONSE_BOUNDARY = "response.boundary";
    public static final String ATTACHMENT_UTILS_KEY = "jsmcommon.attachmentutils.key";
    private SDSCategory m_traceCategory;
    private SDSCategory m_runtimeCategory;
    private Iterator m_attachmentsIter;
    private boolean m_hasProcessedAttachments = false;

    public AttachmentUtils(MessageContext context, SDSCategory traceCategory, SDSCategory runtimeCategory) {
        this.m_traceCategory = traceCategory;
        this.m_runtimeCategory = runtimeCategory;
        this.m_attachmentsIter = (Iterator)context.getProperty(REQUEST_ATTACHMENTS);
    }

    public AttachmentUtils(MessageContext context) {
        this(context, JSMCommonCategory.TRACE, JSMCommonCategory.RUNTIME);
    }

    public boolean hasProcessedAttachments() {
        return this.m_hasProcessedAttachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAttachmentParts(SOAPMessage message) {
        try {
            if (this.m_attachmentsIter == null) {
                return;
            }
            while (this.m_attachmentsIter.hasNext()) {
                InputStream is = (InputStream)this.m_attachmentsIter.next();
                try {
                    this.addAttachmentPart(message, is);
                    is.close();
                }
                catch (IOException e) {
                    SDSLogger.getLogger(this.m_runtimeCategory).log(SDSLevel.ERROR, I18NCode.MSG_READING_ATTACH_ITR, new String[]{"" + e.getMessage()});
                }
            }
        }
        finally {
            this.m_hasProcessedAttachments = true;
        }
    }

    private void addAttachmentPart(SOAPMessage message, InputStream is) throws IOException {
        String[] conId;
        InternetHeaders partHdrs = null;
        try {
            partHdrs = new InternetHeaders(is);
        }
        catch (Exception ex) {
            SDSLogger.getLogger(this.m_runtimeCategory).log(SDSLevel.ERROR, I18NCode.MSG_READING_ATTACH_ITR, new String[]{"" + ex.getMessage()});
        }
        if (null == partHdrs) {
            String s = "Error reading Attachment header (header is null)";
            SDSLogger.getLogger(this.m_runtimeCategory).log(SDSLevel.ERROR, I18NCode.MSG_READING_ATTACH_ITR, new String[]{"" + s});
            return;
        }
        if (MimeHeaderUtil.isChunked((InternetHeaders)partHdrs)) {
            SDSLogger.getLogger(this.m_runtimeCategory).log(SDSLevel.ERROR, I18NCode.MSG_DECHUNKING_STREAM);
            is = new DechunkingInputStream(is);
        }
        if (null == (conId = partHdrs.getHeader("Content-ID")) || conId.length == 0) {
            SDSLogger.getLogger(this.m_traceCategory).log(SDSLevel.DEBUG, I18NCode.MSG_NO_CONTENT_ID_FOUND);
            return;
        }
        if (is == null) {
            SDSLogger.getLogger(this.m_traceCategory).log(SDSLevel.DEBUG, I18NCode.MSG_READING_DATA_STREAM_FAIL, new String[]{conId[0], "stream is null."});
            return;
        }
        String contentType = null;
        String[] contentTypeHdrs = partHdrs.getHeader("Content-Type");
        contentType = contentTypeHdrs != null && contentTypeHdrs.length > 0 ? contentTypeHdrs[0] : "text/plain";
        String contentEncoding = partHdrs.getHeader("Content-Encoding", null);
        NCDataSource ds = DataSourceFactory.getDataSource(is, contentType, contentEncoding);
        DataHandler dh = new DataHandler((DataSource)ds);
        AttachmentPart ap = message.createAttachmentPart();
        ap.setDataHandler(dh);
        ap.removeAllMimeHeaders();
        Enumeration enumHdrs = partHdrs.getAllHeaders();
        while (enumHdrs.hasMoreElements()) {
            Header hdr = (Header)enumHdrs.nextElement();
            String name = hdr.getName();
            String value = hdr.getValue();
            ap.addMimeHeader(name, value);
            SDSLogger.getLogger(this.m_traceCategory).log(SDSLevel.DEBUG, I18NCode.MSG_READING_ATTACH_HDR, new String[]{name, value});
        }
        message.addAttachmentPart(ap);
    }
}

