/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.soap.util.SDSConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Stub;
import org.apache.axis.constants.Style;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.server.AxisServer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AxisUtils {
    private static AxisUtils m_instance = new AxisUtils(SDSConfiguration.getInstance());
    private AxisServer m_engine = null;
    private IServiceConfiguration m_config = null;
    private static final String WRAPPER = "wrapper";
    private static final org.dom4j.QName BUS_BIBUS_HEADER = BIBusEnvelope.BUS_BIBUS_HEADER;
    private static final Namespace NS_XSD = Namespace.get((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final Namespace NS_XSI = Namespace.get((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace NS_BUS = BIBusEnvelope.NS_BUS;
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace NS_SOAP_ENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");

    public static AxisUtils getInstance() {
        return m_instance;
    }

    private String serialize(Object bases) throws Exception {
        return this.serializeInWrapper(bases, new QName("details"));
    }

    public String serialize(Object bases, QName messageElementQName) throws Exception {
        String serialization = "";
        SAXReader saxReader = new SAXReader();
        StringReader reader = new StringReader(this.serializeInWrapper(bases, messageElementQName));
        Document doc = saxReader.read((Reader)reader);
        Element details = (Element)doc.selectSingleNode("/wrapper/*");
        if (details != null) {
            details.detach();
            Element root = doc.getRootElement();
            List additionalNamespaces = root.additionalNamespaces();
            Iterator namespaceIt = additionalNamespaces.iterator();
            while (namespaceIt.hasNext()) {
                details.add((Namespace)namespaceIt.next());
            }
            serialization = details.asXML();
        }
        return serialization;
    }

    private String serializeInWrapper(Object bases, QName messageElementQName) throws Exception {
        StringWriter writer = new StringWriter();
        MessageContext msgContext = new MessageContext((AxisEngine)this.m_engine);
        msgContext.setHighFidelity(false);
        msgContext.setService(this.m_engine.getService((String)this.m_config.getProperty("service.name")));
        SerializationContext serializeContext = null;
        serializeContext = new SerializationContext((Writer)writer, msgContext);
        serializeContext.setSendDecl(false);
        serializeContext.setPretty(true);
        serializeContext.registerPrefixForURI(NS_XSD.getPrefix(), NS_XSD.getURI());
        serializeContext.registerPrefixForURI(NS_XSI.getPrefix(), NS_XSI.getURI());
        serializeContext.registerPrefixForURI(NS_BUS.getPrefix(), NS_BUS.getURI());
        serializeContext.registerPrefixForURI(NS_SOAP_ENC.getPrefix(), NS_SOAP_ENC.getURI());
        serializeContext.registerPrefixForURI(NS_SOAP_ENV.getPrefix(), NS_SOAP_ENV.getURI());
        RPCParam wrapper = new RPCParam(messageElementQName, bases);
        RPCElement element = new RPCElement(WRAPPER);
        element.addParam(wrapper);
        element.output(serializeContext);
        writer.close();
        return writer.toString();
    }

    public Object deserialize(Element requestElement, QName typeQname) throws SAXException, IOException, AxisFault {
        String soap_env_pre = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Header></SOAP-ENV:Header><SOAP-ENV:Body>";
        String soap_env_post = "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
        MessageContext msgContext = new MessageContext((AxisEngine)this.m_engine);
        msgContext.setHighFidelity(false);
        msgContext.setService(this.m_engine.getService((String)this.m_config.getProperty("service.name")));
        Message requestMsg = new Message((Object)"", true);
        msgContext.setRequestMessage(requestMsg);
        String requestWrapper = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Header></SOAP-ENV:Header><SOAP-ENV:Body><reportWrapper>" + requestElement.asXML() + "</reportWrapper>" + "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
        InputSource requestIs = new InputSource(new StringReader(requestWrapper));
        DeserializationContext deserContext = new DeserializationContext(requestIs, msgContext, "response");
        String operationName = "reportWrapper";
        QName nameQname = new QName(requestElement.getQName().getNamespaceURI(), requestElement.getQName().getName(), requestElement.getQName().getNamespacePrefix());
        typeQname = this.calculateTypeQName(requestElement, typeQname);
        OperationDesc oper = new OperationDesc(operationName, new ParameterDesc[]{new ParameterDesc(nameQname, 1, typeQname)}, new QName("xs", NS_XSD.getURI(), "string"));
        oper.setStyle(Style.WRAPPED);
        msgContext.setOperation(oper);
        deserContext.parse();
        SOAPBodyElement bodyEl = deserContext.getEnvelope().getFirstBody();
        Vector params = ((RPCElement)bodyEl).getParams();
        Object[] values = new Object[params.size()];
        for (int i = 0; i < values.length; ++i) {
            Object tst;
            RPCParam tmp = (RPCParam)params.get(i);
            values[i] = tst = tmp.getObjectValue();
        }
        return values[0];
    }

    private QName calculateTypeQName(Element requestElement, QName typeQname) {
        if (typeQname != null) {
            Namespace typeNamespace = requestElement.getNamespaceForURI(typeQname.getNamespaceURI());
            typeQname = new QName(typeQname.getNamespaceURI(), typeQname.getLocalPart(), typeNamespace.getPrefix());
        } else {
            Iterator it = requestElement.attributeIterator();
            while (it.hasNext() && typeQname == null) {
                String attributeValue;
                int colonPos;
                Namespace attributeNamespace;
                Attribute attribute = (Attribute)it.next();
                if (!attribute.getName().equals("type") || (attributeNamespace = attribute.getNamespace()) == null || !attributeNamespace.getURI().equals(NS_XSI.getURI()) || (colonPos = (attributeValue = attribute.getValue()).indexOf(":")) == -1) continue;
                String typeNamespacePrefix = attributeValue.substring(0, colonPos);
                String typeName = attributeValue.substring(colonPos + 1);
                Namespace typeNamespace = requestElement.getNamespaceForPrefix(typeNamespacePrefix);
                if (typeNamespace == null) continue;
                typeQname = new QName(typeNamespace.getURI(), typeName, typeNamespace.getPrefix());
            }
        }
        return typeQname;
    }

    public static void updateResponseHeader(Stub stub) throws Exception {
        BiBusHeader header = AxisUtils.getReponseHeader(stub);
        AxisUtils.setHeader(stub, header);
    }

    public static BiBusHeader getReponseHeader(Stub stub) throws Exception {
        BiBusHeader header = null;
        if (stub.getResponseHeader(BUS_BIBUS_HEADER.getNamespaceURI(), BUS_BIBUS_HEADER.getName()) != null) {
            SOAPHeaderElement temp = stub.getResponseHeader(BUS_BIBUS_HEADER.getNamespaceURI(), BUS_BIBUS_HEADER.getName());
            header = (BiBusHeader)temp.getObjectValue(BiBusHeader.class);
        }
        return header;
    }

    public static BiBusHeader getHeader(Stub stub) throws Exception {
        SOAPHeaderElement temp;
        BiBusHeader header = null;
        if (stub.getHeader(BUS_BIBUS_HEADER.getNamespaceURI(), BUS_BIBUS_HEADER.getName()) != null && (temp = stub.getHeader(BUS_BIBUS_HEADER.getNamespaceURI(), BUS_BIBUS_HEADER.getName())).getObjectValue() != null) {
            header = (BiBusHeader)temp.getObjectValue(BiBusHeader.class);
        }
        return header;
    }

    public static void setHeader(Stub stub, BiBusHeader header) {
        if (stub == null) {
            return;
        }
        stub.clearHeaders();
        stub.setHeader(BUS_BIBUS_HEADER.getNamespaceURI(), BUS_BIBUS_HEADER.getName(), (Object)header);
    }

    public void addElements(Element parent, Object bases) {
        try {
            String element = this.serialize(bases);
            SAXReader saxReader = new SAXReader();
            StringReader reader = new StringReader(element);
            Document doc = saxReader.read((Reader)reader);
            Element details = (Element)doc.selectSingleNode("/wrapper/details");
            details.setDocument(parent.getDocument());
            parent.add(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AxisUtils(IServiceConfiguration config) {
        try {
            this.m_config = config;
            this.m_engine = AxisServiceHandler.getServer(config);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

