/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.axis.encoding.ser.Base64Deserializer;

public class Base64BinaryDeserializer
extends Base64Deserializer {
    public Base64BinaryDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public Object getValue() {
        Object returnValue = super.getValue();
        if (this.value instanceof AttachmentPart) {
            AttachmentPart part = (AttachmentPart)this.value;
            try {
                Object content = part.getContent();
                if (content instanceof String) {
                    String returnValueString = (String)part.getContent();
                    returnValue = returnValueString.getBytes();
                } else if (content instanceof InputStream) {
                    returnValue = part.getContentId().getBytes();
                } else {
                    String type = content == null ? "null" : content.getClass().getName();
                    String msg = "Base64BinaryDeserializer.getValue() expected content of type String or InputStream but was: " + type;
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(msg);
                }
            }
            catch (SOAPException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            }
        }
        return returnValue;
    }
}

