/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.ser.Base64Serializer;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class Base64BinarySerializer
extends Base64Serializer {
    public static final String ATTRIBUTE = "[attribute]";
    private static final String ATTRIBUTE_NAME = "href";

    public Base64BinarySerializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        String data = this.getValueAsString(value, context);
        boolean isAttribute = false;
        AttributesImpl attr = null;
        if (null != data && data.startsWith(ATTRIBUTE)) {
            if (attributes == null) {
                attributes = new AttributesImpl();
            }
            attr = new AttributesImpl(attributes);
            data = data.substring(ATTRIBUTE.length());
            attr.addAttribute("", "", ATTRIBUTE_NAME, "", data);
            isAttribute = true;
        }
        context.startElement(name, attr);
        if (!isAttribute) {
            context.writeString(super.getValueAsString(value, context));
        }
        context.endElement();
    }

    public String getValueAsString(Object value, SerializationContext context) {
        byte[] data = null;
        if (this.javaType == byte[].class) {
            data = (byte[])value;
        } else {
            data = new byte[((Byte[])value).length];
            for (int i = 0; i < data.length; ++i) {
                Byte b = ((Byte[])value)[i];
                if (b == null) continue;
                data[i] = b;
            }
        }
        String strValue = null;
        try {
            strValue = new String(data, "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return strValue;
    }
}

