/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

public class BiBusSoapAction {
    public static BiBusSoapAction Unknown = new BiBusSoapAction("");
    private String soapAction;
    private String base;
    private String version;
    private String service;
    private String affinity;
    private Format format;

    public BiBusSoapAction(String s) {
        if (s == null) {
            this.format = Format.Unknown;
            return;
        }
        if (s.length() >= 2) {
            s = BiBusSoapAction.stripQuotes(s);
        }
        this.format = Format.Unknown;
        this.soapAction = s;
        int slash_idx = s.lastIndexOf(47);
        if (slash_idx == -1) {
            return;
        }
        if (this.tryParseBalticForm(++slash_idx) || this.tryParseIBMForm(slash_idx) || this.tryParseColoradoForm(slash_idx)) {
            this.validate();
        }
    }

    private boolean tryParseBalticForm(int n) {
        if (n == 1) {
            return false;
        }
        int pound_idx = this.soapAction.indexOf(35, n);
        if (pound_idx == -1) {
            return false;
        }
        this.base = this.soapAction.substring(0, n);
        this.version = this.soapAction.substring(n, pound_idx);
        int dot_idx = this.soapAction.indexOf(46, pound_idx + 1);
        if (dot_idx != -1) {
            this.affinity = this.soapAction.substring(dot_idx + 1);
            this.service = this.soapAction.substring(pound_idx + 1, dot_idx);
        } else {
            this.service = this.soapAction.substring(pound_idx + 1);
        }
        this.format = Format.Baltic;
        return true;
    }

    private boolean tryParseColoradoForm(int n) {
        if (n < 2) {
            return false;
        }
        int slash_idx = this.soapAction.lastIndexOf(47, n - 2);
        if (slash_idx == -1) {
            return false;
        }
        this.service = this.soapAction.substring(slash_idx + 1, n - 1);
        this.base = this.soapAction.substring(0, slash_idx + 1);
        int dot_idx = this.soapAction.indexOf(46, n);
        if (dot_idx != -1) {
            this.affinity = this.soapAction.substring(dot_idx + 1);
            this.version = this.soapAction.substring(n, dot_idx);
        } else {
            this.version = this.soapAction.substring(n);
        }
        this.format = Format.Colorado;
        return true;
    }

    private boolean tryParseIBMForm(int n) {
        if (n == this.soapAction.length()) {
            this.affinity = null;
        } else if (this.soapAction.charAt(n) == '.') {
            this.affinity = this.soapAction.substring(n + 1);
        } else {
            return false;
        }
        int slash_idx = this.soapAction.lastIndexOf(47, n - 2);
        if (slash_idx == -1) {
            return false;
        }
        this.version = this.soapAction.substring(slash_idx + 1, n - 1);
        n = slash_idx;
        if ((slash_idx = this.soapAction.lastIndexOf(47, n - 1)) == -1) {
            return false;
        }
        this.service = this.soapAction.substring(slash_idx + 1, n);
        this.base = this.soapAction.substring(0, slash_idx + 1);
        if (!this.base.equals("http://www.ibm.com/xmlns/prod/cognos/")) {
            return false;
        }
        this.format = Format.IBM;
        return true;
    }

    private void validate() {
        if (!BiBusSoapAction.isString(this.base) || !BiBusSoapAction.isString(this.service) || !this.validateVersion() || this.affinity != null && this.affinity.length() == 0) {
            this.format = Format.Unknown;
            this.affinity = null;
            this.service = null;
            this.version = null;
            this.base = null;
        }
    }

    private static boolean isString(String s) {
        return s != null && s.length() != 0;
    }

    private boolean validateVersion() {
        try {
            if (this.version.startsWith("_")) {
                this.version = this.version.substring(1);
            }
            Integer.parseInt(this.version);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static String stripQuotes(String s) {
        char ch = s.charAt(0);
        if ((ch == '\'' || ch == '\"') && s.charAt(s.length() - 1) == ch) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String getBase() {
        return this.base;
    }

    public String getVersion() {
        return this.version;
    }

    public String getService() {
        return this.service;
    }

    public String getAffinity() {
        return this.affinity;
    }

    public Format getFormat() {
        return this.format;
    }

    public String toString() {
        return this.soapAction;
    }

    public static enum Format {
        Unknown,
        Baltic,
        Colorado,
        IBM;

    }
}

