/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.apache.axis.encoding.Base64;

public class JobBiBusHeaders
implements Serializable {
    private static final String CAM_INIT_STRING = "<initializeDocument><serviceID>SDS</serviceID></initializeDocument>";
    public static final long serialVersionUID = 70009003L;
    BiBusHeader biBusHeader;
    String credentialPath;

    public JobBiBusHeaders() {
        this.setBiBusHeader(new BiBusHeader());
    }

    public JobBiBusHeaders(BiBusHeader header) {
        this.setBiBusHeader(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiBusHeader getBiBusHeader() {
        Class<JobBiBusHeaders> clazz = JobBiBusHeaders.class;
        synchronized (JobBiBusHeaders.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.biBusHeader;
        }
    }

    public void setBiBusHeader(BiBusHeader header) {
        this.setBiBusHeader(header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBiBusHeader(BiBusHeader header, boolean removeConversationContext) {
        Class<JobBiBusHeaders> clazz = JobBiBusHeaders.class;
        synchronized (JobBiBusHeaders.class) {
            BiBusHeader biBusHeader = this.biBusHeader = removeConversationContext ? BiBusUtilities.removeConversationContext(header) : header;
            if (header.getCAM() != null && header.getCAM().getCAMCredentialPath() != null) {
                this.credentialPath = header.getCAM().getCAMCredentialPath();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String getCamCredential() {
        String path = this.credentialPath;
        if (path == null && this.biBusHeader.getCAM() != null && this.biBusHeader.getCAM().getCAMCredentialPath() != null) {
            path = this.biBusHeader.getCAM().getCAMCredentialPath();
        }
        return path;
    }

    public String getPassport() {
        return this.biBusHeader.getCAM() != null && this.biBusHeader.getCAM().getCAMPassport() != null ? this.biBusHeader.getCAM().getCAMPassport().getId() : null;
    }

    public void setPassport(String pport) {
        this.setCAM();
        CAMPassport cpport = new CAMPassport();
        cpport.setId(pport);
        this.biBusHeader.getCAM().setCAMPassport(cpport);
    }

    public void setCAM() {
        if (this.biBusHeader.getCAM() == null) {
            this.biBusHeader.setCAM(new CAM());
        }
    }

    public void setCamCredential(String path) {
        this.credentialPath = path;
    }

    public String getUserPreferenceContentLocale() {
        return this.getUserPreference("contentLocale");
    }

    public String getUserPreferenceProductLocale() {
        return this.getUserPreference("productLocale");
    }

    public String getUserPreferenceModel() {
        return this.getUserPreference("m_path");
    }

    public String getUserPreferenceOutputFormat() {
        return this.getUserPreference("format");
    }

    public Locale getProductLocale() {
        return this.convertLocale(this.getUserPreferenceProductLocale());
    }

    public Locale getLocale() {
        String localeString = this.getUserPreferenceContentLocale();
        Locale locale = null;
        if (localeString != null) {
            locale = this.convertLocale(localeString);
        }
        if (locale == null) {
            locale = this.getProductLocale();
        }
        return locale;
    }

    public UserCapabilityEnum[] getUserCapabilities() throws SDSServiceException {
        UserCapabilityCache cache = this.biBusHeader.getUserCapabilityCache();
        UserCapabilityEnum[] capabilities = new UserCapabilityEnum[]{};
        String passport = null;
        if (this.biBusHeader.getCAM() != null && this.biBusHeader.getCAM().getCAMPassport() != null) {
            passport = this.biBusHeader.getCAM().getCAMPassport().getId();
        }
        try {
            if (cache != null) {
                capabilities = cache.getUserCapabilities();
                byte[] signature = cache.getSignature();
                String xmlStr = "";
                xmlStr = this.createCapabilitiesXML(capabilities);
                if (!this.checkSignature(signature, xmlStr.getBytes(), passport)) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("The user capabilities signature is not valid");
                    throw new SDSServiceException(I18NCode.SEC_INVALID_SIGNATURE);
                }
            } else {
                capabilities = this.getCapabilitiesFromSession();
            }
        }
        catch (CAMCryptoException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("The user capabilities signature could not be verified");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(ex);
            throw new SDSServiceException(I18NCode.MSG_CANNOT_RETRIEVE_USER_CAPABILITIES, (Throwable)ex);
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Unable to retrieve capabilities from the user session");
            throw new SDSServiceException(I18NCode.MSG_CANNOT_RETRIEVE_USER_CAPABILITIES, (Throwable)ex);
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Unable to retrieve capabilities from the user session");
            throw new SDSServiceException(I18NCode.MSG_CANNOT_RETRIEVE_USER_CAPABILITIES, (Throwable)ex);
        }
        return capabilities;
    }

    public String createCapabilitiesXML(UserCapabilityEnum[] caps) {
        String capabilityXML = "";
        String wrapperStart = "<userCapabilities xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:userCapabilityEnum[]\">";
        String wrapperEnd = "</userCapabilities>";
        StringBuffer buf = new StringBuffer(wrapperStart);
        for (int i = 0; i < caps.length; ++i) {
            UserCapabilityEnum cap = caps[i];
            String val = cap.getValue();
            buf.append("<item xsi:type=\"bus:userCapabilityEnum\">");
            buf.append(val);
            buf.append("</item>");
        }
        buf.append(wrapperEnd);
        capabilityXML = buf.toString();
        return capabilityXML;
    }

    private boolean checkSignature(byte[] signature, byte[] caps, String passport) throws CAMCryptoException {
        GenericTrustedSession gts = null;
        CAMFactory camFactory = new CAMFactory();
        boolean bReturn = caps != null && caps.length > 0;
        camFactory.initialize(CAM_INIT_STRING.getBytes());
        gts = camFactory.createGenericTrustedSession();
        byte[] signatureEncoded = Base64.encode((byte[])signature).getBytes();
        bReturn = gts.verifyTrustToken(signatureEncoded, caps, passport);
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserCapabilityEnum[] getCapabilitiesFromSession() throws SDSServiceException, SDKClientException, EMFSecurityException {
        UserCapabilityEnum[] ucea;
        block11: {
            IClientBase cm = null;
            ucea = new UserCapabilityEnum[]{};
            BaseClass[] classes = null;
            boolean doLogoff = false;
            try {
                if (this.biBusHeader.getCAM() != null && this.biBusHeader.getCAM().getAction() != null && this.biBusHeader.getCAM().getAction().equals("logonAs")) {
                    AuthenticatorFactory.getInstance().logon(this);
                    doLogoff = true;
                }
                if ((classes = (cm = Client.instance().getContentManagerServiceClient(this)).query(new SearchPathMultipleObject("~~"), new PropEnum[]{PropEnum.userCapabilities}, new Sort[0], new QueryOptions())) != null && classes.length >= 1 && classes[0] instanceof Session) {
                    Session session = (Session)classes[0];
                    UserCapabilityEnumArrayProp uceap = session.getUserCapabilities();
                    ucea = uceap != null ? uceap.getValue() : null;
                    break block11;
                }
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Unable to retrieve session information for the current user.");
                throw new SDSServiceException(I18NCode.SEC_NO_SESSSION_INFO);
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
                if (doLogoff) {
                    try {
                        AuthenticatorFactory.getInstance().logoff(this.biBusHeader);
                        this.biBusHeader.getCAM().setAction("logonAs");
                        this.biBusHeader.getCAM().setCAMPassport(null);
                    }
                    catch (EMFSecurityException e) {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskRunDetailsImpl.getSchedulePriority - logoff error: " + e.getLocalizedMessage());
                    }
                }
            }
        }
        return ucea;
    }

    private Locale convertLocale(String localeString) {
        Locale locale = null;
        locale = localeString == null || localeString.length() == 0 ? Locale.getDefault() : LocaleUtil.getLocale(localeString);
        return locale;
    }

    private String getUserPreference(String key) {
        String value = null;
        if (key == null) {
            return value;
        }
        BiBusHeader biBusHeader = this.getBiBusHeader();
        if (null != biBusHeader && this.getBiBusHeader().getUserPreferenceVars() != null) {
            for (UserPreferenceVar pref : Arrays.asList(this.getBiBusHeader().getUserPreferenceVars())) {
                if (pref.getName().compareTo(key) != 0) continue;
                value = pref.getValue();
            }
        }
        return value;
    }
}

