/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.AsyncServiceConstants;
import com.cognos.jsmcommon.soap.util.AttachmentStreams;
import com.cognos.jsmcommon.soap.util.XMLHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.soap.util.mime.MimeUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class PrimaryRequestToResponse
implements AsyncServiceConstants {
    private SDSCategory m_category;

    public PrimaryRequestToResponse(SDSCategory category) {
        this.m_category = category;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element addPrimaryRequest(Element resultElement, BIBusEnvelope request) {
        List content;
        if (resultElement == null || request == null) {
            return null;
        }
        Element primaryRequestElement = resultElement.element(PRIMARY_REQUEST);
        if (primaryRequestElement != null) {
            if (primaryRequestElement.attribute(BIBusEnvelope.XSI_NIL) == null) return primaryRequestElement;
            primaryRequestElement.attribute(BIBusEnvelope.XSI_NIL).detach();
        } else {
            primaryRequestElement = resultElement.addElement(PRIMARY_REQUEST.getName());
            primaryRequestElement.addAttribute(XMLHelper.XSI_TYPE, BUS_ASYNC_REQUEST.getQualifiedName());
        }
        Element requestBody = request.getBody();
        List bodyContent = requestBody.content();
        Element requestBodyMethod = null;
        for (int i = 0; i < bodyContent.size(); ++i) {
            if (!(bodyContent.get(i) instanceof Element)) continue;
            requestBodyMethod = (Element)bodyContent.get(i);
            break;
        }
        Element asynchRequest = null;
        if (requestBodyMethod.getName().equals("run") || requestBodyMethod.getName().equals("runSpecification") || requestBodyMethod.getName().equals("collectParameterValues")) {
            content = requestBodyMethod.content();
            for (int i = 0; i < content.size(); ++i) {
                if (!(content.get(i) instanceof Element)) continue;
                Element childElem = (Element)content.get(i);
                Element childElemCopy = childElem.getName().equals("parameterValues") ? childElem.createCopy(BUS_ASYNC_PARAMETERS) : childElem.createCopy();
                primaryRequestElement.add(childElemCopy);
            }
        } else if (requestBodyMethod.getName().equals("wait") || requestBodyMethod.getName().equals("cancel") || requestBodyMethod.getName().equals("release")) {
            content = requestBodyMethod.content();
            for (int i = 0; i < content.size(); ++i) {
                Element elem;
                if (!(content.get(i) instanceof Element) || !(elem = (Element)content.get(i)).getName().equals("conversation")) continue;
                asynchRequest = (Element)content.get(i);
                break;
            }
            if (asynchRequest != null) {
                List arContent = asynchRequest.content();
                for (int i = 0; i < arContent.size(); ++i) {
                    if (!(arContent.get(i) instanceof Element)) continue;
                    Element childElem = (Element)arContent.get(i);
                    Element childElemCopy = childElem.createCopy();
                    primaryRequestElement.add(childElemCopy);
                }
            }
        }
        if (asynchRequest != null) {
            HashMap prefixMap = new HashMap();
            this.sortNamespaces(asynchRequest, prefixMap, primaryRequestElement);
            for (String prefix : prefixMap.keySet()) {
                String uri = (String)prefixMap.get(prefix);
                primaryRequestElement.addNamespace(prefix, uri);
            }
            return primaryRequestElement;
        } else if (requestBodyMethod == null) return primaryRequestElement;
        return primaryRequestElement;
    }

    private void sortNamespaces(Element requestElem, Map prefixMap, Element target) {
        Iterator attributeIter = target.attributeIterator();
        while (attributeIter.hasNext()) {
            Namespace namespace;
            String namePrefix;
            Attribute attr = (Attribute)attributeIter.next();
            String value = attr.getValue();
            int prefixEndIndex = value.indexOf(":");
            if (prefixEndIndex <= 0 || this.getNamespaceForPrefix(target, namePrefix = value.substring(0, prefixEndIndex)) != null || (namespace = this.getNamespaceForPrefix(requestElem, namePrefix)) == null) continue;
            prefixMap.put(namePrefix, namespace.getURI());
        }
        Iterator childElementIterator = target.elementIterator();
        while (childElementIterator.hasNext()) {
            this.sortNamespaces(requestElem, prefixMap, (Element)childElementIterator.next());
        }
    }

    private Namespace getNamespaceForPrefix(Element element, String prefix) {
        while (element != null) {
            Namespace ns = element.getNamespaceForPrefix(prefix);
            if (ns != null) {
                return ns;
            }
            element = element.getParent();
        }
        return null;
    }

    public void addResponseAttachments(MessageContext mc) {
        Iterator iter = (Iterator)mc.getProperty("request.attachments");
        if (iter != null) {
            try {
                AttachmentStreams as = new AttachmentStreams(iter);
                mc.setProperty("request.attachments", (Object)as.getAttachments());
                mc.setProperty("response.attachments", (Object)as.getAttachments());
                mc.setProperty("response.boundary", (Object)MimeUtils.getUniqueValue());
            }
            catch (IOException e) {
                SDSLogger.getLogger(this.m_category).log(SDSLevel.ERROR, I18NCode.MSG_READING_ATTACH_ITR, new String[]{"" + e.getMessage()});
                mc.setProperty("request.attachments", null);
            }
        }
    }
}

