/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.soap.util;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.ServiceAssociation;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ServiceMetadata {
    private static final String SERVICE_METATDATA = "/com/cognos/jsmcommon/soap/util/ServiceMetadata.xml";
    private Map serviceAssociationsMap = new HashMap();
    private Map serviceStubsMap = new HashMap();
    private List<String> sessionAffinityServices = new ArrayList<String>();

    public ServiceMetadata() {
        this.init();
    }

    public String getServiceName(BaseClass baseClass) throws SDSServiceException {
        if (baseClass == null) {
            return null;
        }
        String associationsMapKey = null;
        try {
            associationsMapKey = baseClass.getObjectClass() != null ? baseClass.getObjectClass().getValue().toString() : null;
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(t.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving service for class [" + baseClass.getClass().getName() + "]");
            throw new SDSServiceException(I18NCode.SSV_NO_SERVICE_NAME);
        }
        return this.getServiceName(associationsMapKey);
    }

    public String getServiceName(AsynchSpecification spec) throws SDSServiceException {
        if (spec == null) {
            return null;
        }
        String associationsMapKey = null;
        try {
            String name = spec.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            associationsMapKey = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(t.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error retrieving service for class [" + spec.getClass().getName() + "]");
            throw new SDSServiceException(I18NCode.SSV_NO_SERVICE_NAME);
        }
        return this.getServiceName(associationsMapKey);
    }

    private String getServiceName(String associationsMapKey) {
        String serviceName = null;
        Object serviceAssociationObject = this.serviceAssociationsMap.get(associationsMapKey);
        if (serviceAssociationObject != null) {
            ServiceAssociation serviceAssociation = (ServiceAssociation)serviceAssociationObject;
            serviceName = serviceAssociation.getService();
        }
        return serviceName;
    }

    public String getStubImplClass(String serviceName) {
        return (String)this.serviceStubsMap.get(serviceName);
    }

    public List<String> getSessionAffinityServices() {
        ArrayList<String> copyOfSessionAffinityServices = new ArrayList<String>();
        copyOfSessionAffinityServices.addAll(this.sessionAffinityServices);
        return copyOfSessionAffinityServices;
    }

    private void init() {
        Document document = null;
        URL url = ServiceMetadata.class.getResource(SERVICE_METATDATA);
        if (url != null) {
            SAXReader reader = new SAXReader();
            try {
                document = reader.read(url);
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        if (document != null) {
            Element classNameNode = null;
            Element serviceNode = null;
            Element associations = (Element)document.selectSingleNode("//serviceMetadata/associations");
            Iterator i = associations.elementIterator("association");
            while (i.hasNext()) {
                Element association = (Element)i.next();
                classNameNode = association.element("class");
                serviceNode = association.element("service");
                this.serviceAssociationsMap.put(classNameNode.getText(), new ServiceAssociation(classNameNode.getText(), serviceNode.getText()));
            }
            Element serviceStubs = (Element)document.selectSingleNode("//serviceMetadata/serviceAPI");
            Element serviceNameNode = null;
            Element classNode = null;
            Iterator i2 = serviceStubs.elementIterator("stub");
            while (i2.hasNext()) {
                Element stub = (Element)i2.next();
                serviceNameNode = stub.element("service");
                classNode = stub.element("class");
                Attribute attrib = serviceNameNode.attribute("defaultToSessionAffinity");
                if (attrib != null && attrib.getText().equals("true")) {
                    this.sessionAffinityServices.add(serviceNameNode.getText());
                }
                this.serviceStubsMap.put(serviceNameNode.getText(), classNode.getText());
            }
        }
    }
}

