/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.sql.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class BatchPreparedStatement {
    private static final int MAX_CHARS = Short.MAX_VALUE;
    private static final int SAFETY_FACTOR = 10;
    private int m_chars;
    private Connection m_conn;
    private int m_numBatched;
    private PreparedStatement m_ps;
    private String m_sql;
    private ArrayList<Integer> m_updateCounts;

    public BatchPreparedStatement(Connection conn, String sql) throws SQLException {
        this.m_chars = sql.length();
        this.m_conn = conn;
        this.m_numBatched = 0;
        this.m_sql = sql;
        this.m_ps = this.m_conn.prepareStatement(this.m_sql);
        this.m_updateCounts = new ArrayList();
    }

    public void addBatch() throws SQLException {
        this.m_ps.addBatch();
        ++this.m_numBatched;
        int avgBatchChars = this.m_chars / this.m_numBatched;
        int safetyMargin = avgBatchChars * 10;
        if (this.m_chars + safetyMargin > Short.MAX_VALUE) {
            this.flushBatch();
        }
    }

    public void close() throws SQLException {
        this.m_ps.close();
    }

    private void flushBatch() throws SQLException {
        int[] updatedThisTime = this.m_ps.executeBatch();
        for (int i = 0; i < updatedThisTime.length; ++i) {
            this.m_updateCounts.add(updatedThisTime[i]);
        }
        this.m_chars = this.m_sql.length();
        this.m_numBatched = 0;
    }

    public boolean execute() throws SQLException {
        return this.m_ps.execute();
    }

    public int[] executeBatch() throws SQLException {
        this.flushBatch();
        int[] aggregateUpdateCounts = new int[this.m_updateCounts.size()];
        for (int i = 0; i < this.m_updateCounts.size(); ++i) {
            aggregateUpdateCounts[i] = this.m_updateCounts.get(i);
        }
        return aggregateUpdateCounts;
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.m_ps.setBoolean(parameterIndex, x);
        this.m_chars += 5;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.m_ps.setInt(parameterIndex, x);
        this.m_chars += Integer.valueOf(x).toString().length() + 1;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.m_ps.setString(parameterIndex, x);
        this.m_chars += x.length() + 3;
    }
}

