/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.sql.util;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandlerBase;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;

public class SQLExecuteHandler
extends SQLExecuteHandlerBase {
    private boolean m_readOnly = true;

    public SQLExecuteHandler(SDSCategory logCategory, boolean readOnly) {
        super(logCategory);
        this.m_readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeRetry(SQLExecute<T> sqlExecute) throws TaskPersistLayerException {
        boolean connectionCreated = false;
        try {
            connectionCreated = TaskPersistLayer.checkCreateConnection(this.m_readOnly, 2);
        }
        catch (TaskPersistLayerException e) {
            this.debugLog("Error obtaining a connection");
            this.debugLog(e);
            throw e;
        }
        if (!connectionCreated) {
            String className = sqlExecute.getClass().getName();
            String message = "SQLExecute [" + className + "]: is executing in an transaction!";
            this.debugLog(message);
            throw new IllegalStateException(message);
        }
        try {
            T t = this.executeImpl(sqlExecute);
            return t;
        }
        finally {
            TaskPersistLayer.checkCloseConnection();
        }
    }
}

