/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.sql.util;

import com.cognos.jsmcommon.jdbc.util.JDBCUtils;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.sql.util.ISQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteRetryHandler;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;

public abstract class SQLExecuteHandlerBase
implements ISQLExecuteHandler {
    protected boolean DEBUG = false;
    protected SDSCategory m_logCategory = JSMCommonCategory.RUNTIME;

    public SQLExecuteHandlerBase(SDSCategory logCategory) {
        this.m_logCategory = logCategory;
    }

    @Override
    public void debugLog(Exception e) {
        SDSLogger.getLogger(this.m_logCategory).debug(e, true);
        if (this.DEBUG) {
            try {
                FileWriter fw = new FileWriter("../logs/SQLTransactionExecutionHandler.log", true);
                PrintWriter pw = new PrintWriter(fw);
                pw.write("Exception is: " + e.getClass().getName());
                pw.println();
                pw.write(e.getLocalizedMessage());
                pw.println();
                e.printStackTrace(pw);
                pw.println();
                pw.flush();
                pw.close();
            }
            catch (IOException e1) {
                System.out.println(e1);
            }
        }
    }

    @Override
    public void debugLog(String message) {
        SDSLogger.getLogger(this.m_logCategory).debug(message);
        if (this.DEBUG) {
            try {
                FileWriter fw = new FileWriter("../logs/SQLTransactionExecutionHandler.log", true);
                PrintWriter pw = new PrintWriter(fw);
                pw.write(message);
                pw.println();
                pw.flush();
                pw.close();
            }
            catch (IOException e1) {
                System.out.println(e1);
            }
        }
    }

    @Override
    public <T> T execute(SQLExecute<T> sqlExecute) throws TaskPersistLayerException {
        boolean inTransaction = TaskPersistLayer.inTransaction();
        if (inTransaction) {
            return this.executeImpl(sqlExecute);
        }
        SQLExecuteRetryHandler retryHandler = new SQLExecuteRetryHandler(this.m_logCategory, this);
        return retryHandler.execute(sqlExecute);
    }

    public <T> T executeImpl(SQLExecute<T> sqlExecute) throws TaskPersistLayerException {
        try {
            return sqlExecute.execute();
        }
        catch (Exception e) {
            this.debugLog("Error executing a transaction!");
            this.debugLog(e);
            if (e instanceof TaskPersistLayerException) {
                throw (TaskPersistLayerException)e;
            }
            throw new TaskPersistLayerException(e);
        }
    }

    protected boolean isDeadlockException(Exception e) {
        Throwable nested;
        boolean isDeadlockException = false;
        if (e instanceof SQLException) {
            isDeadlockException = JDBCUtils.isDeadlockException((SQLException)e);
            this.debugLog("SQLException: Error code was " + ((SQLException)e).getErrorCode());
        } else if (e instanceof TaskPersistLayerException && (nested = ((TaskPersistLayerException)e).getNested()) instanceof SQLException) {
            isDeadlockException = JDBCUtils.isDeadlockException((SQLException)nested);
            this.debugLog("SQLException: Error code was " + ((SQLException)nested).getErrorCode());
        }
        return isDeadlockException;
    }
}

