/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.sql.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.sql.util.ISQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;

public class SQLExecuteRetryHandler
implements ISQLExecuteHandler {
    protected static int DEFAULT_MAX_RETRIES = 10;
    protected int m_maxRetries = DEFAULT_MAX_RETRIES;
    private ISQLExecuteHandler m_handler;

    public SQLExecuteRetryHandler(SDSCategory logCategory, ISQLExecuteHandler handler) {
        this.m_handler = handler;
        this.m_maxRetries = CRNProperties.getInstance().getIntProperty("transaction.max.retries", DEFAULT_MAX_RETRIES);
        if (this.m_maxRetries < 1) {
            this.m_maxRetries = DEFAULT_MAX_RETRIES;
        }
    }

    public SQLExecuteRetryHandler(ISQLExecuteHandler handler, int maxRetries) {
        this.m_handler = handler;
        this.m_maxRetries = maxRetries;
        if (this.m_maxRetries < 1) {
            this.m_maxRetries = DEFAULT_MAX_RETRIES;
        }
    }

    @Override
    public <T> T execute(SQLExecute<T> sqlExecute) throws TaskPersistLayerException {
        boolean retry = true;
        int retries = 0;
        T result = null;
        while (retry) {
            ++retries;
            try {
                result = this.m_handler.executeRetry(sqlExecute);
                retry = false;
                if (retries <= 1) continue;
                this.debugLog("SQL execution succeeded at retry " + (retries - 1));
            }
            catch (Exception e) {
                this.checkRetryTransaction(e, retries);
            }
        }
        return result;
    }

    protected void checkRetryTransaction(Exception e, int retries) throws TaskPersistLayerException {
        if (retries >= this.m_maxRetries) {
            String errStr = "Max retries exceeded! [max=" + this.m_maxRetries + "] rethrowing exception: " + e.getLocalizedMessage();
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{errStr});
            TaskPersistLayer.throwException(e);
        } else {
            int sleepTime = (int)(Math.random() * 1000.0);
            this.debugLog("Will retry in " + sleepTime + " [milliseconds]. This will be retry " + retries);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void debugLog(Exception e) {
        this.m_handler.debugLog(e);
    }

    @Override
    public void debugLog(String message) {
        this.m_handler.debugLog(message);
    }

    public Object executeRetry(SQLExecute sqlExecute) throws TaskPersistLayerException {
        return null;
    }
}

